/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;

public class LogAggregationTestUtils {
    public static final String REMOTE_LOG_ROOT = "target/app-logs/";

    public static void enableFileControllers(Configuration conf, List<Class<? extends LogAggregationFileController>> fileControllers, List<String> fileControllerNames) {
        LogAggregationTestUtils.enableFcs(conf, REMOTE_LOG_ROOT, fileControllers, fileControllerNames);
    }

    public static void enableFileControllers(Configuration conf, String remoteLogRoot, List<Class<? extends LogAggregationFileController>> fileControllers, List<String> fileControllerNames) {
        LogAggregationTestUtils.enableFcs(conf, remoteLogRoot, fileControllers, fileControllerNames);
    }

    private static void enableFcs(Configuration conf, String remoteLogRoot, List<Class<? extends LogAggregationFileController>> fileControllers, List<String> fileControllerNames) {
        conf.set("yarn.log-aggregation.file-formats", StringUtils.join(fileControllerNames, (String)","));
        for (int i = 0; i < fileControllers.size(); ++i) {
            Class<? extends LogAggregationFileController> fileController = fileControllers.get(i);
            String controllerName = fileControllerNames.get(i);
            conf.setClass(String.format("yarn.log-aggregation.file-controller.%s.class", controllerName), fileController, LogAggregationFileController.class);
            conf.set(String.format("yarn.log-aggregation.%s.remote-app-log-dir", controllerName), remoteLogRoot + controllerName + "/");
            conf.set(String.format("yarn.log-aggregation.%s.remote-app-log-dir-suffix", controllerName), controllerName);
        }
    }
}

