/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.hamlet2;

import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParseSelector {
    @Test
    void testNormal() {
        String[] res = HamletImpl.parseSelector((String)"#id.class");
        Assertions.assertEquals((Object)"id", (Object)res[0]);
        Assertions.assertEquals((Object)"class", (Object)res[1]);
    }

    @Test
    void testMultiClass() {
        String[] res = HamletImpl.parseSelector((String)"#id.class1.class2");
        Assertions.assertEquals((Object)"id", (Object)res[0]);
        Assertions.assertEquals((Object)"class1 class2", (Object)res[1]);
    }

    @Test
    void testMissingId() {
        String[] res = HamletImpl.parseSelector((String)".class");
        Assertions.assertNull((Object)res[0]);
        Assertions.assertEquals((Object)"class", (Object)res[1]);
    }

    @Test
    void testMissingClass() {
        String[] res = HamletImpl.parseSelector((String)"#id");
        Assertions.assertEquals((Object)"id", (Object)res[0]);
        Assertions.assertNull((Object)res[1]);
    }

    @Test
    void testMissingAll() {
        Assertions.assertThrows(WebAppException.class, () -> HamletImpl.parseSelector((String)""));
    }
}

