/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.hadoop.util.GenericsUtil;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.util.AdHocLogDumper;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAdHocLogDumper {
    private static final Logger LOG = LoggerFactory.getLogger(TestAdHocLogDumper.class);

    @Test
    void testDumpingSchedulerLogs() throws Exception {
        boolean del;
        HashMap<AppenderSkeleton, Priority> levels = new HashMap<AppenderSkeleton, Priority>();
        String logFilename = "test.log";
        Logger logger = LoggerFactory.getLogger(TestAdHocLogDumper.class);
        if (GenericsUtil.isLog4jLogger(this.getClass())) {
            Enumeration appenders = LogManager.getRootLogger().getAllAppenders();
            while (appenders.hasMoreElements()) {
                Object obj = appenders.nextElement();
                if (!(obj instanceof AppenderSkeleton)) continue;
                AppenderSkeleton appender = (AppenderSkeleton)obj;
                levels.put(appender, appender.getThreshold());
            }
        }
        AdHocLogDumper dumper = new AdHocLogDumper(this.getClass().getName(), logFilename);
        dumper.dumpLogs("DEBUG", 1000);
        LOG.debug("test message 1");
        LOG.info("test message 2");
        File logFile = new File(logFilename);
        Assertions.assertTrue((boolean)logFile.exists());
        Thread.sleep(2000L);
        long lastWrite = logFile.lastModified();
        Assertions.assertTrue((lastWrite < Time.now() ? 1 : 0) != 0);
        Assertions.assertTrue((logFile.length() != 0L ? 1 : 0) != 0);
        if (GenericsUtil.isLog4jLogger(this.getClass())) {
            Enumeration appenders = LogManager.getRootLogger().getAllAppenders();
            while (appenders.hasMoreElements()) {
                Object obj = appenders.nextElement();
                if (!(obj instanceof AppenderSkeleton)) continue;
                AppenderSkeleton appender = (AppenderSkeleton)obj;
                Assertions.assertEquals(levels.get(appender), (Object)appender.getThreshold());
            }
        }
        if (!(del = logFile.delete())) {
            LOG.info("Couldn't clean up after test");
        }
    }
}

