/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import java.util.Iterator;
import org.apache.hadoop.yarn.api.pb.PlacementConstraintFromProtoConverter;
import org.apache.hadoop.yarn.api.pb.PlacementConstraintToProtoConverter;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPlacementConstraintPBConversion {
    @Test
    void testTargetConstraintProtoConverter() {
        PlacementConstraint.AbstractConstraint sConstraintExpr = PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})});
        Assertions.assertTrue((boolean)(sConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
        PlacementConstraint sConstraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)sConstraintExpr);
        PlacementConstraintToProtoConverter toProtoConverter = new PlacementConstraintToProtoConverter(sConstraint);
        YarnProtos.PlacementConstraintProto protoConstraint = toProtoConverter.convert();
        Assertions.assertTrue((boolean)protoConstraint.hasSimpleConstraint());
        Assertions.assertFalse((boolean)protoConstraint.hasCompositeConstraint());
        YarnProtos.SimplePlacementConstraintProto sProto = protoConstraint.getSimpleConstraint();
        Assertions.assertEquals((Object)single.getScope(), (Object)sProto.getScope());
        Assertions.assertEquals((int)single.getMinCardinality(), (int)sProto.getMinCardinality());
        Assertions.assertEquals((int)single.getMaxCardinality(), (int)sProto.getMaxCardinality());
        Assertions.assertEquals((int)single.getTargetExpressions().size(), (int)sProto.getTargetExpressionsList().size());
        PlacementConstraintFromProtoConverter fromProtoConverter = new PlacementConstraintFromProtoConverter(protoConstraint);
        PlacementConstraint newConstraint = fromProtoConverter.convert();
        PlacementConstraint.AbstractConstraint newConstraintExpr = newConstraint.getConstraintExpr();
        Assertions.assertTrue((boolean)(newConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint newSingle = (PlacementConstraint.SingleConstraint)newConstraintExpr;
        Assertions.assertEquals((Object)single.getScope(), (Object)newSingle.getScope());
        Assertions.assertEquals((int)single.getMinCardinality(), (int)newSingle.getMinCardinality());
        Assertions.assertEquals((int)single.getMaxCardinality(), (int)newSingle.getMaxCardinality());
        Assertions.assertEquals((Object)single.getTargetExpressions(), (Object)newSingle.getTargetExpressions());
    }

    @Test
    void testCardinalityConstraintProtoConverter() {
        PlacementConstraint.AbstractConstraint sConstraintExpr = PlacementConstraints.cardinality((String)"rack", (int)3, (int)10, (String[])new String[0]);
        Assertions.assertTrue((boolean)(sConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
        PlacementConstraint sConstraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)sConstraintExpr);
        PlacementConstraintToProtoConverter toProtoConverter = new PlacementConstraintToProtoConverter(sConstraint);
        YarnProtos.PlacementConstraintProto protoConstraint = toProtoConverter.convert();
        this.compareSimpleConstraintToProto(single, protoConstraint);
        PlacementConstraintFromProtoConverter fromProtoConverter = new PlacementConstraintFromProtoConverter(protoConstraint);
        PlacementConstraint newConstraint = fromProtoConverter.convert();
        PlacementConstraint.AbstractConstraint newConstraintExpr = newConstraint.getConstraintExpr();
        Assertions.assertTrue((boolean)(newConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint newSingle = (PlacementConstraint.SingleConstraint)newConstraintExpr;
        this.compareSimpleConstraints(single, newSingle);
    }

    @Test
    void testCompositeConstraintProtoConverter() {
        PlacementConstraint.Or constraintExpr = PlacementConstraints.or((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"rack", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"spark"})}), PlacementConstraints.maxCardinality((String)"node", (int)3, (String[])new String[0]), PlacementConstraints.targetCardinality((String)"rack", (int)2, (int)10, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"zk"})})});
        Assertions.assertTrue((boolean)(constraintExpr instanceof PlacementConstraint.Or));
        PlacementConstraint constraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)constraintExpr);
        PlacementConstraint.Or orExpr = constraintExpr;
        PlacementConstraintToProtoConverter toProtoConverter = new PlacementConstraintToProtoConverter(constraint);
        YarnProtos.PlacementConstraintProto protoConstraint = toProtoConverter.convert();
        Assertions.assertFalse((boolean)protoConstraint.hasSimpleConstraint());
        Assertions.assertTrue((boolean)protoConstraint.hasCompositeConstraint());
        YarnProtos.CompositePlacementConstraintProto cProto = protoConstraint.getCompositeConstraint();
        Assertions.assertEquals((Object)YarnProtos.CompositePlacementConstraintProto.CompositeType.OR, (Object)cProto.getCompositeType());
        Assertions.assertEquals((int)3, (int)cProto.getChildConstraintsCount());
        Assertions.assertEquals((int)0, (int)cProto.getTimedChildConstraintsCount());
        Iterator orChildren = orExpr.getChildren().iterator();
        Iterator orProtoChildren = cProto.getChildConstraintsList().iterator();
        while (orChildren.hasNext() && orProtoChildren.hasNext()) {
            PlacementConstraint.AbstractConstraint orChild = (PlacementConstraint.AbstractConstraint)orChildren.next();
            YarnProtos.PlacementConstraintProto orProtoChild = (YarnProtos.PlacementConstraintProto)orProtoChildren.next();
            this.compareSimpleConstraintToProto((PlacementConstraint.SingleConstraint)orChild, orProtoChild);
        }
        PlacementConstraintFromProtoConverter fromProtoConverter = new PlacementConstraintFromProtoConverter(protoConstraint);
        PlacementConstraint newConstraint = fromProtoConverter.convert();
        PlacementConstraint.AbstractConstraint newConstraintExpr = newConstraint.getConstraintExpr();
        Assertions.assertTrue((boolean)(newConstraintExpr instanceof PlacementConstraint.Or));
        PlacementConstraint.Or newOrExpr = (PlacementConstraint.Or)newConstraintExpr;
        Assertions.assertEquals((int)3, (int)newOrExpr.getChildren().size());
        orChildren = orExpr.getChildren().iterator();
        Iterator newOrChildren = newOrExpr.getChildren().iterator();
        while (orChildren.hasNext() && newOrChildren.hasNext()) {
            PlacementConstraint.AbstractConstraint orChild = (PlacementConstraint.AbstractConstraint)orChildren.next();
            PlacementConstraint.AbstractConstraint newOrChild = (PlacementConstraint.AbstractConstraint)newOrChildren.next();
            this.compareSimpleConstraints((PlacementConstraint.SingleConstraint)orChild, (PlacementConstraint.SingleConstraint)newOrChild);
        }
    }

    private void compareSimpleConstraintToProto(PlacementConstraint.SingleConstraint constraint, YarnProtos.PlacementConstraintProto proto) {
        Assertions.assertTrue((boolean)proto.hasSimpleConstraint());
        Assertions.assertFalse((boolean)proto.hasCompositeConstraint());
        YarnProtos.SimplePlacementConstraintProto sProto = proto.getSimpleConstraint();
        Assertions.assertEquals((Object)constraint.getScope(), (Object)sProto.getScope());
        Assertions.assertEquals((int)constraint.getMinCardinality(), (int)sProto.getMinCardinality());
        Assertions.assertEquals((int)constraint.getMaxCardinality(), (int)sProto.getMaxCardinality());
        Assertions.assertEquals((int)constraint.getTargetExpressions().size(), (int)sProto.getTargetExpressionsList().size());
    }

    private void compareSimpleConstraints(PlacementConstraint.SingleConstraint single, PlacementConstraint.SingleConstraint newSingle) {
        Assertions.assertEquals((Object)single.getScope(), (Object)newSingle.getScope());
        Assertions.assertEquals((int)single.getMinCardinality(), (int)newSingle.getMinCardinality());
        Assertions.assertEquals((int)single.getMaxCardinality(), (int)newSingle.getMaxCardinality());
        Assertions.assertEquals((Object)single.getTargetExpressions(), (Object)newSingle.getTargetExpressions());
    }
}

