/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.yarn.util.Times;
import org.junit.Assert;
import org.junit.Test;

public class TestTimes {
    @Test
    public void testNegativeStartTimes() {
        long elapsed = Times.elapsed((long)-5L, (long)10L, (boolean)true);
        Assert.assertEquals((String)"Elapsed time is not 0", (long)0L, (long)elapsed);
        elapsed = Times.elapsed((long)-5L, (long)10L, (boolean)false);
        Assert.assertEquals((String)"Elapsed time is not -1", (long)-1L, (long)elapsed);
    }

    @Test
    public void testNegativeFinishTimes() {
        long elapsed = Times.elapsed((long)5L, (long)-10L, (boolean)false);
        Assert.assertEquals((String)"Elapsed time is not -1", (long)-1L, (long)elapsed);
    }

    @Test
    public void testNegativeStartandFinishTimes() {
        long elapsed = Times.elapsed((long)-5L, (long)-10L, (boolean)false);
        Assert.assertEquals((String)"Elapsed time is not -1", (long)-1L, (long)elapsed);
    }

    @Test
    public void testPositiveStartandFinishTimes() {
        long elapsed = Times.elapsed((long)5L, (long)10L, (boolean)true);
        Assert.assertEquals((String)"Elapsed time is not 5", (long)5L, (long)elapsed);
        elapsed = Times.elapsed((long)5L, (long)10L, (boolean)false);
        Assert.assertEquals((String)"Elapsed time is not 5", (long)5L, (long)elapsed);
    }

    @Test
    public void testFinishTimesAheadOfStartTimes() {
        long elapsed = Times.elapsed((long)10L, (long)5L, (boolean)true);
        Assert.assertEquals((String)"Elapsed time is not -1", (long)-1L, (long)elapsed);
        elapsed = Times.elapsed((long)10L, (long)5L, (boolean)false);
        Assert.assertEquals((String)"Elapsed time is not -1", (long)-1L, (long)elapsed);
        elapsed = Times.elapsed((long)Long.MAX_VALUE, (long)0L, (boolean)true);
        Assert.assertEquals((String)"Elapsed time is not -1", (long)-1L, (long)elapsed);
    }

    @Test
    public void validateISO() throws IOException {
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        for (int i = 0; i < 1000; ++i) {
            long now = System.currentTimeMillis();
            String instant = Times.formatISO8601((long)now);
            String date = isoFormat.format(new Date(now));
            Assert.assertEquals((Object)date, (Object)instant);
        }
    }
}

