/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import java.io.FileNotFoundException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestLogAggregationFileController {
    @Test
    public void testRemoteDirCreationDefault() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doReturn((Object)new URI("")).when((Object)fs)).getUri();
        ((FileSystem)Mockito.doThrow(FileNotFoundException.class).when((Object)fs)).getFileStatus((Path)ArgumentMatchers.any(Path.class));
        Configuration conf = new Configuration();
        LogAggregationFileController controller = (LogAggregationFileController)Mockito.mock(LogAggregationFileController.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ((LogAggregationFileController)Mockito.doReturn((Object)fs).when((Object)controller)).getFileSystem((Configuration)ArgumentMatchers.any(Configuration.class));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"yarn_user", (String[])new String[]{"yarn_group", "other_group"});
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        controller.initialize(conf, "TFile");
        controller.verifyAndCreateRemoteLogDir();
        ((FileSystem)Mockito.verify((Object)fs)).setOwner((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"yarn_user"), (String)ArgumentMatchers.eq((Object)"yarn_group"));
    }

    @Test
    public void testRemoteDirCreationWithCustomGroup() throws Exception {
        String testGroupName = "testGroup";
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doReturn((Object)new URI("")).when((Object)fs)).getUri();
        ((FileSystem)Mockito.doThrow(FileNotFoundException.class).when((Object)fs)).getFileStatus((Path)ArgumentMatchers.any(Path.class));
        Configuration conf = new Configuration();
        conf.set("yarn.nodemanager.remote-app-log-dir.groupname", testGroupName);
        LogAggregationFileController controller = (LogAggregationFileController)Mockito.mock(LogAggregationFileController.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ((LogAggregationFileController)Mockito.doReturn((Object)fs).when((Object)controller)).getFileSystem((Configuration)ArgumentMatchers.any(Configuration.class));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"yarn_user", (String[])new String[]{"yarn_group", "other_group"});
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        controller.initialize(conf, "TFile");
        controller.verifyAndCreateRemoteLogDir();
        ((FileSystem)Mockito.verify((Object)fs)).setOwner((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"yarn_user"), (String)ArgumentMatchers.eq((Object)testGroupName));
    }

    @Test
    public void testRemoteDirCreationWithCustomUser() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doReturn((Object)new URI("")).when((Object)fs)).getUri();
        ((FileSystem)Mockito.doReturn((Object)new FileStatus(128L, false, 0, 64L, System.currentTimeMillis(), System.currentTimeMillis(), new FsPermission(LogAggregationFileController.TLDIR_PERMISSIONS), "not_yarn_user", "yarn_group", new Path("/tmp/logs"))).when((Object)fs)).getFileStatus((Path)ArgumentMatchers.any(Path.class));
        Configuration conf = new Configuration();
        LogAggregationFileController controller = (LogAggregationFileController)Mockito.mock(LogAggregationFileController.class, (Answer)Mockito.CALLS_REAL_METHODS);
        controller.fsSupportsChmod = true;
        ((LogAggregationFileController)Mockito.doReturn((Object)fs).when((Object)controller)).getFileSystem((Configuration)ArgumentMatchers.any(Configuration.class));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"yarn_user", (String[])new String[]{"yarn_group", "other_group"});
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        controller.initialize(conf, "TFile");
        controller.verifyAndCreateRemoteLogDir();
        ((FileSystem)Mockito.verify((Object)fs)).createNewFile((Path)ArgumentMatchers.argThat((ArgumentMatcher)new PathContainsString(".permission_check")));
        ((FileSystem)Mockito.verify((Object)fs)).setPermission((Path)ArgumentMatchers.argThat((ArgumentMatcher)new PathContainsString(".permission_check")), (FsPermission)ArgumentMatchers.eq((Object)new FsPermission(LogAggregationFileController.TLDIR_PERMISSIONS)));
        ((FileSystem)Mockito.verify((Object)fs)).delete((Path)ArgumentMatchers.argThat((ArgumentMatcher)new PathContainsString(".permission_check")), ArgumentMatchers.eq((boolean)false));
        Assert.assertTrue((boolean)controller.fsSupportsChmod);
    }

    private static class PathContainsString
    implements ArgumentMatcher<Path> {
        private final String expected;

        PathContainsString(String expected) {
            this.expected = expected;
        }

        public boolean matches(Path path) {
            return path.getName().contains(this.expected);
        }

        public String toString() {
            return "Path with name=" + this.expected;
        }
    }
}

