/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.client.api.TimelineReaderClient;
import org.apache.hadoop.yarn.client.api.impl.TimelineReaderClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTimelineReaderClientImpl {
    private final String appAttemptInfoFilter = "{\"type\":\"YARN_APPLICATION_ATTEMPT\",\"id\":\"appattempt_1234_0001_000001\"}";
    private TimelineReaderClient client;

    @Before
    public void setup() {
        this.client = new MockTimelineReaderClient();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setFloat("yarn.timeline-service.version", 2.0f);
        this.client.init((Configuration)conf);
        this.client.start();
    }

    @Test
    public void testGetApplication() throws Exception {
        ApplicationId applicationId = ApplicationId.fromString((String)"application_1234_0001");
        TimelineEntity entity = this.client.getApplicationEntity(applicationId, null, null);
        Assert.assertEquals((Object)"mockApp1", (Object)entity.getId());
    }

    @Test
    public void getApplicationAttemptEntity() throws Exception {
        ApplicationAttemptId attemptId = ApplicationAttemptId.fromString((String)"appattempt_1234_0001_000001");
        TimelineEntity entity = this.client.getApplicationAttemptEntity(attemptId, null, null);
        Assert.assertEquals((Object)"mockAppAttempt1", (Object)entity.getId());
    }

    @Test
    public void getApplicationAttemptEntities() throws Exception {
        ApplicationId applicationId = ApplicationId.fromString((String)"application_1234_0001");
        List entities = this.client.getApplicationAttemptEntities(applicationId, null, null, 0L, null);
        Assert.assertEquals((long)2L, (long)entities.size());
        Assert.assertEquals((Object)"mockAppAttempt2", (Object)((TimelineEntity)entities.get(1)).getId());
    }

    @Test
    public void testGetContainer() throws Exception {
        ContainerId containerId = ContainerId.fromString((String)"container_1234_0001_01_000001");
        TimelineEntity entity = this.client.getContainerEntity(containerId, null, null);
        Assert.assertEquals((Object)"mockContainer1", (Object)entity.getId());
    }

    @Test
    public void testGetContainers() throws Exception {
        ApplicationId appId = ApplicationId.fromString((String)"application_1234_0001");
        List entities = this.client.getContainerEntities(appId, null, null, 0L, null);
        Assert.assertEquals((long)2L, (long)entities.size());
        Assert.assertEquals((Object)"mockContainer2", (Object)((TimelineEntity)entities.get(1)).getId());
    }

    @Test
    public void testGetContainersForAppAttempt() throws Exception {
        ApplicationId appId = ApplicationId.fromString((String)"application_1234_0001");
        List entities = this.client.getContainerEntities(appId, null, (Map)ImmutableMap.of((Object)"infofilters", (Object)"{\"type\":\"YARN_APPLICATION_ATTEMPT\",\"id\":\"appattempt_1234_0001_000001\"}"), 0L, null);
        Assert.assertEquals((long)2L, (long)entities.size());
        Assert.assertEquals((Object)"mockContainer4", (Object)((TimelineEntity)entities.get(1)).getId());
    }

    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    private static TimelineEntity createTimelineEntity(String id) {
        TimelineEntity entity = new TimelineEntity();
        entity.setId(id);
        return entity;
    }

    private static TimelineEntity[] createTimelineEntities(String ... ids) {
        ArrayList<TimelineEntity> entities = new ArrayList<TimelineEntity>();
        for (String id : ids) {
            TimelineEntity entity = new TimelineEntity();
            entity.setId(id);
            entities.add(entity);
        }
        return entities.toArray(new TimelineEntity[entities.size()]);
    }

    private class MockTimelineReaderClient
    extends TimelineReaderClientImpl {
        private MockTimelineReaderClient() {
        }

        protected ClientResponse doGetUri(URI base, String path, MultivaluedMap<String, String> params) throws IOException {
            ClientResponse mockClientResponse = (ClientResponse)Mockito.mock(ClientResponse.class);
            if (path.contains(TimelineEntityType.YARN_CONTAINER.toString()) && !params.containsKey((Object)"infofilters")) {
                Mockito.when((Object)((TimelineEntity)mockClientResponse.getEntity(TimelineEntity.class))).thenReturn((Object)TestTimelineReaderClientImpl.createTimelineEntity("mockContainer1"));
                Mockito.when((Object)((TimelineEntity[])mockClientResponse.getEntity(TimelineEntity[].class))).thenReturn((Object)TestTimelineReaderClientImpl.createTimelineEntities(new String[]{"mockContainer1", "mockContainer2"}));
            } else if (path.contains(TimelineEntityType.YARN_CONTAINER.toString()) && params.containsKey((Object)"infofilters")) {
                Assert.assertEquals((Object)this.encodeValue("{\"type\":\"YARN_APPLICATION_ATTEMPT\",\"id\":\"appattempt_1234_0001_000001\"}"), ((List)params.get((Object)"infofilters")).get(0));
                Mockito.when((Object)((TimelineEntity[])mockClientResponse.getEntity(TimelineEntity[].class))).thenReturn((Object)TestTimelineReaderClientImpl.createTimelineEntities(new String[]{"mockContainer3", "mockContainer4"}));
            } else if (path.contains(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString())) {
                Mockito.when((Object)((TimelineEntity)mockClientResponse.getEntity(TimelineEntity.class))).thenReturn((Object)TestTimelineReaderClientImpl.createTimelineEntity("mockAppAttempt1"));
                Mockito.when((Object)((TimelineEntity[])mockClientResponse.getEntity(TimelineEntity[].class))).thenReturn((Object)TestTimelineReaderClientImpl.createTimelineEntities(new String[]{"mockAppAttempt1", "mockAppAttempt2"}));
            } else {
                Mockito.when((Object)((TimelineEntity)mockClientResponse.getEntity(TimelineEntity.class))).thenReturn((Object)TestTimelineReaderClientImpl.createTimelineEntity("mockApp1"));
                Mockito.when((Object)((TimelineEntity[])mockClientResponse.getEntity(TimelineEntity[].class))).thenReturn((Object)TestTimelineReaderClientImpl.createTimelineEntities(new String[]{"mockApp1", "mockApp2"}));
            }
            return mockClientResponse;
        }
    }
}

