/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import java.util.Iterator;
import org.apache.hadoop.yarn.api.pb.PlacementConstraintFromProtoConverter;
import org.apache.hadoop.yarn.api.pb.PlacementConstraintToProtoConverter;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestPlacementConstraintPBConversion {
    @Test
    public void testTargetConstraintProtoConverter() {
        PlacementConstraint.AbstractConstraint sConstraintExpr = PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})});
        Assert.assertTrue((boolean)(sConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
        PlacementConstraint sConstraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)sConstraintExpr);
        PlacementConstraintToProtoConverter toProtoConverter = new PlacementConstraintToProtoConverter(sConstraint);
        YarnProtos.PlacementConstraintProto protoConstraint = toProtoConverter.convert();
        Assert.assertTrue((boolean)protoConstraint.hasSimpleConstraint());
        Assert.assertFalse((boolean)protoConstraint.hasCompositeConstraint());
        YarnProtos.SimplePlacementConstraintProto sProto = protoConstraint.getSimpleConstraint();
        Assert.assertEquals((Object)single.getScope(), (Object)sProto.getScope());
        Assert.assertEquals((long)single.getMinCardinality(), (long)sProto.getMinCardinality());
        Assert.assertEquals((long)single.getMaxCardinality(), (long)sProto.getMaxCardinality());
        Assert.assertEquals((long)single.getTargetExpressions().size(), (long)sProto.getTargetExpressionsList().size());
        PlacementConstraintFromProtoConverter fromProtoConverter = new PlacementConstraintFromProtoConverter(protoConstraint);
        PlacementConstraint newConstraint = fromProtoConverter.convert();
        PlacementConstraint.AbstractConstraint newConstraintExpr = newConstraint.getConstraintExpr();
        Assert.assertTrue((boolean)(newConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint newSingle = (PlacementConstraint.SingleConstraint)newConstraintExpr;
        Assert.assertEquals((Object)single.getScope(), (Object)newSingle.getScope());
        Assert.assertEquals((long)single.getMinCardinality(), (long)newSingle.getMinCardinality());
        Assert.assertEquals((long)single.getMaxCardinality(), (long)newSingle.getMaxCardinality());
        Assert.assertEquals((Object)single.getTargetExpressions(), (Object)newSingle.getTargetExpressions());
    }

    @Test
    public void testCardinalityConstraintProtoConverter() {
        PlacementConstraint.AbstractConstraint sConstraintExpr = PlacementConstraints.cardinality((String)"rack", (int)3, (int)10, (String[])new String[0]);
        Assert.assertTrue((boolean)(sConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint single = (PlacementConstraint.SingleConstraint)sConstraintExpr;
        PlacementConstraint sConstraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)sConstraintExpr);
        PlacementConstraintToProtoConverter toProtoConverter = new PlacementConstraintToProtoConverter(sConstraint);
        YarnProtos.PlacementConstraintProto protoConstraint = toProtoConverter.convert();
        this.compareSimpleConstraintToProto(single, protoConstraint);
        PlacementConstraintFromProtoConverter fromProtoConverter = new PlacementConstraintFromProtoConverter(protoConstraint);
        PlacementConstraint newConstraint = fromProtoConverter.convert();
        PlacementConstraint.AbstractConstraint newConstraintExpr = newConstraint.getConstraintExpr();
        Assert.assertTrue((boolean)(newConstraintExpr instanceof PlacementConstraint.SingleConstraint));
        PlacementConstraint.SingleConstraint newSingle = (PlacementConstraint.SingleConstraint)newConstraintExpr;
        this.compareSimpleConstraints(single, newSingle);
    }

    @Test
    public void testCompositeConstraintProtoConverter() {
        PlacementConstraint.Or constraintExpr = PlacementConstraints.or((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"rack", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"spark"})}), PlacementConstraints.maxCardinality((String)"node", (int)3, (String[])new String[0]), PlacementConstraints.targetCardinality((String)"rack", (int)2, (int)10, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"zk"})})});
        Assert.assertTrue((boolean)(constraintExpr instanceof PlacementConstraint.Or));
        PlacementConstraint constraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)constraintExpr);
        PlacementConstraint.Or orExpr = constraintExpr;
        PlacementConstraintToProtoConverter toProtoConverter = new PlacementConstraintToProtoConverter(constraint);
        YarnProtos.PlacementConstraintProto protoConstraint = toProtoConverter.convert();
        Assert.assertFalse((boolean)protoConstraint.hasSimpleConstraint());
        Assert.assertTrue((boolean)protoConstraint.hasCompositeConstraint());
        YarnProtos.CompositePlacementConstraintProto cProto = protoConstraint.getCompositeConstraint();
        Assert.assertEquals((Object)YarnProtos.CompositePlacementConstraintProto.CompositeType.OR, (Object)cProto.getCompositeType());
        Assert.assertEquals((long)3L, (long)cProto.getChildConstraintsCount());
        Assert.assertEquals((long)0L, (long)cProto.getTimedChildConstraintsCount());
        Iterator orChildren = orExpr.getChildren().iterator();
        Iterator orProtoChildren = cProto.getChildConstraintsList().iterator();
        while (orChildren.hasNext() && orProtoChildren.hasNext()) {
            PlacementConstraint.AbstractConstraint orChild = (PlacementConstraint.AbstractConstraint)orChildren.next();
            YarnProtos.PlacementConstraintProto orProtoChild = (YarnProtos.PlacementConstraintProto)orProtoChildren.next();
            this.compareSimpleConstraintToProto((PlacementConstraint.SingleConstraint)orChild, orProtoChild);
        }
        PlacementConstraintFromProtoConverter fromProtoConverter = new PlacementConstraintFromProtoConverter(protoConstraint);
        PlacementConstraint newConstraint = fromProtoConverter.convert();
        PlacementConstraint.AbstractConstraint newConstraintExpr = newConstraint.getConstraintExpr();
        Assert.assertTrue((boolean)(newConstraintExpr instanceof PlacementConstraint.Or));
        PlacementConstraint.Or newOrExpr = (PlacementConstraint.Or)newConstraintExpr;
        Assert.assertEquals((long)3L, (long)newOrExpr.getChildren().size());
        orChildren = orExpr.getChildren().iterator();
        Iterator newOrChildren = newOrExpr.getChildren().iterator();
        while (orChildren.hasNext() && newOrChildren.hasNext()) {
            PlacementConstraint.AbstractConstraint orChild = (PlacementConstraint.AbstractConstraint)orChildren.next();
            PlacementConstraint.AbstractConstraint newOrChild = (PlacementConstraint.AbstractConstraint)newOrChildren.next();
            this.compareSimpleConstraints((PlacementConstraint.SingleConstraint)orChild, (PlacementConstraint.SingleConstraint)newOrChild);
        }
    }

    private void compareSimpleConstraintToProto(PlacementConstraint.SingleConstraint constraint, YarnProtos.PlacementConstraintProto proto) {
        Assert.assertTrue((boolean)proto.hasSimpleConstraint());
        Assert.assertFalse((boolean)proto.hasCompositeConstraint());
        YarnProtos.SimplePlacementConstraintProto sProto = proto.getSimpleConstraint();
        Assert.assertEquals((Object)constraint.getScope(), (Object)sProto.getScope());
        Assert.assertEquals((long)constraint.getMinCardinality(), (long)sProto.getMinCardinality());
        Assert.assertEquals((long)constraint.getMaxCardinality(), (long)sProto.getMaxCardinality());
        Assert.assertEquals((long)constraint.getTargetExpressions().size(), (long)sProto.getTargetExpressionsList().size());
    }

    private void compareSimpleConstraints(PlacementConstraint.SingleConstraint single, PlacementConstraint.SingleConstraint newSingle) {
        Assert.assertEquals((Object)single.getScope(), (Object)newSingle.getScope());
        Assert.assertEquals((long)single.getMinCardinality(), (long)newSingle.getMinCardinality());
        Assert.assertEquals((long)single.getMaxCardinality(), (long)newSingle.getMaxCardinality());
        Assert.assertEquals((Object)single.getTargetExpressions(), (Object)newSingle.getTargetExpressions());
    }
}

