/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.nio.ByteBuffer;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.security.DockerCredentialTokenIdentifier;
import org.apache.hadoop.yarn.util.DockerClientConfigHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDockerClientConfigHandler {
    public static final String JSON = "{\"auths\": {\"https://index.docker.io/v1/\": {\"auth\": \"foobarbaz\"},\"registry.example.com\": {\"auth\": \"bazbarfoo\"}}}";
    private static final String APPLICATION_ID = "application_2313_2131341";
    private File file;
    private Configuration conf = new Configuration();

    @Before
    public void setUp() throws Exception {
        this.file = File.createTempFile("docker-client-config", "test");
        this.file.deleteOnExit();
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.file));
        bw.write(JSON);
        bw.close();
    }

    @Test
    public void testReadCredentialsFromConfigFile() throws Exception {
        Credentials credentials = DockerClientConfigHandler.readCredentialsFromConfigFile((Path)new Path(this.file.toURI()), (Configuration)this.conf, (String)APPLICATION_ID);
        Token token1 = credentials.getToken(new Text("https://index.docker.io/v1/-application_2313_2131341"));
        Assert.assertEquals((Object)DockerCredentialTokenIdentifier.KIND, (Object)token1.getKind());
        Assert.assertEquals((Object)"foobarbaz", (Object)new String(token1.getPassword()));
        DockerCredentialTokenIdentifier ti1 = (DockerCredentialTokenIdentifier)token1.decodeIdentifier();
        Assert.assertEquals((Object)"https://index.docker.io/v1/", (Object)ti1.getRegistryUrl());
        Assert.assertEquals((Object)APPLICATION_ID, (Object)ti1.getApplicationId());
        Token token2 = credentials.getToken(new Text("registry.example.com-application_2313_2131341"));
        Assert.assertEquals((Object)DockerCredentialTokenIdentifier.KIND, (Object)token2.getKind());
        Assert.assertEquals((Object)"bazbarfoo", (Object)new String(token2.getPassword()));
        DockerCredentialTokenIdentifier ti2 = (DockerCredentialTokenIdentifier)token2.decodeIdentifier();
        Assert.assertEquals((Object)"registry.example.com", (Object)ti2.getRegistryUrl());
        Assert.assertEquals((Object)APPLICATION_ID, (Object)ti2.getApplicationId());
    }

    @Test
    public void testGetCredentialsFromTokensByteBuffer() throws Exception {
        Credentials credentials = DockerClientConfigHandler.readCredentialsFromConfigFile((Path)new Path(this.file.toURI()), (Configuration)this.conf, (String)APPLICATION_ID);
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer tokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        Credentials credentialsOut = DockerClientConfigHandler.getCredentialsFromTokensByteBuffer((ByteBuffer)tokens);
        Assert.assertEquals((long)credentials.numberOfTokens(), (long)credentialsOut.numberOfTokens());
        for (Token tkIn : credentials.getAllTokens()) {
            DockerCredentialTokenIdentifier ti = (DockerCredentialTokenIdentifier)tkIn.decodeIdentifier();
            Token tkOut = credentialsOut.getToken(new Text(ti.getRegistryUrl() + "-" + ti.getApplicationId()));
            Assert.assertEquals((Object)tkIn.getKind(), (Object)tkOut.getKind());
            Assert.assertEquals((Object)new String(tkIn.getIdentifier()), (Object)new String(tkOut.getIdentifier()));
            Assert.assertEquals((Object)new String(tkIn.getPassword()), (Object)new String(tkOut.getPassword()));
            Assert.assertEquals((Object)tkIn.getService(), (Object)tkOut.getService());
        }
    }

    @Test
    public void testWriteDockerCredentialsToPath() throws Exception {
        File outFile = File.createTempFile("docker-client-config", "out");
        outFile.deleteOnExit();
        Credentials credentials = DockerClientConfigHandler.readCredentialsFromConfigFile((Path)new Path(this.file.toURI()), (Configuration)this.conf, (String)APPLICATION_ID);
        Assert.assertTrue((boolean)DockerClientConfigHandler.writeDockerCredentialsToPath((File)outFile, (Credentials)credentials));
        Assert.assertTrue((boolean)outFile.exists());
        String fileContents = FileUtils.readFileToString((File)outFile);
        Assert.assertTrue((boolean)fileContents.contains("auths"));
        Assert.assertTrue((boolean)fileContents.contains("registry.example.com"));
        Assert.assertTrue((boolean)fileContents.contains("https://index.docker.io/v1/"));
        Assert.assertTrue((boolean)fileContents.contains("foobarbaz"));
        Assert.assertTrue((boolean)fileContents.contains("bazbarfoo"));
    }
}

