/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.timeline;

import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestShortenedFlowName {
    private static final String TEST_FLOW_NAME = "TestFlowName";

    @Test
    public void testRemovingUUID() {
        String flowName = "TestFlowName-" + UUID.randomUUID();
        flowName = TimelineUtils.removeUUID((String)flowName);
        Assert.assertEquals((Object)TEST_FLOW_NAME, (Object)flowName);
    }

    @Test
    public void testShortenedFlowName() {
        YarnConfiguration conf = new YarnConfiguration();
        String flowName = TEST_FLOW_NAME + UUID.randomUUID();
        conf.setInt("yarn.timeline-service.flowname.max-size", 8);
        String shortenedFlowName = TimelineUtils.shortenFlowName((String)flowName, (Configuration)conf);
        Assert.assertEquals((Object)"TestFlow", (Object)shortenedFlowName);
        conf.setInt("yarn.timeline-service.flowname.max-size", 0);
        shortenedFlowName = TimelineUtils.shortenFlowName((String)flowName, (Configuration)conf);
        Assert.assertEquals((Object)TEST_FLOW_NAME, (Object)shortenedFlowName);
    }
}

