/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.CustomRMAddressFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMAddressFinderLoader {
    private static RMAddressFinderLoader s_instance = new RMAddressFinderLoader();
    private static Logger LOG = LoggerFactory.getLogger(RMAddressFinderLoader.class);
    private CustomRMAddressFinder rmAddressFinder;
    private volatile boolean isLoaded;

    private RMAddressFinderLoader() {
    }

    public static RMAddressFinderLoader getInstance() {
        return s_instance;
    }

    public synchronized CustomRMAddressFinder getCustomRMAddressFinder(Configuration conf) {
        if (this.isLoaded) {
            return this.rmAddressFinder;
        }
        String className = "yarn.resourcemanager.ha.custom-ha-rmaddressfinder";
        try {
            Class claz = conf.getClass(className, null, CustomRMAddressFinder.class);
            if (claz != null) {
                this.rmAddressFinder = (CustomRMAddressFinder)claz.newInstance();
            } else {
                LOG.warn("Did not find configuration for: " + className);
            }
        }
        catch (InstantiationException e) {
            LOG.error("Class InstantiationException", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("IllegalAccessException", (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error("Exception while trying to instantiate class with name under property: " + className, t);
        }
        this.isLoaded = true;
        return this.rmAddressFinder;
    }
}

