/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.resource;

import org.apache.hadoop.yarn.api.records.AllocationTagNamespaceType;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestPlacementConstraints {
    TestPlacementConstraints() {
    }

    @Test
    void testNodeAffinityToTag() {
        PlacementConstraint.AbstractConstraint constraintExpr = PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"hbase-m"})});
        PlacementConstraint.SingleConstraint sConstraint = (PlacementConstraint.SingleConstraint)constraintExpr;
        Assertions.assertEquals((Object)"node", (Object)sConstraint.getScope());
        Assertions.assertEquals((int)1, (int)sConstraint.getMinCardinality());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)sConstraint.getMaxCardinality());
        Assertions.assertEquals((int)1, (int)sConstraint.getTargetExpressions().size());
        PlacementConstraint.TargetExpression tExpr = (PlacementConstraint.TargetExpression)sConstraint.getTargetExpressions().iterator().next();
        Assertions.assertEquals((Object)AllocationTagNamespaceType.SELF.toString(), (Object)tExpr.getTargetKey());
        Assertions.assertEquals((Object)PlacementConstraint.TargetExpression.TargetType.ALLOCATION_TAG, (Object)tExpr.getTargetType());
        Assertions.assertEquals((int)1, (int)tExpr.getTargetValues().size());
        Assertions.assertEquals((Object)"hbase-m", tExpr.getTargetValues().iterator().next());
        PlacementConstraint constraint = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)constraintExpr);
        Assertions.assertNotNull((Object)constraint.getConstraintExpr());
    }

    @Test
    public void testNodeAntiAffinityToAttribute() {
        PlacementConstraint.AbstractConstraint constraintExpr = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.nodeAttribute((String)"java", (String[])new String[]{"1.8"})});
        PlacementConstraint.SingleConstraint sConstraint = (PlacementConstraint.SingleConstraint)constraintExpr;
        Assertions.assertEquals((Object)"node", (Object)sConstraint.getScope());
        Assertions.assertEquals((int)0, (int)sConstraint.getMinCardinality());
        Assertions.assertEquals((int)0, (int)sConstraint.getMaxCardinality());
        Assertions.assertEquals((int)1, (int)sConstraint.getTargetExpressions().size());
        PlacementConstraint.TargetExpression tExpr = (PlacementConstraint.TargetExpression)sConstraint.getTargetExpressions().iterator().next();
        Assertions.assertEquals((Object)"java", (Object)tExpr.getTargetKey());
        Assertions.assertEquals((Object)PlacementConstraint.TargetExpression.TargetType.NODE_ATTRIBUTE, (Object)tExpr.getTargetType());
        Assertions.assertEquals((int)1, (int)tExpr.getTargetValues().size());
        Assertions.assertEquals((Object)"1.8", tExpr.getTargetValues().iterator().next());
    }

    @Test
    public void testAndConstraint() {
        PlacementConstraint.And constraintExpr;
        PlacementConstraint.And andExpr = constraintExpr = PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"rack", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"spark"})}), PlacementConstraints.maxCardinality((String)"node", (int)3, (String[])new String[]{"spark"}), PlacementConstraints.targetCardinality((String)"rack", (int)2, (int)10, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"zk"})})});
        Assertions.assertEquals((int)3, (int)andExpr.getChildren().size());
        PlacementConstraint.SingleConstraint sConstr = (PlacementConstraint.SingleConstraint)andExpr.getChildren().get(0);
        PlacementConstraint.TargetExpression tExpr = (PlacementConstraint.TargetExpression)sConstr.getTargetExpressions().iterator().next();
        Assertions.assertEquals((Object)"spark", tExpr.getTargetValues().iterator().next());
        sConstr = (PlacementConstraint.SingleConstraint)andExpr.getChildren().get(1);
        Assertions.assertEquals((int)0, (int)sConstr.getMinCardinality());
        Assertions.assertEquals((int)3, (int)sConstr.getMaxCardinality());
        sConstr = (PlacementConstraint.SingleConstraint)andExpr.getChildren().get(2);
        Assertions.assertEquals((int)2, (int)sConstr.getMinCardinality());
        Assertions.assertEquals((int)10, (int)sConstr.getMaxCardinality());
    }
}

