/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestUnitsConversionUtil {
    TestUnitsConversionUtil() {
    }

    @Test
    void testUnitsConversion() {
        int value = 5;
        String fromUnit = "";
        long test = value;
        Assertions.assertEquals((long)((long)value * 1000L * 1000L * 1000L * 1000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"p", (long)test), (String)"pico test failed");
        Assertions.assertEquals((long)((long)value * 1000L * 1000L * 1000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"n", (long)test), (String)"nano test failed");
        Assertions.assertEquals((long)((long)value * 1000L * 1000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"u", (long)test), (String)"micro test failed");
        Assertions.assertEquals((long)((long)value * 1000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"m", (long)test), (String)"milli test failed");
        test = (long)value * 1000L * 1000L * 1000L * 1000L * 1000L;
        fromUnit = "";
        Assertions.assertEquals((long)(test / 1000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"k", (long)test), (String)"kilo test failed");
        Assertions.assertEquals((long)(test / 1000000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"M", (long)test), (String)"mega test failed");
        Assertions.assertEquals((long)(test / 1000000000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"G", (long)test), (String)"giga test failed");
        Assertions.assertEquals((long)(test / 1000000000000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"T", (long)test), (String)"tera test failed");
        Assertions.assertEquals((long)(test / 1000000000000000L), (long)UnitsConversionUtil.convert((String)fromUnit, (String)"P", (long)test), (String)"peta test failed");
        Assertions.assertEquals((long)((long)value * 1000L), (long)UnitsConversionUtil.convert((String)"n", (String)"p", (long)value), (String)"nano to pico test failed");
        Assertions.assertEquals((long)value, (long)UnitsConversionUtil.convert((String)"M", (String)"G", (long)((long)value * 1000L)), (String)"mega to giga test failed");
        Assertions.assertEquals((long)value, (long)UnitsConversionUtil.convert((String)"Mi", (String)"Gi", (long)((long)value * 1024L)), (String)"Mi to Gi test failed");
        Assertions.assertEquals((long)(value * 1024), (long)UnitsConversionUtil.convert((String)"Mi", (String)"Ki", (long)value), (String)"Mi to Ki test failed");
        Assertions.assertEquals((long)5120L, (long)UnitsConversionUtil.convert((String)"Ki", (String)"", (long)5L), (String)"Ki to base units test failed");
        Assertions.assertEquals((long)1073741L, (long)UnitsConversionUtil.convert((String)"Mi", (String)"k", (long)1024L), (String)"Mi to k test failed");
        Assertions.assertEquals((long)953L, (long)UnitsConversionUtil.convert((String)"M", (String)"Mi", (long)1000L), (String)"M to Mi test failed");
    }

    @Test
    void testOverflow() {
        long test = 5000000000000000L;
        try {
            UnitsConversionUtil.convert((String)"P", (String)"p", (long)test);
            Assertions.fail((String)"this operation should result in an overflow");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            UnitsConversionUtil.convert((String)"m", (String)"p", (long)0x7FFFFFFFFFFFFFFEL);
            Assertions.fail((String)"this operation should result in an overflow");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testCompare() {
        String unitA = "P";
        long valueA = 1L;
        String unitB = "p";
        long valueB = 2L;
        Assertions.assertEquals((int)1, (int)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitB, (long)valueB));
        Assertions.assertEquals((int)-1, (int)UnitsConversionUtil.compare((String)unitB, (long)valueB, (String)unitA, (long)valueA));
        Assertions.assertEquals((int)0, (int)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitA, (long)valueA));
        Assertions.assertEquals((int)-1, (int)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitA, (long)valueB));
        Assertions.assertEquals((int)1, (int)UnitsConversionUtil.compare((String)unitA, (long)valueB, (String)unitA, (long)valueA));
        unitB = "T";
        Assertions.assertEquals((int)1, (int)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitB, (long)valueB));
        Assertions.assertEquals((int)-1, (int)UnitsConversionUtil.compare((String)unitB, (long)valueB, (String)unitA, (long)valueA));
        Assertions.assertEquals((int)0, (int)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitB, (long)1000L));
        unitA = "p";
        unitB = "n";
        Assertions.assertEquals((int)-1, (int)UnitsConversionUtil.compare((String)unitA, (long)valueA, (String)unitB, (long)valueB));
        Assertions.assertEquals((int)1, (int)UnitsConversionUtil.compare((String)unitB, (long)valueB, (String)unitA, (long)valueA));
        Assertions.assertEquals((int)0, (int)UnitsConversionUtil.compare((String)unitA, (long)1000L, (String)unitB, (long)valueA));
    }
}

