/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.impl.LightWeightResource;
import org.apache.hadoop.yarn.exceptions.ResourceNotFoundException;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class Resource
implements Comparable<Resource> {
    protected ResourceInformation[] resources = null;
    @InterfaceAudience.Private
    public static final int MEMORY_INDEX = 0;
    @InterfaceAudience.Private
    public static final int VCORES_INDEX = 1;

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static Resource newInstance(int memory, int vCores) {
        return new LightWeightResource(memory, vCores);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static Resource newInstance(long memory, int vCores) {
        return new LightWeightResource(memory, vCores);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static Resource newInstance(long memory, int vCores, Map<String, Long> others) {
        if (others != null) {
            return new LightWeightResource(memory, vCores, ResourceUtils.createResourceTypesArray(others));
        }
        return Resource.newInstance(memory, vCores);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static Resource newInstance(Resource resource) {
        int numberOfKnownResourceTypes = ResourceUtils.getNumberOfKnownResourceTypes();
        LightWeightResource ret = numberOfKnownResourceTypes > 2 ? new LightWeightResource(resource.getMemorySize(), resource.getVirtualCores(), resource.getResources()) : new LightWeightResource(resource.getMemorySize(), resource.getVirtualCores());
        return ret;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static void copy(Resource source, Resource dest) {
        for (ResourceInformation entry : source.getResources()) {
            dest.setResourceInformation(entry.getName(), entry);
        }
    }

    @InterfaceAudience.Public
    @Deprecated
    public abstract int getMemory();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public long getMemorySize() {
        throw new NotImplementedException("This method is implemented by ResourcePBImpl");
    }

    @InterfaceAudience.Public
    @Deprecated
    public abstract void setMemory(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public void setMemorySize(long memory) {
        throw new NotImplementedException("This method is implemented by ResourcePBImpl");
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract int getVirtualCores();

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract void setVirtualCores(int var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ResourceInformation[] getResources() {
        return this.resources;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public List<ResourceInformation> getAllResourcesListCopy() {
        ArrayList<ResourceInformation> list = new ArrayList<ResourceInformation>();
        for (ResourceInformation i : this.resources) {
            ResourceInformation ri = new ResourceInformation();
            ResourceInformation.copy(i, ri);
            list.add(ri);
        }
        return list;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public ResourceInformation getResourceInformation(String resource) {
        Integer index = ResourceUtils.getResourceTypeIndex().get(resource);
        if (index != null) {
            return this.resources[index];
        }
        throw new ResourceNotFoundException(this, resource);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ResourceInformation getResourceInformation(int index) throws ResourceNotFoundException {
        ResourceInformation ri = null;
        try {
            ri = this.resources[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.throwExceptionWhenArrayOutOfBound(index);
        }
        return ri;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public long getResourceValue(String resource) {
        return this.getResourceInformation(resource).getValue();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void setResourceInformation(String resource, ResourceInformation resourceInformation) {
        if (resource.equals("memory-mb")) {
            this.setMemorySize(resourceInformation.getValue());
            return;
        }
        if (resource.equals("vcores")) {
            this.setVirtualCores((int)resourceInformation.getValue());
            return;
        }
        ResourceInformation storedResourceInfo = this.getResourceInformation(resource);
        ResourceInformation.copy(resourceInformation, storedResourceInfo);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setResourceInformation(int index, ResourceInformation resourceInformation) throws ResourceNotFoundException {
        if (index < 0 || index >= this.resources.length) {
            this.throwExceptionWhenArrayOutOfBound(index);
        }
        ResourceInformation.copy(resourceInformation, this.resources[index]);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void setResourceValue(String resource, long value) {
        if (resource.equals("memory-mb")) {
            this.setMemorySize(value);
            return;
        }
        if (resource.equals("vcores")) {
            if (value > Integer.MAX_VALUE) {
                value = Integer.MAX_VALUE;
            }
            this.setVirtualCores((int)value);
            return;
        }
        ResourceInformation storedResourceInfo = this.getResourceInformation(resource);
        storedResourceInfo.setValue(value);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setResourceValue(int index, long value) throws ResourceNotFoundException {
        try {
            this.resources[index].setValue(value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.throwExceptionWhenArrayOutOfBound(index);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public double getDisks() {
        double disks;
        try {
            disks = this.getResourceInformation("disks").getValue();
        }
        catch (ResourceNotFoundException ex) {
            disks = 0.0;
        }
        return disks;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public void setDisks(double disks) {
        this.setResourceValue("disks", (long)disks * 1000L);
    }

    protected void throwExceptionWhenArrayOutOfBound(int index) {
        String exceptionMsg = String.format("Trying to access ResourceInformation for given index=%d. Acceptable index range is [0,%d), please double check configured resources in resource-types.xml", index, ResourceUtils.getNumberOfKnownResourceTypes());
        throw new ResourceNotFoundException(exceptionMsg);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        ResourceInformation[] otherVectors = other.getResources();
        if (this.resources.length != otherVectors.length) {
            return false;
        }
        for (int i = 0; i < this.resources.length; ++i) {
            ResourceInformation a = this.resources[i];
            ResourceInformation b = otherVectors[i];
            if (a == b || a != null && a.equals(b)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Resource other) {
        ResourceInformation[] otherResources = other.getResources();
        int arrLenThis = this.resources.length;
        int arrLenOther = otherResources.length;
        for (int i = 0; i < arrLenThis; ++i) {
            ResourceInformation otherEntry;
            try {
                otherEntry = otherResources[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return 1;
            }
            ResourceInformation entry = this.resources[i];
            long diff = entry.compareTo(otherEntry);
            if (diff > 0L) {
                return 1;
            }
            if (diff >= 0L) continue;
            return -1;
        }
        if (arrLenThis < arrLenOther) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.getFormattedString(String.valueOf(this.getMemorySize()));
    }

    private String getFormattedString(String memory) {
        StringBuilder sb = new StringBuilder();
        sb.append("<memory:").append(memory).append(", vCores:").append(this.getVirtualCores());
        for (int i = 2; i < this.resources.length; ++i) {
            ResourceInformation ri = this.resources[i];
            if (ri.getValue() == 0L) continue;
            sb.append(", ").append(ri.getName()).append(": ").append(ri.getValue()).append(ri.getUnits());
        }
        sb.append(">");
        return sb.toString();
    }

    public String getFormattedString() {
        return this.getFormattedString(StringUtils.byteDesc((long)(this.getMemorySize() * 1024L * 1024L)));
    }

    public int hashCode() {
        int prime = 47;
        int result = 0;
        for (ResourceInformation entry : this.resources) {
            result = 47 * result + entry.hashCode();
        }
        return result;
    }

    protected static int castToIntSafely(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return Long.valueOf(value).intValue();
    }

    protected static ResourceInformation newDefaultInformation(String name, String unit, long value) {
        ResourceInformation ri = new ResourceInformation();
        ri.setName(name);
        ri.setValue(value);
        ri.setResourceType(ResourceTypes.COUNTABLE);
        ri.setUnitsWithoutValidation(unit);
        ri.setMinimumAllocation(0L);
        ri.setMaximumAllocation(Long.MAX_VALUE);
        return ri;
    }
}

