/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming.mapreduce;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.mapreduce.StreamBaseRecordReader;

public class StreamXmlRecordReader
extends StreamBaseRecordReader {
    private Text key;
    private Text value;
    int numNext = 0;
    private static final int CDATA_IN = 10;
    private static final int CDATA_OUT = 11;
    private static final int CDATA_UNK = 12;
    private static final int RECORD_ACCEPT = 13;
    private static final int CDATA_BEGIN = 20;
    private static final int CDATA_END = 21;
    private static final int RECORD_MAYBE = 22;
    String beginMark_ = this.checkJobGet("stream.recordreader.begin");
    String endMark_ = this.checkJobGet("stream.recordreader.end");
    Pattern beginPat_;
    Pattern endPat_;
    boolean slowMatch_;
    int lookAhead_;
    int maxRecSize_ = this.conf_.getInt("stream.recordreader.maxrec", 50000);
    BufferedInputStream bin_;
    long pos_;
    private static final int NA = -1;
    int firstMatchStart_ = 0;
    int firstMatchEnd_ = 0;
    boolean synched_ = false;

    public StreamXmlRecordReader(FSDataInputStream in, FileSplit split, TaskAttemptContext context, Configuration conf, FileSystem fs) throws IOException {
        super(in, split, context, conf, fs);
        this.lookAhead_ = this.conf_.getInt("stream.recordreader.lookahead", 2 * this.maxRecSize_);
        this.slowMatch_ = this.conf_.getBoolean("stream.recordreader.slowmatch", false);
        if (this.slowMatch_) {
            this.beginPat_ = this.makePatternCDataOrMark(this.beginMark_);
            this.endPat_ = this.makePatternCDataOrMark(this.endMark_);
        }
        this.init();
    }

    public final void init() throws IOException {
        LOG.info("StreamBaseRecordReader.init:  start_=" + this.start_ + " end_=" + this.end_ + " length_=" + this.length_ + " start_ > in_.getPos() =" + (this.start_ > this.in_.getPos()) + " " + this.start_ + " > " + this.in_.getPos());
        if (this.start_ > this.in_.getPos()) {
            this.in_.seek(this.start_);
        }
        this.pos_ = this.start_;
        this.bin_ = new BufferedInputStream((InputStream)this.in_);
        this.seekNextRecordBoundary();
    }

    @Override
    public synchronized boolean next(Text key, Text value) throws IOException {
        ++this.numNext;
        if (this.pos_ >= this.end_) {
            return false;
        }
        DataOutputBuffer buf = new DataOutputBuffer();
        if (!this.readUntilMatchBegin()) {
            return false;
        }
        if (this.pos_ >= this.end_ || !this.readUntilMatchEnd(buf)) {
            return false;
        }
        byte[] record = new byte[buf.getLength()];
        System.arraycopy(buf.getData(), 0, record, 0, record.length);
        this.numRecStats(record, 0, record.length);
        key.set(record);
        value.set("");
        return true;
    }

    @Override
    public void seekNextRecordBoundary() throws IOException {
        this.readUntilMatchBegin();
    }

    boolean readUntilMatchBegin() throws IOException {
        if (this.slowMatch_) {
            return this.slowReadUntilMatch(this.beginPat_, false, null);
        }
        return this.fastReadUntilMatch(this.beginMark_, false, null);
    }

    private boolean readUntilMatchEnd(DataOutputBuffer buf) throws IOException {
        if (this.slowMatch_) {
            return this.slowReadUntilMatch(this.endPat_, true, buf);
        }
        return this.fastReadUntilMatch(this.endMark_, true, buf);
    }

    private boolean slowReadUntilMatch(Pattern markPattern, boolean includePat, DataOutputBuffer outBufOrNull) throws IOException {
        boolean matched;
        byte[] buf = new byte[Math.max(this.lookAhead_, this.maxRecSize_)];
        int read = 0;
        this.bin_.mark(Math.max(this.lookAhead_, this.maxRecSize_) + 2);
        read = this.bin_.read(buf);
        if (read == -1) {
            return false;
        }
        String sbuf = new String(buf, 0, read, "UTF-8");
        Matcher match = markPattern.matcher(sbuf);
        this.firstMatchStart_ = -1;
        this.firstMatchEnd_ = -1;
        int bufPos = 0;
        int state = this.synched_ ? 11 : 12;
        int s = 0;
        while (match.find(bufPos)) {
            int input;
            if (match.group(1) != null) {
                input = 20;
            } else if (match.group(2) != null) {
                input = 21;
                this.firstMatchStart_ = -1;
            } else {
                input = 22;
            }
            if (input == 22 && this.firstMatchStart_ == -1) {
                this.firstMatchStart_ = match.start();
                this.firstMatchEnd_ = match.end();
            }
            if ((state = this.nextState(state, input, match.start())) == 13) break;
            bufPos = match.end();
            ++s;
        }
        if (state != 12) {
            this.synched_ = true;
        }
        boolean bl = matched = this.firstMatchStart_ != -1 && (state == 13 || state == 12);
        if (matched) {
            int endPos = includePat ? this.firstMatchEnd_ : this.firstMatchStart_;
            this.bin_.reset();
            for (long skiplen = (long)endPos; skiplen > 0L; skiplen -= this.bin_.skip(skiplen)) {
            }
            this.pos_ += (long)endPos;
            if (outBufOrNull != null) {
                outBufOrNull.writeBytes(sbuf.substring(0, endPos));
            }
        }
        return matched;
    }

    int nextState(int state, int input, int bufPos) {
        switch (state) {
            case 11: 
            case 12: {
                switch (input) {
                    case 20: {
                        return 10;
                    }
                    case 21: {
                        if (state == 11) {
                            // empty if block
                        }
                        return 11;
                    }
                    case 22: {
                        return state == 12 ? 12 : 13;
                    }
                }
                break;
            }
            case 10: {
                return input == 21 ? 11 : 10;
            }
        }
        throw new IllegalStateException(state + " " + input + " " + bufPos + " " + this.splitName_);
    }

    Pattern makePatternCDataOrMark(String escapedMark) {
        StringBuffer pat = new StringBuffer();
        this.addGroup(pat, StreamUtil.regexpEscape("CDATA["));
        this.addGroup(pat, StreamUtil.regexpEscape("]]>"));
        this.addGroup(pat, escapedMark);
        return Pattern.compile(pat.toString());
    }

    void addGroup(StringBuffer pat, String escapedGroup) {
        if (pat.length() > 0) {
            pat.append("|");
        }
        pat.append("(");
        pat.append(escapedGroup);
        pat.append(")");
    }

    boolean fastReadUntilMatch(String textPat, boolean includePat, DataOutputBuffer outBufOrNull) throws IOException {
        int b;
        byte[] cpat = textPat.getBytes("UTF-8");
        int m = 0;
        boolean match = false;
        int msup = cpat.length;
        int LL = 1200000;
        this.bin_.mark(LL);
        while ((b = this.bin_.read()) != -1) {
            byte c = (byte)b;
            if (c == cpat[m]) {
                if (++m != msup) continue;
                match = true;
                break;
            }
            this.bin_.mark(LL);
            if (outBufOrNull != null) {
                outBufOrNull.write(cpat, 0, m);
                outBufOrNull.write((int)c);
            }
            this.pos_ += (long)(m + 1);
            m = 0;
        }
        if (!includePat && match) {
            this.bin_.reset();
        } else if (outBufOrNull != null) {
            outBufOrNull.write(cpat);
            this.pos_ += (long)msup;
        }
        return match;
    }

    String checkJobGet(String prop) throws IOException {
        String val = this.conf_.get(prop);
        if (val == null) {
            throw new IOException("JobConf: missing required property: " + prop);
        }
        return val;
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public void initialize(InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.key = this.createKey();
        this.value = this.createValue();
        return this.next(this.key, this.value);
    }
}

