/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.nodemanager.NMSimulator;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NMUtils {
    private static SLSRunner slsRunner;
    private static ResourceManager rm;
    private static HashMap<NodeId, NMSimulator> nmMap;
    private static Set<RMNode> restarted;

    public static void stopNodes() throws IllegalAccessException {
        NMUtils.getFields();
        for (NMSimulator nmSimulator : nmMap.values()) {
            RMNode node = nmSimulator.getNode();
            if (!(Math.random() > 0.5)) continue;
            rm.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(node.getNodeID(), RMNodeEventType.REBOOTING));
            restarted.add(node);
        }
    }

    public static void restartNodes() {
        NMUtils.getFields();
        for (RMNode node : restarted) {
            RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
            req.setNodeId(node.getNodeID());
            req.setResource(node.getTotalCapability());
            req.setHttpPort(80);
            try {
                rm.getResourceTrackerService().registerNodeManager(req);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void getFields() {
        try {
            slsRunner = (SLSRunner)FieldUtils.readStaticField(SLSRunner.class, (String)"sls", (boolean)true);
            rm = (ResourceManager)FieldUtils.readDeclaredField((Object)slsRunner, (String)"rm", (boolean)true);
            nmMap = (HashMap)FieldUtils.readField((Object)slsRunner, (String)"nmMap", (boolean)true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    static {
        restarted = new HashSet<RMNode>();
    }
}

