/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.common.PathUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryTestHelper
extends Assert {
    public static final String SC_HADOOP = "org-apache-hadoop";
    public static final String USER = "devteam/";
    public static final String NAME = "hdfs";
    public static final String API_WEBHDFS = "classpath:org.apache.hadoop.namenode.webhdfs";
    public static final String API_HDFS = "classpath:org.apache.hadoop.namenode.dfs";
    public static final String USERPATH = "/users/devteam/";
    public static final String PARENT_PATH = "/users/devteam/org-apache-hadoop/";
    public static final String ENTRY_PATH = "/users/devteam/org-apache-hadoop/hdfs";
    public static final String NNIPC = "uuid:423C2B93-C927-4050-AEC6-6540E6646437";
    public static final String IPC2 = "uuid:0663501D-5AD3-4F7E-9419-52F5D6636FCF";
    private static final Logger LOG = LoggerFactory.getLogger(RegistryTestHelper.class);
    private static final RegistryUtils.ServiceRecordMarshal recordMarshal = new RegistryUtils.ServiceRecordMarshal();
    public static final String HTTP_API = "http://";

    public static void assertValidZKPath(String path) {
        try {
            PathUtils.validatePath((String)path);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid Path " + path + ": " + e, e);
        }
    }

    public static void assertNotEmpty(String message, String check) {
        if (StringUtils.isEmpty((CharSequence)check)) {
            RegistryTestHelper.fail((String)message);
        }
    }

    public static void assertNotEmpty(String check) {
        if (StringUtils.isEmpty((CharSequence)check)) {
            RegistryTestHelper.fail((String)"Empty string");
        }
    }

    public static void logLoginDetails(String name, LoginContext loginContext) {
        RegistryTestHelper.assertNotNull((String)"Null login context", (Object)loginContext);
        Subject subject = loginContext.getSubject();
        LOG.info("Logged in as {}:\n {}", (Object)name, (Object)subject);
    }

    public static void enableKerberosDebugging() {
        System.setProperty("sun.security.krb5.debug", "true");
    }

    public static void disableKerberosDebugging() {
        System.setProperty("sun.security.krb5.debug", "false");
    }

    public static void validateEntry(ServiceRecord record) {
        RegistryTestHelper.assertNotNull((String)"null service record", (Object)record);
        List endpoints = record.external;
        RegistryTestHelper.assertEquals((long)2L, (long)endpoints.size());
        Endpoint webhdfs = RegistryTestHelper.findEndpoint(record, API_WEBHDFS, true, 1, 1);
        RegistryTestHelper.assertEquals((Object)API_WEBHDFS, (Object)webhdfs.api);
        RegistryTestHelper.assertEquals((Object)"uri", (Object)webhdfs.addressType);
        RegistryTestHelper.assertEquals((Object)"REST", (Object)webhdfs.protocolType);
        List addressList = webhdfs.addresses;
        Map url = (Map)addressList.get(0);
        String addr = (String)url.get("uri");
        RegistryTestHelper.assertTrue((boolean)addr.contains("http"));
        RegistryTestHelper.assertTrue((boolean)addr.contains(":8020"));
        Endpoint nnipc = RegistryTestHelper.findEndpoint(record, NNIPC, false, 1, 2);
        RegistryTestHelper.assertEquals((String)("wrong protocol in " + nnipc), (Object)"thrift", (Object)nnipc.protocolType);
        Endpoint ipc2 = RegistryTestHelper.findEndpoint(record, IPC2, false, 1, 2);
        RegistryTestHelper.assertNotNull((Object)ipc2);
        Endpoint web = RegistryTestHelper.findEndpoint(record, HTTP_API, true, 1, 1);
        RegistryTestHelper.assertEquals((long)1L, (long)web.addresses.size());
        RegistryTestHelper.assertEquals((long)1L, (long)((Map)web.addresses.get(0)).size());
    }

    public static void assertMatches(Endpoint endpoint, String addressType, String protocolType, String api) {
        RegistryTestHelper.assertNotNull((Object)endpoint);
        RegistryTestHelper.assertEquals((Object)addressType, (Object)endpoint.addressType);
        RegistryTestHelper.assertEquals((Object)protocolType, (Object)endpoint.protocolType);
        RegistryTestHelper.assertEquals((Object)api, (Object)endpoint.api);
    }

    public static void assertMatches(ServiceRecord source, ServiceRecord resolved) {
        RegistryTestHelper.assertNotNull((String)"Null source record ", (Object)source);
        RegistryTestHelper.assertNotNull((String)"Null resolved record ", (Object)resolved);
        RegistryTestHelper.assertEquals((Object)source.description, (Object)resolved.description);
        Map srcAttrs = source.attributes();
        Map resolvedAttrs = resolved.attributes();
        String sourceAsString = source.toString();
        String resolvedAsString = resolved.toString();
        RegistryTestHelper.assertEquals((String)("Wrong count of attrs in \n" + sourceAsString + "\nfrom\n" + resolvedAsString), (long)srcAttrs.size(), (long)resolvedAttrs.size());
        for (Map.Entry entry : srcAttrs.entrySet()) {
            String attr = (String)entry.getKey();
            RegistryTestHelper.assertEquals((String)("attribute " + attr), entry.getValue(), (Object)resolved.get(attr));
        }
        RegistryTestHelper.assertEquals((String)"wrong external endpoint count", (long)source.external.size(), (long)resolved.external.size());
        RegistryTestHelper.assertEquals((String)"wrong external endpoint count", (long)source.internal.size(), (long)resolved.internal.size());
    }

    public static Endpoint findEndpoint(ServiceRecord record, String api, boolean external, int addressElements, int addressTupleSize) {
        Endpoint epr;
        Endpoint endpoint = epr = external ? record.getExternalEndpoint(api) : record.getInternalEndpoint(api);
        if (epr != null) {
            RegistryTestHelper.assertEquals((String)"wrong # of addresses", (long)addressElements, (long)epr.addresses.size());
            RegistryTestHelper.assertEquals((String)"wrong # of elements in an address tuple", (long)addressTupleSize, (long)((Map)epr.addresses.get(0)).size());
            return epr;
        }
        List endpoints = external ? record.external : record.internal;
        StringBuilder builder = new StringBuilder();
        for (Endpoint endpoint2 : endpoints) {
            builder.append("\"").append(endpoint2).append("\" ");
        }
        RegistryTestHelper.fail((String)("Did not find " + api + " in endpoints " + builder));
        return null;
    }

    public static void logRecord(String name, ServiceRecord record) throws IOException {
        LOG.info(" {} = \n{}\n", (Object)name, (Object)recordMarshal.toJson((Object)record));
    }

    public static ServiceRecord buildExampleServiceEntry(String persistence) throws IOException, URISyntaxException {
        ServiceRecord record = new ServiceRecord();
        record.set("yarn:id", (Object)"example-0001");
        record.set("yarn:persistence", (Object)persistence);
        RegistryTestHelper.addSampleEndpoints(record, "namenode");
        return record;
    }

    public static void addSampleEndpoints(ServiceRecord entry, String hostname) throws URISyntaxException {
        RegistryTestHelper.assertNotNull((Object)hostname);
        entry.addExternalEndpoint(RegistryTypeUtils.webEndpoint((String)HTTP_API, (URI[])new URI[]{new URI("http", hostname + ":80", "/")}));
        entry.addExternalEndpoint(RegistryTypeUtils.restEndpoint((String)API_WEBHDFS, (URI[])new URI[]{new URI("http", hostname + ":8020", "/")}));
        Endpoint endpoint = RegistryTypeUtils.ipcEndpoint((String)API_HDFS, null);
        endpoint.addresses.add(RegistryTypeUtils.hostnamePortPair((String)hostname, (int)8030));
        entry.addInternalEndpoint(endpoint);
        InetSocketAddress localhost = new InetSocketAddress("localhost", 8050);
        entry.addInternalEndpoint(RegistryTypeUtils.inetAddrEndpoint((String)NNIPC, (String)"thrift", (String)"localhost", (int)8050));
        entry.addInternalEndpoint(RegistryTypeUtils.ipcEndpoint((String)IPC2, (InetSocketAddress)localhost));
    }

    public static void describe(Logger log, String text, Object ... args) {
        log.info("\n=======================================");
        log.info(text, args);
        log.info("=======================================\n");
    }

    public static LoginContext logout(LoginContext login) {
        try {
            if (login != null) {
                LOG.debug("Logging out login context {}", (Object)login.toString());
                login.logout();
            }
        }
        catch (LoginException e) {
            LOG.warn("Exception logging out: {}", (Object)e, (Object)e);
        }
        return null;
    }

    public static UserGroupInformation loginUGI(String user, File keytab) throws IOException {
        LOG.info("Logging in as {} from {}", (Object)user, (Object)keytab);
        return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)user, (String)keytab.getAbsolutePath());
    }

    public static ServiceRecord createRecord(String persistence) {
        return RegistryTestHelper.createRecord("01", persistence, "description");
    }

    public static ServiceRecord createRecord(String id, String persistence, String description) {
        ServiceRecord serviceRecord = new ServiceRecord();
        serviceRecord.set("yarn:id", (Object)id);
        serviceRecord.description = description;
        serviceRecord.set("yarn:persistence", (Object)persistence);
        return serviceRecord;
    }

    public static ServiceRecord createRecord(String id, String persistence, String description, String data) {
        return RegistryTestHelper.createRecord(id, persistence, description);
    }
}

