/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.SimpleTcpClientHandler;
import org.apache.hadoop.oncrpc.XDR;

public class SimpleTcpClient {
    protected final String host;
    protected final int port;
    protected final XDR request;
    protected final boolean oneShot;
    private NioEventLoopGroup workerGroup;
    private ChannelFuture future;

    public SimpleTcpClient(String host, int port, XDR request) {
        this(host, port, request, true);
    }

    public SimpleTcpClient(String host, int port, XDR request, Boolean oneShot) {
        this.host = host;
        this.port = port;
        this.request = request;
        this.oneShot = oneShot;
    }

    protected ChannelInitializer<SocketChannel> setChannelHandler() {
        return new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{RpcUtil.constructRpcFrameDecoder(), new SimpleTcpClientHandler(SimpleTcpClient.this.request)});
            }
        };
    }

    public void run() {
        this.workerGroup = new NioEventLoopGroup();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.workerGroup)).channel(NioSocketChannel.class);
        try {
            this.future = ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.handler(this.setChannelHandler())).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).connect((SocketAddress)new InetSocketAddress(this.host, this.port)).sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (this.oneShot) {
                this.stop();
            }
        }
    }

    public void stop() {
        try {
            if (this.future != null) {
                this.future.channel().closeFuture().sync();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.workerGroup.shutdownGracefully();
        }
    }
}

