/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.blocklocality;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.blocklocality.LocalityInputFormat;
import org.apache.hadoop.examples.blocklocality.LocalityOutputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockLocality
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(BlockLocality.class);

    public int run(String[] args) throws Exception {
        LOG.info("starting");
        JobConf job = (JobConf)this.getConf();
        Path inputDir = new Path(args[0]);
        inputDir = inputDir.makeQualified(inputDir.getFileSystem((Configuration)job));
        LocalityInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(args[0])});
        LocalityOutputFormat.setOutputPath((JobConf)job, (Path)new Path(args[1]));
        LocalityOutputFormat.setFinalSync(job, true);
        job.setJobName("BlockLocality");
        job.setJarByClass(BlockLocality.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormat(LocalityInputFormat.class);
        job.setOutputFormat(LocalityOutputFormat.class);
        job.setMapperClass(BlockLocalityMapper.class);
        job.setReducerClass(BlockLocalityReducer.class);
        job.set("mapred.reduce.tasks", "1");
        JobClient.runJob((JobConf)job);
        LOG.info("done");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new BlockLocality(), (String[])args);
        System.exit(res);
    }

    static class BlockLocalityReducer
    extends MapReduceBase
    implements Reducer<Text, IntWritable, Text, Text> {
        BlockLocalityReducer() {
        }

        public void reduce(Text key, Iterator<IntWritable> values, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            int count = 0;
            int sum = 0;
            while (values.hasNext()) {
                ++count;
                sum += values.next().get();
            }
            output.collect((Object)new Text(key.toString() + " = "), (Object)new Text(String.valueOf((float)sum / (float)count)));
        }
    }

    static class BlockLocalityMapper
    extends MapReduceBase
    implements Mapper<Text, Text, Text, IntWritable> {
        private JobConf conf;
        private static final IntWritable one = new IntWritable(1);
        private static final IntWritable zero = new IntWritable(0);

        BlockLocalityMapper() {
        }

        public void configure(JobConf conf) {
            this.conf = conf;
        }

        public void map(Text key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            String hostname = null;
            try {
                FileInputStream fstream = new FileInputStream("/opt/mapr/hostname");
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                hostname = br.readLine();
                in.close();
            }
            catch (IOException e) {
                return;
            }
            System.out.println("hostname = " + hostname);
            System.out.println(value.toString());
            String[] blockLocations = value.toString().split(";");
            for (int i = 0; i < blockLocations.length; ++i) {
                System.out.println("Block located at: " + blockLocations[i]);
                if (hostname.compareTo(blockLocations[i]) == 0) {
                    output.collect((Object)new Text(hostname), (Object)one);
                    return;
                }
                if (hostname.compareTo(blockLocations[i].split(".", 1)[0]) == 0) {
                    output.collect((Object)new Text(hostname), (Object)one);
                    return;
                }
                if (hostname.split(".", 1)[0].compareTo(blockLocations[i]) != 0) continue;
                output.collect((Object)new Text(hostname), (Object)one);
                return;
            }
            output.collect((Object)new Text(hostname), (Object)zero);
        }
    }
}

