/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptFinishingMonitor;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.speculate.DefaultSpeculator;
import org.apache.hadoop.mapreduce.v2.app.speculate.ExponentiallySmoothedTaskRuntimeEstimator;
import org.apache.hadoop.mapreduce.v2.app.speculate.LegacyTaskRuntimeEstimator;
import org.apache.hadoop.mapreduce.v2.app.speculate.SimpleExponentialTaskRuntimeEstimator;
import org.apache.hadoop.mapreduce.v2.app.speculate.Speculator;
import org.apache.hadoop.mapreduce.v2.app.speculate.SpeculatorEvent;
import org.apache.hadoop.mapreduce.v2.app.speculate.TaskRuntimeEstimator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenSecretManager;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRuntimeEstimators {
    private static int INITIAL_NUMBER_FREE_SLOTS = 600;
    private static int MAP_SLOT_REQUIREMENT = 3;
    private static int REDUCE_SLOT_REQUIREMENT = 4;
    private static int MAP_TASKS = 200;
    private static int REDUCE_TASKS = 150;
    ControlledClock clock;
    Job myJob;
    AppContext myAppContext;
    private static final Logger LOG = LoggerFactory.getLogger(TestRuntimeEstimators.class);
    private final AtomicInteger slotsInUse = new AtomicInteger(0);
    AsyncDispatcher dispatcher;
    DefaultSpeculator speculator;
    TaskRuntimeEstimator estimator;
    private final AtomicInteger completedMaps = new AtomicInteger(0);
    private final AtomicInteger completedReduces = new AtomicInteger(0);
    private final AtomicInteger successfulSpeculations = new AtomicInteger(0);
    private final AtomicLong taskTimeSavedBySpeculation = new AtomicLong(0L);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    private void coreTestEstimator(TaskRuntimeEstimator testedEstimator, int expectedSpeculations) {
        this.estimator = testedEstimator;
        this.clock = new ControlledClock();
        this.dispatcher = new AsyncDispatcher();
        Configuration conf = new Configuration();
        this.dispatcher.init(conf);
        this.myJob = null;
        this.slotsInUse.set(0);
        this.completedMaps.set(0);
        this.completedReduces.set(0);
        this.successfulSpeculations.set(0);
        this.taskTimeSavedBySpeculation.set(0L);
        this.clock.tickMsec(1000L);
        this.myAppContext = new MyAppContext(MAP_TASKS, REDUCE_TASKS);
        this.myJob = (Job)this.myAppContext.getAllJobs().values().iterator().next();
        this.estimator.contextualize(conf, this.myAppContext);
        conf.setLong("mapreduce.job.speculative.retry-after-no-speculate", 500L);
        conf.setLong("mapreduce.job.speculative.retry-after-speculate", 5000L);
        conf.setDouble("mapreduce.job.speculative.speculative-cap-running-tasks", 0.1);
        conf.setDouble("mapreduce.job.speculative.speculative-cap-total-tasks", 0.001);
        conf.setInt("mapreduce.job.speculative.minimum-allowed-tasks", 5);
        this.speculator = new DefaultSpeculator(conf, this.myAppContext, this.estimator, (Clock)this.clock);
        Assert.assertEquals((String)"wrong SPECULATIVE_RETRY_AFTER_NO_SPECULATE value", (long)500L, (long)this.speculator.getSoonestRetryAfterNoSpeculate());
        Assert.assertEquals((String)"wrong SPECULATIVE_RETRY_AFTER_SPECULATE value", (long)5000L, (long)this.speculator.getSoonestRetryAfterSpeculate());
        Assertions.assertThat((double)this.speculator.getProportionRunningTasksSpeculatable()).isCloseTo(0.1, Assertions.offset((Double)1.0E-5));
        Assertions.assertThat((double)this.speculator.getProportionTotalTasksSpeculatable()).isCloseTo(0.001, Assertions.offset((Double)1.0E-5));
        Assert.assertEquals((String)"wrong SPECULATIVE_MINIMUM_ALLOWED_TASKS value", (long)5L, (long)this.speculator.getMinimumAllowedSpeculativeTasks());
        this.dispatcher.register(Speculator.EventType.class, (EventHandler)this.speculator);
        this.dispatcher.register(TaskEventType.class, (EventHandler)new SpeculationRequestEventHandler());
        this.dispatcher.start();
        this.speculator.init(conf);
        this.speculator.start();
        int undoneMaps = MAP_TASKS;
        int undoneReduces = REDUCE_TASKS;
        LinkedList allTasksSequence = new LinkedList();
        allTasksSequence.addAll(this.myJob.getTasks(TaskType.MAP).values());
        allTasksSequence.addAll(this.myJob.getTasks(TaskType.REDUCE).values());
        while (undoneMaps + undoneReduces > 0) {
            undoneMaps = 0;
            undoneReduces = 0;
            for (Task task : allTasksSequence) {
                if (!task.isFinished()) {
                    if (task.getType() == TaskType.MAP) {
                        ++undoneMaps;
                    } else {
                        ++undoneReduces;
                    }
                }
                for (TaskAttempt attempt : task.getAttempts().values()) {
                    SpeculatorEvent event;
                    if (attempt.getState() == TaskAttemptState.NEW && INITIAL_NUMBER_FREE_SLOTS - this.slotsInUse.get() >= this.taskTypeSlots(task.getType())) {
                        MyTaskAttemptImpl attemptImpl = (MyTaskAttemptImpl)attempt;
                        event = new SpeculatorEvent(attempt.getID(), false, this.clock.getTime());
                        this.speculator.handle(event);
                        attemptImpl.startUp();
                        continue;
                    }
                    TaskAttemptStatusUpdateEvent.TaskAttemptStatus status = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
                    status.id = attempt.getID();
                    status.progress = attempt.getProgress();
                    status.stateString = attempt.getState().name();
                    status.taskState = attempt.getState();
                    event = new SpeculatorEvent(status, this.clock.getTime());
                    this.speculator.handle(event);
                }
            }
            long startTime = System.currentTimeMillis();
            while (!this.speculator.eventQueueEmpty()) {
                Thread.yield();
                if (System.currentTimeMillis() <= startTime + 130000L) continue;
                return;
            }
            this.clock.tickMsec(1000L);
            if (this.clock.getTime() % 10000L != 0L) continue;
            this.speculator.scanForSpeculations();
        }
        Assert.assertEquals((String)"We got the wrong number of successful speculations.", (long)expectedSpeculations, (long)this.successfulSpeculations.get());
    }

    @Test
    public void testLegacyEstimator() throws Exception {
        LegacyTaskRuntimeEstimator specificEstimator = new LegacyTaskRuntimeEstimator();
        this.coreTestEstimator((TaskRuntimeEstimator)specificEstimator, 3);
    }

    @Test
    public void testExponentialEstimator() throws Exception {
        ExponentiallySmoothedTaskRuntimeEstimator specificEstimator = new ExponentiallySmoothedTaskRuntimeEstimator();
        this.coreTestEstimator((TaskRuntimeEstimator)specificEstimator, 3);
    }

    @Test
    public void testSimpleExponentialEstimator() throws Exception {
        SimpleExponentialTaskRuntimeEstimator specificEstimator = new SimpleExponentialTaskRuntimeEstimator();
        this.coreTestEstimator((TaskRuntimeEstimator)specificEstimator, 3);
    }

    int taskTypeSlots(TaskType type) {
        return type == TaskType.MAP ? MAP_SLOT_REQUIREMENT : REDUCE_SLOT_REQUIREMENT;
    }

    void addAttempt(Task task) {
        MyTaskImpl myTask = (MyTaskImpl)task;
        myTask.addAttempt();
    }

    class MyAppContext
    implements AppContext {
        private final ApplicationAttemptId myAppAttemptID;
        private final ApplicationId myApplicationID;
        private final JobId myJobID;
        private final Map<JobId, Job> allJobs;

        MyAppContext(int numberMaps, int numberReduces) {
            this.myApplicationID = ApplicationId.newInstance((long)TestRuntimeEstimators.this.clock.getTime(), (int)1);
            this.myAppAttemptID = ApplicationAttemptId.newInstance((ApplicationId)this.myApplicationID, (int)0);
            this.myJobID = (JobId)TestRuntimeEstimators.this.recordFactory.newRecordInstance(JobId.class);
            this.myJobID.setAppId(this.myApplicationID);
            MyJobImpl myJob = new MyJobImpl(this.myJobID, numberMaps, numberReduces);
            this.allJobs = Collections.singletonMap(this.myJobID, myJob);
        }

        public ApplicationAttemptId getApplicationAttemptId() {
            return this.myAppAttemptID;
        }

        public ApplicationId getApplicationID() {
            return this.myApplicationID;
        }

        public Job getJob(JobId jobID) {
            return this.allJobs.get(jobID);
        }

        public Map<JobId, Job> getAllJobs() {
            return this.allJobs;
        }

        public EventHandler<Event> getEventHandler() {
            return TestRuntimeEstimators.this.dispatcher.getEventHandler();
        }

        public CharSequence getUser() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Clock getClock() {
            return TestRuntimeEstimators.this.clock;
        }

        public String getApplicationName() {
            return null;
        }

        public long getStartTime() {
            return 0L;
        }

        public ClusterInfo getClusterInfo() {
            return new ClusterInfo();
        }

        public Set<String> getBlacklistedNodes() {
            return null;
        }

        public ClientToAMTokenSecretManager getClientToAMTokenSecretManager() {
            return null;
        }

        public boolean isLastAMRetry() {
            return false;
        }

        public boolean hasSuccessfullyUnregistered() {
            return true;
        }

        public String getNMHostname() {
            return null;
        }

        public TaskAttemptFinishingMonitor getTaskAttemptFinishingMonitor() {
            return null;
        }

        public String getHistoryUrl() {
            return null;
        }

        public void setHistoryUrl(String historyUrl) {
        }
    }

    class MyAppMaster
    extends CompositeService {
        final Clock clock;

        public MyAppMaster(Clock clock) {
            super(MyAppMaster.class.getName());
            if (clock == null) {
                clock = SystemClock.getInstance();
            }
            this.clock = clock;
            LOG.info("Created MyAppMaster");
        }
    }

    class MyTaskAttemptImpl
    implements TaskAttempt {
        private final TaskAttemptId myAttemptID;
        long startMockTime = Long.MIN_VALUE;
        long shuffleCompletedTime = Long.MAX_VALUE;
        TaskAttemptState overridingState = TaskAttemptState.NEW;

        MyTaskAttemptImpl(TaskId taskID, int index, Clock clock) {
            this.myAttemptID = (TaskAttemptId)TestRuntimeEstimators.this.recordFactory.newRecordInstance(TaskAttemptId.class);
            this.myAttemptID.setId(index);
            this.myAttemptID.setTaskId(taskID);
        }

        void startUp() {
            this.startMockTime = TestRuntimeEstimators.this.clock.getTime();
            this.overridingState = null;
            TestRuntimeEstimators.this.slotsInUse.addAndGet(TestRuntimeEstimators.this.taskTypeSlots(this.myAttemptID.getTaskId().getTaskType()));
            System.out.println("TLTRE.MyTaskAttemptImpl.startUp starting " + this.getID());
            SpeculatorEvent event = new SpeculatorEvent(this.getID().getTaskId(), -1);
            TestRuntimeEstimators.this.dispatcher.getEventHandler().handle((Event)event);
        }

        public NodeId getNodeId() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public TaskAttemptId getID() {
            return this.myAttemptID;
        }

        public TaskAttemptReport getReport() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List<String> getDiagnostics() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Counters getCounters() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getShufflePort() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private float getCodeRuntime() {
            int taskIndex = this.myAttemptID.getTaskId().getId();
            int attemptIndex = this.myAttemptID.getId();
            float result = 200.0f;
            switch (taskIndex % 4) {
                case 0: {
                    if (taskIndex % 40 != 0 || attemptIndex != 0) break;
                    result = 600.0f;
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    result = 150.0f;
                    break;
                }
                case 3: {
                    result = 250.0f;
                }
            }
            return result;
        }

        private float getMapProgress() {
            float runtime = this.getCodeRuntime();
            return Math.min((float)(TestRuntimeEstimators.this.clock.getTime() - this.startMockTime) / (runtime * 1000.0f), 1.0f);
        }

        private float getReduceProgress() {
            Job job = TestRuntimeEstimators.this.myAppContext.getJob(this.myAttemptID.getTaskId().getJobId());
            float runtime = this.getCodeRuntime();
            Collection allMapTasks = job.getTasks(TaskType.MAP).values();
            int numberMaps = allMapTasks.size();
            int numberDoneMaps = 0;
            for (Task mapTask : allMapTasks) {
                if (!mapTask.isFinished()) continue;
                ++numberDoneMaps;
            }
            if (numberMaps == numberDoneMaps) {
                this.shuffleCompletedTime = Math.min(this.shuffleCompletedTime, TestRuntimeEstimators.this.clock.getTime());
                return Math.min((float)(TestRuntimeEstimators.this.clock.getTime() - this.shuffleCompletedTime) / (runtime * 2000.0f) + 0.5f, 1.0f);
            }
            return (float)numberDoneMaps / (float)numberMaps * 0.5f;
        }

        public float getProgress() {
            if (this.overridingState == TaskAttemptState.NEW) {
                return 0.0f;
            }
            return this.myAttemptID.getTaskId().getTaskType() == TaskType.MAP ? this.getMapProgress() : this.getReduceProgress();
        }

        public Phase getPhase() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public TaskAttemptState getState() {
            TaskAttemptState result;
            if (this.overridingState != null) {
                return this.overridingState;
            }
            TaskAttemptState taskAttemptState = result = this.getProgress() < 1.0f ? TaskAttemptState.RUNNING : TaskAttemptState.SUCCEEDED;
            if (result == TaskAttemptState.SUCCEEDED) {
                this.overridingState = TaskAttemptState.SUCCEEDED;
                System.out.println("MyTaskAttemptImpl.getState() -- attempt " + this.myAttemptID + " finished.");
                TestRuntimeEstimators.this.slotsInUse.addAndGet(-TestRuntimeEstimators.this.taskTypeSlots(this.myAttemptID.getTaskId().getTaskType()));
                (this.myAttemptID.getTaskId().getTaskType() == TaskType.MAP ? TestRuntimeEstimators.this.completedMaps : TestRuntimeEstimators.this.completedReduces).getAndIncrement();
                TaskId taskID = this.myAttemptID.getTaskId();
                Task task = TestRuntimeEstimators.this.myJob.getTask(taskID);
                for (TaskAttempt otherAttempt : task.getAttempts().values()) {
                    if (otherAttempt == this || otherAttempt.getState() != TaskAttemptState.RUNNING) continue;
                    if (this.getID().getId() > otherAttempt.getID().getId()) {
                        TestRuntimeEstimators.this.successfulSpeculations.getAndIncrement();
                        float hisProgress = otherAttempt.getProgress();
                        long hisStartTime = ((MyTaskAttemptImpl)otherAttempt).startMockTime;
                        System.out.println("TLTRE:A speculation finished at time " + TestRuntimeEstimators.this.clock.getTime() + ".  The stalled attempt is at " + (double)hisProgress * 100.0 + "% progress, and it started at " + hisStartTime + ", which is " + (TestRuntimeEstimators.this.clock.getTime() - hisStartTime) + " ago.");
                        long originalTaskEndEstimate = hisStartTime + TestRuntimeEstimators.this.estimator.estimatedRuntime(otherAttempt.getID());
                        System.out.println("TLTRE: We would have expected the original attempt to take " + TestRuntimeEstimators.this.estimator.estimatedRuntime(otherAttempt.getID()) + ", finishing at " + originalTaskEndEstimate);
                        long estimatedSavings = originalTaskEndEstimate - TestRuntimeEstimators.this.clock.getTime();
                        TestRuntimeEstimators.this.taskTimeSavedBySpeculation.addAndGet(estimatedSavings);
                        System.out.println("TLTRE: The task is " + task.getID());
                        TestRuntimeEstimators.this.slotsInUse.addAndGet(-TestRuntimeEstimators.this.taskTypeSlots(this.myAttemptID.getTaskId().getTaskType()));
                        ((MyTaskAttemptImpl)otherAttempt).overridingState = TaskAttemptState.KILLED;
                        continue;
                    }
                    System.out.println("TLTRE: The normal attempt beat the speculation in " + task.getID());
                }
            }
            return result;
        }

        public boolean isFinished() {
            return this.getProgress() == 1.0f;
        }

        public ContainerId getAssignedContainerID() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getNodeHttpAddress() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getNodeRackName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getLaunchTime() {
            return this.startMockTime;
        }

        public long getFinishTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getShuffleFinishTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getSortFinishTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getAssignedContainerMgrAddress() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class MyJobImpl
    implements Job {
        private final JobId jobID;
        private final Map<TaskId, Task> allTasks = new HashMap<TaskId, Task>();
        private final Map<TaskId, Task> mapTasks = new HashMap<TaskId, Task>();
        private final Map<TaskId, Task> reduceTasks = new HashMap<TaskId, Task>();

        MyJobImpl(JobId jobID, int numMaps, int numReduces) {
            MyTaskImpl newTask;
            int i;
            this.jobID = jobID;
            for (i = 0; i < numMaps; ++i) {
                newTask = new MyTaskImpl(jobID, i, TaskType.MAP);
                this.mapTasks.put(newTask.getID(), newTask);
                this.allTasks.put(newTask.getID(), newTask);
            }
            for (i = 0; i < numReduces; ++i) {
                newTask = new MyTaskImpl(jobID, i, TaskType.REDUCE);
                this.reduceTasks.put(newTask.getID(), newTask);
                this.allTasks.put(newTask.getID(), newTask);
            }
            for (Task task : this.allTasks.values()) {
                MyTaskImpl myTaskImpl = (MyTaskImpl)task;
                myTaskImpl.addAttempt();
            }
        }

        public JobId getID() {
            return this.jobID;
        }

        public JobState getState() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JobReport getReport() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public float getProgress() {
            return 0.0f;
        }

        public Counters getAllCounters() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<TaskId, Task> getTasks() {
            return this.allTasks;
        }

        public Map<TaskId, Task> getTasks(TaskType taskType) {
            return taskType == TaskType.MAP ? this.mapTasks : this.reduceTasks;
        }

        public Task getTask(TaskId taskID) {
            return this.allTasks.get(taskID);
        }

        public List<String> getDiagnostics() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getCompletedMaps() {
            return TestRuntimeEstimators.this.completedMaps.get();
        }

        public int getCompletedReduces() {
            return TestRuntimeEstimators.this.completedReduces.get();
        }

        public TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int fromEventId, int maxEvents) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public TaskCompletionEvent[] getMapAttemptCompletionEvents(int startIndex, int maxEvents) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getQueueName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getTotalMaps() {
            return this.mapTasks.size();
        }

        public int getTotalReduces() {
            return this.reduceTasks.size();
        }

        public boolean isUber() {
            return false;
        }

        public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation) {
            return true;
        }

        public String getUserName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Path getConfFile() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<JobACL, AccessControlList> getJobACLs() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List<AMInfo> getAMInfos() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Configuration loadConfFile() {
            throw new UnsupportedOperationException();
        }

        public void setQueueName(String queueName) {
        }

        public void setJobPriority(Priority priority) {
        }

        public int getFailedMaps() {
            return 0;
        }

        public int getFailedReduces() {
            return 0;
        }

        public int getKilledMaps() {
            return 0;
        }

        public int getKilledReduces() {
            return 0;
        }
    }

    class MyTaskImpl
    implements Task {
        private final TaskId taskID;
        private final Map<TaskAttemptId, TaskAttempt> attempts = new ConcurrentHashMap<TaskAttemptId, TaskAttempt>(4);

        MyTaskImpl(JobId jobID, int index, TaskType type) {
            this.taskID = (TaskId)TestRuntimeEstimators.this.recordFactory.newRecordInstance(TaskId.class);
            this.taskID.setId(index);
            this.taskID.setTaskType(type);
            this.taskID.setJobId(jobID);
        }

        void addAttempt() {
            MyTaskAttemptImpl taskAttempt = new MyTaskAttemptImpl(this.taskID, this.attempts.size(), (Clock)TestRuntimeEstimators.this.clock);
            TaskAttemptId taskAttemptID = taskAttempt.getID();
            this.attempts.put(taskAttemptID, taskAttempt);
            System.out.println("TLTRE.MyTaskImpl.addAttempt " + this.getID());
            SpeculatorEvent event = new SpeculatorEvent(this.taskID, 1);
            TestRuntimeEstimators.this.dispatcher.getEventHandler().handle((Event)event);
        }

        public TaskId getID() {
            return this.taskID;
        }

        public TaskReport getReport() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Counters getCounters() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public float getProgress() {
            float result = 0.0f;
            for (TaskAttempt attempt : this.attempts.values()) {
                result = Math.max(result, attempt.getProgress());
            }
            return result;
        }

        public TaskType getType() {
            return this.taskID.getTaskType();
        }

        public Map<TaskAttemptId, TaskAttempt> getAttempts() {
            HashMap<TaskAttemptId, TaskAttempt> result = new HashMap<TaskAttemptId, TaskAttempt>(this.attempts.size());
            result.putAll(this.attempts);
            return result;
        }

        public TaskAttempt getAttempt(TaskAttemptId attemptID) {
            return this.attempts.get(attemptID);
        }

        public boolean isFinished() {
            for (TaskAttempt attempt : this.attempts.values()) {
                if (attempt.getState() != TaskAttemptState.SUCCEEDED) continue;
                return true;
            }
            return false;
        }

        public boolean canCommit(TaskAttemptId taskAttemptID) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public TaskState getState() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class SpeculationRequestEventHandler
    implements EventHandler<TaskEvent> {
        SpeculationRequestEventHandler() {
        }

        public void handle(TaskEvent event) {
            TaskId taskID = event.getTaskID();
            Task task = TestRuntimeEstimators.this.myJob.getTask(taskID);
            Assert.assertEquals((String)"Wrong type event", (Object)TaskEventType.T_ADD_SPEC_ATTEMPT, (Object)event.getType());
            System.out.println("SpeculationRequestEventHandler.handle adds a speculation task for " + taskID);
            TestRuntimeEstimators.this.addAttempt(task);
        }
    }
}

