/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AccessControlList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.obs.FileConflictException;
import org.apache.hadoop.fs.obs.OBSBlockOutputStream;
import org.apache.hadoop.fs.obs.OBSClientFactory;
import org.apache.hadoop.fs.obs.OBSCommonUtils;
import org.apache.hadoop.fs.obs.OBSConstants;
import org.apache.hadoop.fs.obs.OBSDataBlocks;
import org.apache.hadoop.fs.obs.OBSFileStatus;
import org.apache.hadoop.fs.obs.OBSInputStream;
import org.apache.hadoop.fs.obs.OBSListing;
import org.apache.hadoop.fs.obs.OBSLoginHelper;
import org.apache.hadoop.fs.obs.OBSObjectBucketUtils;
import org.apache.hadoop.fs.obs.OBSPosixBucketUtils;
import org.apache.hadoop.fs.obs.OBSWriteOperationHelper;
import org.apache.hadoop.fs.obs.SseWrapper;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.SemaphoredDelegatingExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class OBSFileSystem
extends FileSystem {
    public static final Logger LOG = LoggerFactory.getLogger(OBSFileSystem.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private URI uri;
    private Path workingDir;
    private String username;
    private ObsClient obs;
    private boolean enablePosix = false;
    private boolean enableMultiObjectDeleteRecursion = true;
    private boolean obsContentSummaryEnable = true;
    private boolean obsClientDFSListEnable = true;
    private String bucket;
    private int maxKeys;
    private OBSListing obsListing;
    private OBSWriteOperationHelper writeHelper;
    private long partSize;
    private boolean enableMultiObjectDelete;
    private int multiDeleteThreshold;
    private int maxEntriesToDelete;
    private ExecutorService boundedMultipartUploadThreadPool;
    private ThreadPoolExecutor boundedCopyThreadPool;
    private ThreadPoolExecutor boundedDeleteThreadPool;
    private ThreadPoolExecutor boundedCopyPartThreadPool;
    private ThreadPoolExecutor boundedListThreadPool;
    private int listParallelFactor;
    private long readAheadRange;
    private boolean readTransformEnable = true;
    private OBSDataBlocks.BlockFactory blockFactory;
    private int blockOutputActiveBlocks;
    private long copyPartSize;
    private boolean enableTrash = false;
    private String trashDir;
    private AccessControlList cannedACL;
    private SseWrapper sse;
    private long blockSize;

    public void initialize(URI name, Configuration originalConf) throws IOException {
        this.uri = URI.create(name.getScheme() + "://" + name.getAuthority());
        this.bucket = name.getAuthority();
        Configuration conf = OBSCommonUtils.propagateBucketOptions(originalConf, this.bucket);
        OBSCommonUtils.patchSecurityCredentialProviders(conf);
        super.initialize(name, conf);
        this.setConf(conf);
        try {
            this.username = UserGroupInformation.getCurrentUser().getShortUserName();
            this.workingDir = new Path("/user", this.username).makeQualified(this.uri, this.getWorkingDirectory());
            Class obsClientFactoryClass = conf.getClass("fs.obs.client.factory.impl", OBSConstants.DEFAULT_OBS_CLIENT_FACTORY_IMPL, OBSClientFactory.class);
            this.obs = ((OBSClientFactory)ReflectionUtils.newInstance((Class)obsClientFactoryClass, (Configuration)conf)).createObsClient(name);
            this.sse = new SseWrapper(conf);
            OBSCommonUtils.verifyBucketExists(this);
            this.enablePosix = OBSCommonUtils.getBucketFsStatus(this.obs, this.bucket);
            this.maxKeys = OBSCommonUtils.intOption(conf, "fs.obs.paging.maximum", 1000, 1);
            this.obsListing = new OBSListing(this);
            this.partSize = OBSCommonUtils.getMultipartSizeProperty(conf, "fs.obs.multipart.size", 0x6400000L);
            this.blockSize = OBSCommonUtils.longBytesOption(conf, "fs.obs.block.size", 0x8000000L, 1L);
            this.enableMultiObjectDelete = conf.getBoolean("fs.obs.multiobjectdelete.enable", true);
            this.maxEntriesToDelete = conf.getInt("fs.obs.multiobjectdelete.maximum", 1000);
            this.enableMultiObjectDeleteRecursion = conf.getBoolean("fs.obs.multiobjectdelete.recursion", true);
            this.obsContentSummaryEnable = conf.getBoolean("fs.obs.content.summary.enable", true);
            this.readAheadRange = OBSCommonUtils.longBytesOption(conf, "fs.obs.readahead.range", 0x100000L, 0L);
            this.readTransformEnable = conf.getBoolean("fs.obs.read.transform.enable", true);
            this.multiDeleteThreshold = conf.getInt("fs.obs.multiobjectdelete.threshold", 3);
            this.initThreadPools(conf);
            this.writeHelper = new OBSWriteOperationHelper(this);
            this.initCannedAcls(conf);
            OBSCommonUtils.initMultipartUploads(this, conf);
            String blockOutputBuffer = conf.getTrimmed("fs.obs.fast.upload.buffer", "disk");
            this.partSize = OBSCommonUtils.ensureOutputParameterInRange("fs.obs.multipart.size", this.partSize);
            this.blockFactory = OBSDataBlocks.createFactory(this, blockOutputBuffer);
            this.blockOutputActiveBlocks = OBSCommonUtils.intOption(conf, "fs.obs.fast.upload.active.blocks", 4, 1);
            LOG.debug("Using OBSBlockOutputStream with buffer = {}; block={}; queue limit={}", new Object[]{blockOutputBuffer, this.partSize, this.blockOutputActiveBlocks});
            this.enableTrash = conf.getBoolean("fs.obs.trash.enable", false);
            if (this.enableTrash) {
                if (!this.isFsBucket()) {
                    String errorMsg = String.format("The bucket [%s] is not posix. not supported for trash.", this.bucket);
                    LOG.warn(errorMsg);
                    this.enableTrash = false;
                    this.trashDir = null;
                } else {
                    this.trashDir = conf.get("fs.obs.trash.dir");
                    if (StringUtils.isEmpty((CharSequence)this.trashDir)) {
                        String errorMsg = String.format("The trash feature(fs.obs.trash.enable) is enabled, but the configuration(fs.obs.trash.dir [%s]) is empty.", this.trashDir);
                        LOG.error(errorMsg);
                        throw new ObsException(errorMsg);
                    }
                    this.trashDir = OBSCommonUtils.maybeAddBeginningSlash(this.trashDir);
                    this.trashDir = OBSCommonUtils.maybeAddTrailingSlash(this.trashDir);
                }
            }
        }
        catch (ObsException e) {
            throw OBSCommonUtils.translateException("initializing ", new Path(name), e);
        }
    }

    private void initThreadPools(Configuration conf) {
        long keepAliveTime = OBSCommonUtils.longOption(conf, "fs.obs.threads.keepalivetime", 60L, 0L);
        int maxThreads = conf.getInt("fs.obs.threads.max", 20);
        if (maxThreads < 2) {
            LOG.warn("fs.obs.threads.max must be at least 2: forcing to 2.");
            maxThreads = 2;
        }
        int totalTasks = OBSCommonUtils.intOption(conf, "fs.obs.max.total.tasks", 20, 1);
        this.boundedMultipartUploadThreadPool = BlockingThreadPoolExecutorService.newInstance((int)maxThreads, (int)(maxThreads + totalTasks), (long)keepAliveTime, (TimeUnit)TimeUnit.SECONDS, (String)"obs-transfer-shared");
        int maxDeleteThreads = conf.getInt("fs.obs.delete.threads.max", 20);
        if (maxDeleteThreads < 2) {
            LOG.warn("fs.obs.delete.threads.max must be at least 2: forcing to 2.");
            maxDeleteThreads = 2;
        }
        int coreDeleteThreads = (int)Math.ceil((double)maxDeleteThreads / 2.0);
        this.boundedDeleteThreadPool = new ThreadPoolExecutor(coreDeleteThreads, maxDeleteThreads, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), BlockingThreadPoolExecutorService.newDaemonThreadFactory((String)"obs-delete-transfer-shared"));
        this.boundedDeleteThreadPool.allowCoreThreadTimeOut(true);
        if (this.enablePosix) {
            this.obsClientDFSListEnable = conf.getBoolean("fs.obs.client.dfs.list.enable", true);
            if (this.obsClientDFSListEnable) {
                int coreListThreads = conf.getInt("fs.obs.list.threads.core", 30);
                int maxListThreads = conf.getInt("fs.obs.list.threads.max", 60);
                int listWorkQueueCapacity = conf.getInt("fs.obs.list.workqueue.capacity", 1024);
                this.listParallelFactor = conf.getInt("fs.obs.list.parallel.factor", 30);
                if (this.listParallelFactor < 1) {
                    LOG.warn("fs.obs.list.parallel.factor must be at least 1: forcing to 1.");
                    this.listParallelFactor = 1;
                }
                this.boundedListThreadPool = new ThreadPoolExecutor(coreListThreads, maxListThreads, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(listWorkQueueCapacity), BlockingThreadPoolExecutorService.newDaemonThreadFactory((String)"obs-list-transfer-shared"));
                this.boundedListThreadPool.allowCoreThreadTimeOut(true);
            }
        } else {
            int maxCopyPartThreads;
            int maxCopyThreads = conf.getInt("fs.obs.copy.threads.max", 40);
            if (maxCopyThreads < 2) {
                LOG.warn("fs.obs.copy.threads.max must be at least 2: forcing to 2.");
                maxCopyThreads = 2;
            }
            int coreCopyThreads = (int)Math.ceil((double)maxCopyThreads / 2.0);
            this.boundedCopyThreadPool = new ThreadPoolExecutor(coreCopyThreads, maxCopyThreads, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), BlockingThreadPoolExecutorService.newDaemonThreadFactory((String)"obs-copy-transfer-shared"));
            this.boundedCopyThreadPool.allowCoreThreadTimeOut(true);
            this.copyPartSize = OBSCommonUtils.longOption(conf, "fs.obs.copypart.size", 0x6400000L, 0L);
            if (this.copyPartSize > 0x140000000L) {
                LOG.warn("obs: {} capped to ~5GB (maximum allowed part size with current output mechanism)", (Object)"fs.obs.copypart.size");
                this.copyPartSize = 0x140000000L;
            }
            if ((maxCopyPartThreads = conf.getInt("fs.obs.copypart.threads.max", 40)) < 2) {
                LOG.warn("fs.obs.copypart.threads.max must be at least 2: forcing to 2.");
                maxCopyPartThreads = 2;
            }
            int coreCopyPartThreads = (int)Math.ceil((double)maxCopyPartThreads / 2.0);
            this.boundedCopyPartThreadPool = new ThreadPoolExecutor(coreCopyPartThreads, maxCopyPartThreads, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), BlockingThreadPoolExecutorService.newDaemonThreadFactory((String)"obs-copy-part-transfer-shared"));
            this.boundedCopyPartThreadPool.allowCoreThreadTimeOut(true);
        }
    }

    boolean isFsBucket() {
        return this.enablePosix;
    }

    boolean isReadTransformEnabled() {
        return this.readTransformEnable;
    }

    private void initCannedAcls(Configuration conf) {
        String cannedACLName = conf.get("fs.obs.acl.default", "");
        if (!cannedACLName.isEmpty()) {
            switch (cannedACLName) {
                case "Private": 
                case "PublicRead": 
                case "PublicReadWrite": 
                case "AuthenticatedRead": 
                case "LogDeliveryWrite": 
                case "BucketOwnerRead": 
                case "BucketOwnerFullControl": {
                    this.cannedACL = new AccessControlList();
                    break;
                }
                default: {
                    this.cannedACL = null;
                    break;
                }
            }
        } else {
            this.cannedACL = null;
        }
    }

    AccessControlList getCannedACL() {
        return this.cannedACL;
    }

    public String getScheme() {
        return "obs";
    }

    public URI getUri() {
        return this.uri;
    }

    public int getDefaultPort() {
        return -1;
    }

    @VisibleForTesting
    ObsClient getObsClient() {
        return this.obs;
    }

    @VisibleForTesting
    long getReadAheadRange() {
        return this.readAheadRange;
    }

    String getBucket() {
        return this.bucket;
    }

    public void checkPath(Path path) {
        OBSLoginHelper.checkPath(this.getConf(), this.getUri(), path, this.getDefaultPort());
    }

    protected URI canonicalizeUri(URI rawUri) {
        return OBSLoginHelper.canonicalizeUri(rawUri, this.getDefaultPort());
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        LOG.debug("Opening '{}' for reading.", (Object)f);
        FileStatus fileStatus = this.getFileStatus(f);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException("Can't open " + f + " because it is a directory");
        }
        return new FSDataInputStream((InputStream)((Object)new OBSInputStream(this.bucket, OBSCommonUtils.pathToKey(this, f), fileStatus.getLen(), this.obs, this.statistics, this.readAheadRange, this)));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blkSize, Progressable progress) throws IOException {
        String key = OBSCommonUtils.pathToKey(this, f);
        long objectLen = 0L;
        try {
            FileStatus status = this.getFileStatus(f);
            objectLen = status.getLen();
            if (status.isDirectory()) {
                throw new FileAlreadyExistsException(f + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(f + " already exists");
            }
            LOG.debug("create: Overwriting file {}", (Object)f);
        }
        catch (FileNotFoundException e) {
            LOG.debug("create: Creating new file {}", (Object)f);
        }
        return new FSDataOutputStream((OutputStream)new OBSBlockOutputStream(this, key, objectLen, (ExecutorService)new SemaphoredDelegatingExecutor(this.boundedMultipartUploadThreadPool, this.blockOutputActiveBlocks, true), false), null);
    }

    long getPartSize() {
        return this.partSize;
    }

    OBSDataBlocks.BlockFactory getBlockFactory() {
        return this.blockFactory;
    }

    OBSWriteOperationHelper getWriteHelper() {
        return this.writeHelper;
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blkSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        LOG.debug("create: Creating new file {}, flags:{}, isFsBucket:{}", new Object[]{f, flags, this.isFsBucket()});
        if (null != flags && flags.contains(CreateFlag.APPEND)) {
            if (!this.isFsBucket()) {
                throw new UnsupportedOperationException("non-posix bucket. Append is not supported by OBSFileSystem");
            }
            String key = OBSCommonUtils.pathToKey(this, f);
            long objectLen = 0L;
            try {
                FileStatus status = this.getFileStatus(f);
                objectLen = status.getLen();
                if (status.isDirectory()) {
                    throw new FileAlreadyExistsException(f + " is a directory");
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug("FileNotFoundException, create: Creating new file {}", (Object)f);
            }
            return new FSDataOutputStream((OutputStream)new OBSBlockOutputStream(this, key, objectLen, (ExecutorService)new SemaphoredDelegatingExecutor(this.boundedMultipartUploadThreadPool, this.blockOutputActiveBlocks, true), true), null);
        }
        return this.create(f, permission, flags == null || flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blkSize, progress);
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blkSize, Progressable progress) throws IOException {
        Path parent = path.getParent();
        if (parent != null && !this.getFileStatus(parent).isDirectory()) {
            throw new FileAlreadyExistsException("Not a directory: " + parent);
        }
        return this.create(path, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blkSize, progress);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        if (!this.isFsBucket()) {
            throw new UnsupportedOperationException("non-posix bucket. Append is not supported by OBSFileSystem");
        }
        LOG.debug("append: Append file {}.", (Object)f);
        String key = OBSCommonUtils.pathToKey(this, f);
        FileStatus status = this.getFileStatus(f);
        long objectLen = status.getLen();
        if (status.isDirectory()) {
            throw new FileAlreadyExistsException(f + " is a directory");
        }
        return new FSDataOutputStream((OutputStream)new OBSBlockOutputStream(this, key, objectLen, (ExecutorService)new SemaphoredDelegatingExecutor(this.boundedMultipartUploadThreadPool, this.blockOutputActiveBlocks, true), true), null);
    }

    public boolean exists(Path f) throws IOException {
        try {
            return this.getFileStatus(f) != null;
        }
        catch (FileNotFoundException | FileConflictException e) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean rename(Path src, Path dst) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    int getMaxEntriesToDelete() {
        return this.maxEntriesToDelete;
    }

    int getListParallelFactor() {
        return this.listParallelFactor;
    }

    ThreadPoolExecutor getBoundedListThreadPool() {
        return this.boundedListThreadPool;
    }

    boolean isObsClientDFSListEnable() {
        return this.obsClientDFSListEnable;
    }

    FileSystem.Statistics getSchemeStatistics() {
        return this.statistics;
    }

    int getMultiDeleteThreshold() {
        return this.multiDeleteThreshold;
    }

    boolean isEnableMultiObjectDelete() {
        return this.enableMultiObjectDelete;
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        try {
            FileStatus status = this.getFileStatus(f);
            LOG.debug("delete: path {} - recursive {}", (Object)status.getPath(), (Object)recursive);
            if (this.enablePosix) {
                return OBSPosixBucketUtils.fsDelete(this, status, recursive);
            }
            return OBSObjectBucketUtils.objectDelete(this, status, recursive);
        }
        catch (FileNotFoundException e) {
            LOG.warn("Couldn't delete {} - does not exist", (Object)f);
            return false;
        }
        catch (ObsException e) {
            throw OBSCommonUtils.translateException("delete", f, e);
        }
    }

    boolean isEnableTrash() {
        return this.enableTrash;
    }

    String getTrashDir() {
        return this.trashDir;
    }

    boolean isEnableMultiObjectDeleteRecursion() {
        return this.enableMultiObjectDeleteRecursion;
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        try {
            FileStatus[] statuses = OBSCommonUtils.innerListStatus(this, f, false);
            long endTime = System.currentTimeMillis();
            LOG.debug("List status for path:{}, thread:{}, timeUsedInMilliSec:{}", new Object[]{f, threadId, endTime - startTime});
            return statuses;
        }
        catch (ObsException e) {
            throw OBSCommonUtils.translateException("listStatus", f, e);
        }
    }

    public FileStatus[] listStatus(Path f, boolean recursive) throws FileNotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        try {
            FileStatus[] statuses = OBSCommonUtils.innerListStatus(this, f, recursive);
            long endTime = System.currentTimeMillis();
            LOG.debug("List status for path:{}, thread:{}, timeUsedInMilliSec:{}", new Object[]{f, threadId, endTime - startTime});
            return statuses;
        }
        catch (ObsException e) {
            throw OBSCommonUtils.translateException("listStatus with recursive flag[" + (recursive ? "true] " : "false] "), f, e);
        }
    }

    OBSListing getObsListing() {
        return this.obsListing;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    String getUsername() {
        return this.username;
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException, FileAlreadyExistsException {
        try {
            return OBSCommonUtils.innerMkdirs(this, path);
        }
        catch (ObsException e) {
            throw OBSCommonUtils.translateException("mkdirs", path, e);
        }
    }

    public FileStatus getFileStatus(Path f) throws FileNotFoundException, IOException {
        for (int retryTime = 1; retryTime < 3; ++retryTime) {
            try {
                return this.innerGetFileStatus(f);
            }
            catch (FileNotFoundException | FileConflictException e) {
                throw e;
            }
            catch (IOException e) {
                LOG.warn("Failed to get file status for [{}], retry time [{}], exception [{}]", new Object[]{f, retryTime, e});
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw e;
                }
            }
        }
        return this.innerGetFileStatus(f);
    }

    @VisibleForTesting
    OBSFileStatus innerGetFileStatus(Path f) throws IOException {
        if (this.enablePosix) {
            return OBSPosixBucketUtils.innerFsGetObjectStatus(this, f);
        }
        return OBSObjectBucketUtils.innerGetObjectStatus(this, f);
    }

    public ContentSummary getContentSummary(Path f) throws FileNotFoundException, IOException {
        if (!this.obsContentSummaryEnable) {
            return super.getContentSummary(f);
        }
        FileStatus status = this.getFileStatus(f);
        if (status.isFile()) {
            long length = status.getLen();
            return new ContentSummary.Builder().length(length).fileCount(1L).directoryCount(0L).spaceConsumed(length).build();
        }
        if (this.enablePosix) {
            return OBSPosixBucketUtils.fsGetDirectoryContentSummary(this, OBSCommonUtils.pathToKey(this, f));
        }
        return OBSObjectBucketUtils.getDirectoryContentSummary(this, OBSCommonUtils.pathToKey(this, f));
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws FileAlreadyExistsException, IOException {
        try {
            super.copyFromLocalFile(delSrc, overwrite, src, dst);
        }
        catch (ObsException e) {
            throw OBSCommonUtils.translateException("copyFromLocalFile(" + src + ", " + dst + ")", src, e);
        }
    }

    public void close() throws IOException {
        LOG.debug("This Filesystem closed by user, clear resource.");
        if (this.closed.getAndSet(true)) {
            return;
        }
        try {
            super.close();
        }
        catch (Throwable throwable) {
            OBSCommonUtils.shutdownAll(this.boundedMultipartUploadThreadPool, this.boundedCopyThreadPool, this.boundedDeleteThreadPool, this.boundedCopyPartThreadPool, this.boundedListThreadPool);
            throw throwable;
        }
        OBSCommonUtils.shutdownAll(this.boundedMultipartUploadThreadPool, this.boundedCopyThreadPool, this.boundedDeleteThreadPool, this.boundedCopyPartThreadPool, this.boundedListThreadPool);
    }

    public String getCanonicalServiceName() {
        return null;
    }

    long getCopyPartSize() {
        return this.copyPartSize;
    }

    ThreadPoolExecutor getBoundedCopyPartThreadPool() {
        return this.boundedCopyPartThreadPool;
    }

    ThreadPoolExecutor getBoundedCopyThreadPool() {
        return this.boundedCopyThreadPool;
    }

    public long getDefaultBlockSize() {
        return this.blockSize;
    }

    public long getDefaultBlockSize(Path f) {
        return this.blockSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OBSFileSystem{");
        sb.append("uri=").append(this.uri);
        sb.append(", workingDir=").append(this.workingDir);
        sb.append(", partSize=").append(this.partSize);
        sb.append(", enableMultiObjectsDelete=").append(this.enableMultiObjectDelete);
        sb.append(", maxKeys=").append(this.maxKeys);
        if (this.cannedACL != null) {
            sb.append(", cannedACL=").append(this.cannedACL.toString());
        }
        sb.append(", readAheadRange=").append(this.readAheadRange);
        sb.append(", blockSize=").append(this.getDefaultBlockSize());
        if (this.blockFactory != null) {
            sb.append(", blockFactory=").append(this.blockFactory);
        }
        sb.append(", boundedMultipartUploadThreadPool=").append(this.boundedMultipartUploadThreadPool);
        sb.append(", statistics {").append(this.statistics).append("}");
        sb.append(", metrics {").append("}");
        sb.append('}');
        return sb.toString();
    }

    int getMaxKeys() {
        return this.maxKeys;
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        Path path = OBSCommonUtils.qualify(this, f);
        LOG.debug("listFiles({}, {})", (Object)path, (Object)recursive);
        try {
            FileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isFile()) {
                LOG.debug("Path is a file");
                return new OBSListing.SingleStatusRemoteIterator(OBSCommonUtils.toLocatedFileStatus(this, fileStatus));
            }
            LOG.debug("listFiles: doing listFiles of directory {} - recursive {}", (Object)path, (Object)recursive);
            String key = OBSCommonUtils.maybeAddTrailingSlash(OBSCommonUtils.pathToKey(this, path));
            String delimiter = recursive ? null : "/";
            LOG.debug("Requesting all entries under {} with delimiter '{}'", (Object)key, (Object)delimiter);
            return this.obsListing.createLocatedFileStatusIterator(this.obsListing.createFileStatusListingIterator(path, OBSCommonUtils.createListObjectsRequest(this, key, delimiter), OBSListing.ACCEPT_ALL, new OBSListing.AcceptFilesOnly(path)));
        }
        catch (ObsException e) {
            throw OBSCommonUtils.translateException("listFiles", path, e);
        }
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.listLocatedStatus(f, OBSListing.ACCEPT_ALL);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        Path path = OBSCommonUtils.qualify(this, f);
        LOG.debug("listLocatedStatus({}, {}", (Object)path, (Object)filter);
        try {
            FileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isFile()) {
                LOG.debug("Path is a file");
                return new OBSListing.SingleStatusRemoteIterator(filter.accept(path) ? OBSCommonUtils.toLocatedFileStatus(this, fileStatus) : null);
            }
            String key = OBSCommonUtils.maybeAddTrailingSlash(OBSCommonUtils.pathToKey(this, path));
            return this.obsListing.createLocatedFileStatusIterator(this.obsListing.createFileStatusListingIterator(path, OBSCommonUtils.createListObjectsRequest(this, key, "/"), filter, new OBSListing.AcceptAllButSelfAndS3nDirs(path)));
        }
        catch (ObsException e) {
            throw OBSCommonUtils.translateException("listLocatedStatus", path, e);
        }
    }

    SseWrapper getSse() {
        return this.sse;
    }
}

