/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicyDefault;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.VolumeScanner;
import org.apache.hadoop.hdfs.server.datanode.checker.DatasetVolumeChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.ThrottledAsyncChecker;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.top.metrics.TopMetrics;
import org.apache.hadoop.http.HttpRequestLog;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.GSet;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotTestHelper {
    static final Logger LOG = LoggerFactory.getLogger(SnapshotTestHelper.class);

    public static void disableLogs() {
        String[] lognames;
        for (String n : lognames = new String[]{"org.eclipse.jetty", "org.apache.hadoop.ipc", "org.apache.hadoop.net", "org.apache.hadoop.security", "org.apache.hadoop.hdfs.server.blockmanagement", "org.apache.hadoop.hdfs.server.common.Util", "org.apache.hadoop.hdfs.server.datanode", "org.apache.hadoop.hdfs.server.namenode.FileJournalManager", "org.apache.hadoop.hdfs.server.namenode.NNStorageRetentionManager", "org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf", "org.apache.hadoop.hdfs.server.namenode.FSEditLog"}) {
            GenericTestUtils.disableLog((Logger)LoggerFactory.getLogger((String)n));
        }
        GenericTestUtils.disableLog((Logger)LoggerFactory.getLogger(UserGroupInformation.class));
        GenericTestUtils.disableLog((Logger)LoggerFactory.getLogger(BlockManager.class));
        GenericTestUtils.disableLog((Logger)LoggerFactory.getLogger(FSNamesystem.class));
        GenericTestUtils.disableLog((Logger)LoggerFactory.getLogger(DirectoryScanner.class));
        GenericTestUtils.disableLog((Logger)LoggerFactory.getLogger(MetricsSystemImpl.class));
        GenericTestUtils.disableLog((Logger)DatasetVolumeChecker.LOG);
        GenericTestUtils.disableLog((Logger)DatanodeDescriptor.LOG);
        GenericTestUtils.disableLog((Logger)GSet.LOG);
        GenericTestUtils.disableLog((Logger)TopMetrics.LOG);
        GenericTestUtils.disableLog((Logger)HttpRequestLog.LOG);
        GenericTestUtils.disableLog((Logger)ThrottledAsyncChecker.LOG);
        GenericTestUtils.disableLog((Logger)VolumeScanner.LOG);
        GenericTestUtils.disableLog((Logger)BlockScanner.LOG);
        GenericTestUtils.disableLog((Logger)HttpServer2.LOG);
        GenericTestUtils.disableLog((Logger)DataNode.LOG);
        GenericTestUtils.disableLog((Logger)BlockPoolSliceStorage.LOG);
        GenericTestUtils.disableLog((Logger)LeaseManager.LOG);
        GenericTestUtils.disableLog((Logger)NameNode.stateChangeLog);
        GenericTestUtils.disableLog((Logger)NameNode.blockStateChangeLog);
        GenericTestUtils.disableLog((Logger)DFSClient.LOG);
        GenericTestUtils.disableLog((Logger)ProtobufRpcEngine2.Server.LOG);
    }

    private SnapshotTestHelper() {
    }

    public static Path getSnapshotRoot(Path snapshottedDir, String snapshotName) {
        return new Path(snapshottedDir, ".snapshot/" + snapshotName);
    }

    public static Path getSnapshotPath(Path snapshottedDir, String snapshotName, String fileLocalName) {
        return new Path(SnapshotTestHelper.getSnapshotRoot(snapshottedDir, snapshotName), fileLocalName);
    }

    public static Path createSnapshot(DistributedFileSystem hdfs, Path snapshotRoot, String snapshotName) throws Exception {
        LOG.info("createSnapshot " + snapshotName + " for " + snapshotRoot);
        Assert.assertTrue((boolean)hdfs.exists(snapshotRoot));
        hdfs.allowSnapshot(snapshotRoot);
        hdfs.createSnapshot(snapshotRoot, snapshotName);
        hdfs.setQuota(snapshotRoot, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        return SnapshotTestHelper.getSnapshotRoot(snapshotRoot, snapshotName);
    }

    public static void checkSnapshotCreation(DistributedFileSystem hdfs, Path snapshotRoot, Path snapshottedDir) throws Exception {
        Assert.assertTrue((boolean)hdfs.exists(snapshotRoot));
        FileStatus[] currentFiles = hdfs.listStatus(snapshottedDir);
        FileStatus[] snapshotFiles = hdfs.listStatus(snapshotRoot);
        Assert.assertEquals((String)("snapshottedDir=" + snapshottedDir + ", snapshotRoot=" + snapshotRoot), (long)currentFiles.length, (long)snapshotFiles.length);
    }

    public static void compareDumpedTreeInFile(File file1, File file2, boolean compareQuota) throws IOException {
        try {
            SnapshotTestHelper.compareDumpedTreeInFile(file1, file2, compareQuota, false);
        }
        catch (Throwable t) {
            LOG.info("FAILED compareDumpedTreeInFile(" + file1 + ", " + file2 + ")", t);
            SnapshotTestHelper.compareDumpedTreeInFile(file1, file2, compareQuota, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compareDumpedTreeInFile(File file1, File file2, boolean compareQuota, boolean print) throws IOException {
        if (print) {
            SnapshotTestHelper.printFile(file1);
            SnapshotTestHelper.printFile(file2);
        }
        BufferedReader reader1 = new BufferedReader(new FileReader(file1));
        BufferedReader reader2 = new BufferedReader(new FileReader(file2));
        try {
            String line1 = "";
            String line2 = "";
            while ((line1 = reader1.readLine()) != null && (line2 = reader2.readLine()) != null) {
                if (print) {
                    System.out.println();
                    System.out.println("1) " + line1);
                    System.out.println("2) " + line2);
                }
                line1 = line1.replaceAll("INodeFileWithSnapshot", "INodeFile");
                line2 = line2.replaceAll("INodeFileWithSnapshot", "INodeFile");
                line1 = line1.replaceAll("@[\\dabcdef]+", "");
                line2 = line2.replaceAll("@[\\dabcdef]+", "");
                line1 = line1.replaceAll("replicas=\\[.*\\]", "replicas=[]");
                line2 = line2.replaceAll("replicas=\\[.*\\]", "replicas=[]");
                if (!compareQuota) {
                    line1 = line1.replaceAll("Quota\\[.*\\]", "Quota[]");
                    line2 = line2.replaceAll("Quota\\[.*\\]", "Quota[]");
                }
                if (line1.contains("(INodeFileSnapshot)") || line1.contains("(INodeFileUnderConstructionSnapshot)")) {
                    line1 = line1.replaceAll("\\{blockUCState=\\w+, primaryNodeIndex=[-\\d]+, replicas=\\[\\]\\}", "");
                    line2 = line2.replaceAll("\\{blockUCState=\\w+, primaryNodeIndex=[-\\d]+, replicas=\\[\\]\\}", "");
                }
                Assert.assertEquals((Object)line1.trim(), (Object)line2.trim());
            }
            Assert.assertNull((Object)reader1.readLine());
            Assert.assertNull((Object)reader2.readLine());
        }
        finally {
            reader1.close();
            reader2.close();
        }
    }

    static void printFile(File f) throws IOException {
        System.out.println();
        System.out.println("File: " + f);
        try (BufferedReader in = new BufferedReader(new FileReader(f));){
            String line;
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
        }
    }

    public static void dumpTree2File(FSDirectory fsdir, File f) throws IOException {
        PrintWriter out = new PrintWriter((Writer)new FileWriter(f, false), true);
        fsdir.getINode("/").dumpTreeRecursively(out, new StringBuilder(), 0x7FFFFFFE);
        out.close();
    }

    static Path getSnapshotFile(Path snapshotRoot, Path file) {
        Path rootParent = snapshotRoot.getParent();
        if (rootParent != null && rootParent.getName().equals(".snapshot")) {
            Path snapshotDir = rootParent.getParent();
            if (file.toString().contains(snapshotDir.toString()) && !file.equals((Object)snapshotDir)) {
                String fileName = file.toString().substring(snapshotDir.toString().length() + 1);
                Path snapshotFile = new Path(snapshotRoot, fileName);
                return snapshotFile;
            }
        }
        return null;
    }

    public static void dumpTree(String message, MiniDFSCluster cluster) throws UnresolvedLinkException {
        System.out.println("XXX " + message);
        try {
            cluster.getNameNode().getNamesystem().getFSDirectory().getINode("/").dumpTreeRecursively(System.out);
        }
        catch (UnresolvedLinkException ule) {
            throw ule;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    static class TestDirectoryTree {
        final int height;
        final Node topNode;
        final Map<Integer, ArrayList<Node>> levelMap;
        int id = 0;

        TestDirectoryTree(int height, FileSystem fs) throws Exception {
            this.height = height;
            this.topNode = new Node(new Path("/TestSnapshot"), 0, null, fs);
            this.levelMap = new HashMap<Integer, ArrayList<Node>>();
            this.addDirNode(this.topNode, 0);
            this.genChildren(this.topNode, height - 1, fs);
        }

        private void addDirNode(Node node, int atLevel) {
            ArrayList<Node> list = this.levelMap.get(atLevel);
            if (list == null) {
                list = new ArrayList();
                this.levelMap.put(atLevel, list);
            }
            list.add(node);
        }

        private void genChildren(Node parent, int level, FileSystem fs) throws Exception {
            if (level == 0) {
                return;
            }
            parent.leftChild = new Node(new Path(parent.nodePath, "left" + ++this.id), this.height - level, parent, fs);
            parent.rightChild = new Node(new Path(parent.nodePath, "right" + ++this.id), this.height - level, parent, fs);
            this.addDirNode(parent.leftChild, parent.leftChild.level);
            this.addDirNode(parent.rightChild, parent.rightChild.level);
            this.genChildren(parent.leftChild, level - 1, fs);
            this.genChildren(parent.rightChild, level - 1, fs);
        }

        Node getRandomDirNode(Random random, List<Node> excludedList) {
            Node randomNode;
            do {
                int level = random.nextInt(this.height);
                ArrayList<Node> levelList = this.levelMap.get(level);
                int index = random.nextInt(levelList.size());
                randomNode = levelList.get(index);
            } while (excludedList != null && excludedList.contains(randomNode));
            return randomNode;
        }

        static class Node {
            final int level;
            Node leftChild;
            Node rightChild;
            final Node parent;
            final Path nodePath;
            ArrayList<Path> fileList;
            int nullFileIndex = 0;
            final ArrayList<Node> nonSnapshotChildren;

            Node(Path path, int level, Node parent, FileSystem fs) throws Exception {
                this.nodePath = path;
                this.level = level;
                this.parent = parent;
                this.nonSnapshotChildren = new ArrayList();
                fs.mkdirs(this.nodePath);
            }

            void initFileList(FileSystem fs, String namePrefix, long fileLen, short replication, long seed, int numFiles) throws Exception {
                this.fileList = new ArrayList(numFiles);
                for (int i = 0; i < numFiles; ++i) {
                    Path file = new Path(this.nodePath, namePrefix + "-f" + i);
                    this.fileList.add(file);
                    if (i >= numFiles - 1) continue;
                    DFSTestUtil.createFile(fs, file, fileLen, replication, seed);
                }
                this.nullFileIndex = numFiles - 1;
            }

            public boolean equals(Object o) {
                if (o != null && o instanceof Node) {
                    Node node = (Node)o;
                    return node.nodePath.equals((Object)this.nodePath);
                }
                return false;
            }

            public int hashCode() {
                return this.nodePath.hashCode();
            }
        }
    }

    public static final class Log4jRecorder {
        private final StringWriter stringWriter = new StringWriter();
        private final WriterAppender appender;
        private final org.apache.log4j.Logger logger;

        static Log4jRecorder record(Logger logger) {
            return new Log4jRecorder(Log4jRecorder.toLog4j(logger), Log4jRecorder.getLayout());
        }

        static org.apache.log4j.Logger toLog4j(Logger logger) {
            return LogManager.getLogger((String)logger.getName());
        }

        static Layout getLayout() {
            org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
            Appender a = root.getAppender("stdout");
            if (a == null) {
                a = root.getAppender("console");
            }
            return a == null ? new PatternLayout() : a.getLayout();
        }

        private Log4jRecorder(org.apache.log4j.Logger logger, Layout layout) {
            this.appender = new WriterAppender(layout, (Writer)this.stringWriter);
            this.logger = logger;
            this.logger.addAppender((Appender)this.appender);
        }

        public String getRecorded() {
            return this.stringWriter.toString();
        }

        public void stop() {
            this.logger.removeAppender((Appender)this.appender);
        }

        public void clear() {
            this.stringWriter.getBuffer().setLength(0);
        }
    }

    static class MyCluster {
        private final MiniDFSCluster cluster;
        private final FSNamesystem fsn;
        private final FSDirectory fsdir;
        private final DistributedFileSystem hdfs;
        private final FsShell shell = new FsShell();
        private final Path snapshotDir = new Path("/");
        private final AtomicInteger snapshotCount = new AtomicInteger();
        private final AtomicInteger trashMoveCount = new AtomicInteger();
        private final AtomicInteger printTreeCount = new AtomicInteger();
        private final AtomicBoolean printTree = new AtomicBoolean();

        MyCluster(Configuration conf) throws Exception {
            this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
            this.fsn = this.cluster.getNamesystem();
            this.fsdir = this.fsn.getFSDirectory();
            this.cluster.waitActive();
            this.hdfs = this.cluster.getFileSystem();
            this.hdfs.allowSnapshot(this.snapshotDir);
            this.createSnapshot();
            this.shell.setConf(this.cluster.getConfiguration(0));
            this.runShell("-mkdir", "-p", ".Trash");
        }

        void setPrintTree(boolean print) {
            this.printTree.set(print);
        }

        boolean getPrintTree() {
            return this.printTree.get();
        }

        Path getTrashPath(Path p) throws Exception {
            Path trash = this.hdfs.getTrashRoot(p);
            Path resolved = this.hdfs.resolvePath(p);
            return new Path(trash, "Current/" + resolved.toUri().getPath());
        }

        int runShell(String ... argv) {
            return this.shell.run(argv);
        }

        String createSnapshot() throws Exception {
            String name = "s" + this.snapshotCount.getAndIncrement();
            SnapshotTestHelper.createSnapshot(this.hdfs, this.snapshotDir, name);
            return name;
        }

        void deleteSnapshot(String snapshotName) throws Exception {
            LOG.info("Before delete snapshot " + snapshotName);
            this.hdfs.deleteSnapshot(this.snapshotDir, snapshotName);
        }

        boolean assertExists(Path path) throws Exception {
            if (path == null) {
                return false;
            }
            if (!this.hdfs.exists(path)) {
                String err = "Path not found: " + path;
                this.printFs(err);
                throw new AssertionError((Object)err);
            }
            return true;
        }

        void printFs(String label) {
            PrintStream out = System.out;
            out.println();
            out.println();
            out.println("XXX " + this.printTreeCount.getAndIncrement() + ": " + label);
            if (this.printTree.get()) {
                this.fsdir.getRoot().dumpTreeRecursively(out);
            }
        }

        void shutdown() {
            LOG.info("snapshotCount: {}", (Object)this.snapshotCount);
            this.cluster.shutdown();
        }

        Path mkdirs(String dir) throws Exception {
            return this.mkdirs(new Path(dir));
        }

        Path mkdirs(Path dir) throws Exception {
            String label = "mkdirs " + dir;
            LOG.info(label);
            this.hdfs.mkdirs(dir);
            Assert.assertTrue((String)label, (boolean)this.hdfs.exists(dir));
            return dir;
        }

        Path createFile(String file) throws Exception {
            return this.createFile(new Path(file));
        }

        Path createFile(Path file) throws Exception {
            String label = "createFile " + file;
            LOG.info(label);
            DFSTestUtil.createFile((FileSystem)this.hdfs, file, 0L, (short)1, 0L);
            Assert.assertTrue((String)label, (boolean)this.hdfs.exists(file));
            return file;
        }

        String rename(Path src, Path dst) throws Exception {
            this.assertExists(src);
            String snapshot = this.createSnapshot();
            String label = "rename " + src + " -> " + dst;
            boolean renamed = this.hdfs.rename(src, dst);
            LOG.info("{}: success? {}", (Object)label, (Object)renamed);
            Assert.assertTrue((String)label, (boolean)renamed);
            return snapshot;
        }

        Path moveToTrash(Path path, boolean printFs) throws Exception {
            return this.moveToTrash(path.toString(), printFs);
        }

        Path moveToTrash(String path, boolean printFs) throws Exception {
            Log4jRecorder recorder = Log4jRecorder.record(LoggerFactory.getLogger(TrashPolicyDefault.class));
            this.runShell("-rm", "-r", path);
            String label = "moveToTrash-" + this.trashMoveCount.getAndIncrement() + " " + path;
            if (printFs) {
                this.printFs(label);
            } else {
                LOG.info(label);
            }
            String recorded = recorder.getRecorded();
            LOG.info("Recorded: {}", (Object)recorded);
            String pattern = " to trash at: ";
            int i = recorded.indexOf(" to trash at: ");
            if (i > 0) {
                String sub = recorded.substring(i + " to trash at: ".length());
                return new Path(sub.trim());
            }
            return null;
        }
    }
}

