/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestWebHdfsWithRestCsrfPreventionFilter {
    private static final Path FILE = new Path("/file");
    private final boolean nnRestCsrf;
    private final boolean dnRestCsrf;
    private final boolean clientRestCsrf;
    private MiniDFSCluster cluster;
    private FileSystem fs;
    private FileSystem webhdfs;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    public TestWebHdfsWithRestCsrfPreventionFilter(boolean nnRestCsrf, boolean dnRestCsrf, boolean clientRestCsrf) {
        this.nnRestCsrf = nnRestCsrf;
        this.dnRestCsrf = dnRestCsrf;
        this.clientRestCsrf = clientRestCsrf;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({false, false, false}, {true, true, true}, {true, true, false}, {true, false, true}, {true, false, false}, {false, true, true}, {false, true, false}, {false, false, true});
    }

    @Before
    public void before() throws Exception {
        Configuration nnConf = new Configuration();
        nnConf.setBoolean("dfs.webhdfs.rest-csrf.enabled", this.nnRestCsrf);
        nnConf.set("dfs.webhdfs.rest-csrf.browser-useragents-regex", ".*");
        this.cluster = new MiniDFSCluster.Builder(nnConf).numDataNodes(0).build();
        Configuration dnConf = new Configuration(nnConf);
        dnConf.setBoolean("dfs.webhdfs.rest-csrf.enabled", this.dnRestCsrf);
        dnConf.set("dfs.datanode.httpserver.filter.handlers", "org.apache.hadoop.hdfs.server.datanode.web.RestCsrfPreventionFilterHandler");
        this.cluster.startDataNodes(dnConf, 1, true, null, null, null, null, false);
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        Configuration clientConf = new Configuration();
        clientConf.setBoolean("dfs.webhdfs.rest-csrf.enabled", this.clientRestCsrf);
        InetSocketAddress addr = this.cluster.getNameNode().getHttpAddress();
        this.webhdfs = FileSystem.get((URI)URI.create("webhdfs://" + NetUtils.getHostPortString((InetSocketAddress)addr)), (Configuration)clientConf);
    }

    @After
    public void after() {
        IOUtils.closeStream((Closeable)this.webhdfs);
        IOUtils.closeStream((Closeable)this.fs);
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testCreate() throws Exception {
        if ((this.nnRestCsrf || this.dnRestCsrf) && !this.clientRestCsrf) {
            this.expectException();
        }
        Assert.assertTrue((boolean)this.webhdfs.createNewFile(FILE));
    }

    @Test
    public void testDelete() throws Exception {
        DFSTestUtil.createFile(this.fs, FILE, 1024L, (short)1, 0L);
        if (this.nnRestCsrf && !this.clientRestCsrf) {
            this.expectException();
        }
        Assert.assertTrue((boolean)this.webhdfs.delete(FILE, false));
    }

    @Test
    public void testGetFileStatus() throws Exception {
        Assert.assertNotNull((Object)this.webhdfs.getFileStatus(new Path("/")));
    }

    @Test
    public void testTruncate() throws Exception {
        DFSTestUtil.createFile(this.fs, FILE, 1024L, (short)1, 0L);
        if (this.nnRestCsrf && !this.clientRestCsrf) {
            this.expectException();
        }
        Assert.assertTrue((String)"WebHdfs supports truncate", (boolean)this.webhdfs.hasPathCapability(FILE, "fs.capability.paths.truncate"));
        Assert.assertTrue((boolean)this.webhdfs.truncate(FILE, 0L));
    }

    private void expectException() {
        this.exception.expect(IOException.class);
        this.exception.expectMessage("Missing Required Header");
    }
}

