/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.server.datanode.BlockReceiver;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiver;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.util.DataChecksum;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestDataXceiverLazyPersistHint {
    @Rule
    public Timeout timeout = new Timeout(300000);

    @Test
    public void testWithLocalClient() throws IOException {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Boolean.class);
        DataXceiver xceiver = TestDataXceiverLazyPersistHint.makeStubDataXceiver(PeerLocality.LOCAL, NonLocalLazyPersist.NOT_ALLOWED, (ArgumentCaptor<Boolean>)captor);
        for (Boolean lazyPersistSetting : Arrays.asList(true, false)) {
            this.issueWriteBlockCall(xceiver, lazyPersistSetting);
            MatcherAssert.assertThat((Object)((Boolean)captor.getValue()), (Matcher)Is.is((Object)lazyPersistSetting));
        }
    }

    @Test
    public void testWithRemoteClient() throws IOException {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Boolean.class);
        DataXceiver xceiver = TestDataXceiverLazyPersistHint.makeStubDataXceiver(PeerLocality.REMOTE, NonLocalLazyPersist.NOT_ALLOWED, (ArgumentCaptor<Boolean>)captor);
        for (Boolean lazyPersistSetting : Arrays.asList(true, false)) {
            this.issueWriteBlockCall(xceiver, lazyPersistSetting);
            MatcherAssert.assertThat((Object)((Boolean)captor.getValue()), (Matcher)Is.is((Object)false));
        }
    }

    @Test
    public void testOverrideWithRemoteClient() throws IOException {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Boolean.class);
        DataXceiver xceiver = TestDataXceiverLazyPersistHint.makeStubDataXceiver(PeerLocality.REMOTE, NonLocalLazyPersist.ALLOWED, (ArgumentCaptor<Boolean>)captor);
        for (Boolean lazyPersistSetting : Arrays.asList(true, false)) {
            this.issueWriteBlockCall(xceiver, lazyPersistSetting);
            MatcherAssert.assertThat((Object)((Boolean)captor.getValue()), (Matcher)Is.is((Object)lazyPersistSetting));
        }
    }

    private void issueWriteBlockCall(DataXceiver xceiver, boolean lazyPersist) throws IOException {
        xceiver.writeBlock(new ExtendedBlock("Dummy-pool", 0L), StorageType.RAM_DISK, null, "Dummy-Client", DatanodeInfo.EMPTY_ARRAY, StorageType.EMPTY_ARRAY, (DatanodeInfo)Mockito.mock(DatanodeInfo.class), BlockConstructionStage.PIPELINE_SETUP_CREATE, 0, 0L, 0L, 0L, DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.NULL, (int)0), CachingStrategy.newDefaultStrategy(), lazyPersist, false, null, null, new String[0]);
    }

    private static DataXceiver makeStubDataXceiver(PeerLocality locality, NonLocalLazyPersist nonLocalLazyPersist, ArgumentCaptor<Boolean> captor) throws IOException {
        BlockReceiver mockBlockReceiver = (BlockReceiver)Mockito.mock(BlockReceiver.class);
        ((BlockReceiver)Mockito.doReturn((Object)Mockito.mock(Replica.class)).when((Object)mockBlockReceiver)).getReplica();
        DataXceiver xceiverSpy = (DataXceiver)Mockito.spy((Object)DataXceiver.create((Peer)TestDataXceiverLazyPersistHint.getMockPeer(locality), (DataNode)TestDataXceiverLazyPersistHint.getMockDn(nonLocalLazyPersist), (DataXceiverServer)((DataXceiverServer)Mockito.mock(DataXceiverServer.class))));
        ((DataXceiver)Mockito.doReturn((Object)mockBlockReceiver).when((Object)xceiverSpy)).getBlockReceiver((ExtendedBlock)ArgumentMatchers.any(), (StorageType)ArgumentMatchers.any(), (DataInputStream)ArgumentMatchers.any(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (BlockConstructionStage)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyString(), (DatanodeInfo)ArgumentMatchers.any(), (DataNode)ArgumentMatchers.any(), (DataChecksum)ArgumentMatchers.any(), (CachingStrategy)ArgumentMatchers.any(), ((Boolean)captor.capture()).booleanValue(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.any());
        ((DataXceiver)Mockito.doReturn((Object)Mockito.mock(DataOutputStream.class)).when((Object)xceiverSpy)).getBufferedOutputStream();
        return xceiverSpy;
    }

    private static Peer getMockPeer(PeerLocality locality) {
        Peer peer = (Peer)Mockito.mock(Peer.class);
        Mockito.when((Object)peer.isLocal()).thenReturn((Object)(locality == PeerLocality.LOCAL ? 1 : 0));
        Mockito.when((Object)peer.getRemoteAddressString()).thenReturn((Object)"1.1.1.1:1000");
        Mockito.when((Object)peer.getLocalAddressString()).thenReturn((Object)"2.2.2.2:2000");
        return peer;
    }

    private static DataNode getMockDn(NonLocalLazyPersist nonLocalLazyPersist) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.datanode.non.local.lazy.persist", nonLocalLazyPersist == NonLocalLazyPersist.ALLOWED);
        DatanodeRegistration mockDnReg = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
        DataNodeMetrics mockMetrics = (DataNodeMetrics)Mockito.mock(DataNodeMetrics.class);
        DataNode mockDn = (DataNode)Mockito.mock(DataNode.class);
        Mockito.when((Object)mockDn.getConf()).thenReturn((Object)conf);
        DNConf dnConf = new DNConf((Configurable)mockDn);
        Mockito.when((Object)mockDn.getDnConf()).thenReturn((Object)dnConf);
        Mockito.when((Object)mockDn.getMetrics()).thenReturn((Object)mockMetrics);
        Mockito.when((Object)mockDn.getDNRegistrationForBP("Dummy-pool")).thenReturn((Object)mockDnReg);
        return mockDn;
    }

    private static enum NonLocalLazyPersist {
        ALLOWED,
        NOT_ALLOWED;

    }

    private static enum PeerLocality {
        LOCAL,
        REMOTE;

    }
}

