/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.AclTransformation;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class TestAclTransformation {
    private static final List<AclEntry> ACL_SPEC_TOO_LARGE = Lists.newArrayListWithCapacity((int)33);
    private static final List<AclEntry> ACL_SPEC_DEFAULT_TOO_LARGE = Lists.newArrayListWithCapacity((int)33);

    @Test
    public void testFilterAclEntriesByAclSpec() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "execs", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales")});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "execs", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec));
    }

    @Test
    public void testFilterAclEntriesByAclSpecUnchanged() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "clark"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "execs")});
        Assert.assertEquals((Object)existing, (Object)AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec));
    }

    @Test
    public void testFilterAclEntriesByAclSpecAccessMaskCalculated() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana")});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec));
    }

    @Test
    public void testFilterAclEntriesByAclSpecDefaultMaskCalculated() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana")});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec));
    }

    @Test
    public void testFilterAclEntriesByAclSpecDefaultMaskPreserved() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana")});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec));
    }

    @Test
    public void testFilterAclEntriesByAclSpecAccessMaskPreserved() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana")});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec));
    }

    @Test
    public void testFilterAclEntriesByAclSpecAutomaticDefaultUser() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec));
    }

    @Test
    public void testFilterAclEntriesByAclSpecAutomaticDefaultGroup() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec));
    }

    @Test
    public void testFilterAclEntriesByAclSpecAutomaticDefaultOther() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec));
    }

    @Test
    public void testFilterAclEntriesByAclSpecEmptyAclSpec() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)).build();
        ArrayList aclSpec = Lists.newArrayList();
        Assert.assertEquals((Object)existing, (Object)AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec));
    }

    @Test(expected=AclException.class)
    public void testFilterAclEntriesByAclSpecRemoveAccessMaskRequired() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK)});
        AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testFilterAclEntriesByAclSpecRemoveDefaultMaskRequired() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK)});
        AclTransformation.filterAclEntriesByAclSpec((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testFilterAclEntriesByAclSpecInputTooLarge() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        AclTransformation.filterAclEntriesByAclSpec((List)existing, ACL_SPEC_TOO_LARGE);
    }

    @Test(expected=AclException.class)
    public void testFilterDefaultAclEntriesByAclSpecInputTooLarge() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        AclTransformation.filterAclEntriesByAclSpec((List)existing, ACL_SPEC_DEFAULT_TOO_LARGE);
    }

    @Test
    public void testFilterDefaultAclEntries() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "sales", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE)).build();
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.filterDefaultAclEntries((List)existing));
    }

    @Test
    public void testFilterDefaultAclEntriesUnchanged() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)existing, (Object)AclTransformation.filterDefaultAclEntries((List)existing));
    }

    @Test
    public void testMergeAclEntries() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesUnchanged() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "sales", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "sales", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)});
        Assert.assertEquals((Object)existing, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesMultipleNewBeforeExisting() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "clark", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_EXECUTE)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "clark", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesAccessMaskCalculated() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesDefaultMaskCalculated() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.READ_EXECUTE)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesDefaultMaskPreserved() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_EXECUTE)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesAccessMaskPreserved() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.READ_EXECUTE)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesAutomaticDefaultUser() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesAutomaticDefaultGroup() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesAutomaticDefaultOther() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesProvidedAccessMask() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesProvidedDefaultMask() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testMergeAclEntriesEmptyAclSpec() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)).build();
        ArrayList aclSpec = Lists.newArrayList();
        Assert.assertEquals((Object)existing, (Object)AclTransformation.mergeAclEntries((List)existing, (List)aclSpec));
    }

    @Test(expected=AclException.class)
    public void testMergeAclEntriesInputTooLarge() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        AclTransformation.mergeAclEntries((List)existing, ACL_SPEC_TOO_LARGE);
    }

    @Test(expected=AclException.class)
    public void testMergeAclDefaultEntriesInputTooLarge() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        AclTransformation.mergeAclEntries((List)existing, ACL_SPEC_DEFAULT_TOO_LARGE);
    }

    @Test(expected=AclException.class)
    public void testMergeAclEntriesResultTooLarge() throws AclException {
        ImmutableList.Builder aclBuilder = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL));
        for (int i = 1; i <= 28; ++i) {
            aclBuilder.add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "user" + i, FsAction.READ));
        }
        aclBuilder.add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        ImmutableList existing = aclBuilder.build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)});
        AclTransformation.mergeAclEntries((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testMergeAclDefaultEntriesResultTooLarge() throws AclException {
        ImmutableList.Builder aclBuilder = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL));
        for (int i = 1; i <= 28; ++i) {
            aclBuilder.add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "user" + i, FsAction.READ));
        }
        aclBuilder.add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE));
        ImmutableList existing = aclBuilder.build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)});
        AclTransformation.mergeAclEntries((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testMergeAclEntriesDuplicateEntries() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "clark", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE)});
        AclTransformation.mergeAclEntries((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testMergeAclEntriesNamedMask() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, "bruce", FsAction.READ_EXECUTE)});
        AclTransformation.mergeAclEntries((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testMergeAclEntriesNamedOther() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, "bruce", FsAction.READ_EXECUTE)});
        AclTransformation.mergeAclEntries((List)existing, (List)aclSpec);
    }

    @Test
    public void testReplaceAclEntries() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "sales", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "sales", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.replaceAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testReplaceAclEntriesUnchanged() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "sales", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "sales", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)});
        Assert.assertEquals((Object)existing, (Object)AclTransformation.replaceAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testReplaceAclEntriesAccessMaskCalculated() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.replaceAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testReplaceAclEntriesDefaultMaskCalculated() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.replaceAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testReplaceAclEntriesDefaultMaskPreserved() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.replaceAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testReplaceAclEntriesAccessMaskPreserved() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.replaceAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testReplaceAclEntriesAutomaticDefaultUser() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.replaceAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testReplaceAclEntriesAutomaticDefaultGroup() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.replaceAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testReplaceAclEntriesAutomaticDefaultOther() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_WRITE)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_WRITE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.replaceAclEntries((List)existing, (List)aclSpec));
    }

    @Test
    public void testReplaceAclEntriesOnlyDefaults() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)});
        ImmutableList expected = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        Assert.assertEquals((Object)expected, (Object)AclTransformation.replaceAclEntries((List)existing, (List)aclSpec));
    }

    @Test(expected=AclException.class)
    public void testReplaceAclEntriesInputTooLarge() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        AclTransformation.replaceAclEntries((List)existing, ACL_SPEC_TOO_LARGE);
    }

    @Test(expected=AclException.class)
    public void testReplaceAclDefaultEntriesInputTooLarge() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)).build();
        AclTransformation.replaceAclEntries((List)existing, ACL_SPEC_DEFAULT_TOO_LARGE);
    }

    @Test(expected=AclException.class)
    public void testReplaceAclEntriesResultTooLarge() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayListWithCapacity((int)32);
        aclSpec.add(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL));
        for (int i = 1; i <= 29; ++i) {
            aclSpec.add(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "user" + i, FsAction.READ));
        }
        aclSpec.add(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ));
        aclSpec.add(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        AclTransformation.replaceAclEntries((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testReplaceAclEntriesDuplicateEntries() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "clark", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        AclTransformation.replaceAclEntries((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testReplaceAclEntriesNamedMask() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, "bruce", FsAction.READ_EXECUTE)});
        AclTransformation.replaceAclEntries((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testReplaceAclEntriesNamedOther() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, "bruce", FsAction.READ_EXECUTE)});
        AclTransformation.replaceAclEntries((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testReplaceAclEntriesMissingUser() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        AclTransformation.replaceAclEntries((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testReplaceAclEntriesMissingGroup() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        AclTransformation.replaceAclEntries((List)existing, (List)aclSpec);
    }

    @Test(expected=AclException.class)
    public void testReplaceAclEntriesMissingOther() throws AclException {
        ImmutableList existing = new ImmutableList.Builder().add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)).add((Object)AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)).build();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL)});
        AclTransformation.replaceAclEntries((List)existing, (List)aclSpec);
    }

    static {
        for (int i = 0; i < 33; ++i) {
            ACL_SPEC_TOO_LARGE.add(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "user" + i, FsAction.ALL));
            ACL_SPEC_DEFAULT_TOO_LARGE.add(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "user" + i, FsAction.ALL));
        }
    }
}

