/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer;

import java.util.Collections;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerTestUtil;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolumeSet;
import org.junit.Assert;
import org.junit.Test;

public class TestDataModels {
    @Test
    public void testCreateRandomVolume() throws Exception {
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerVolume vol = util.createRandomVolume(StorageType.DISK);
        Assert.assertNotNull((Object)vol.getUuid());
        Assert.assertNotNull((Object)vol.getPath());
        Assert.assertNotNull((Object)vol.getStorageType());
        Assert.assertFalse((boolean)vol.isFailed());
        Assert.assertFalse((boolean)vol.isTransient());
        Assert.assertTrue((vol.getCapacity() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((vol.getCapacity() - vol.getReserved() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((vol.getReserved() + vol.getUsed() < vol.getCapacity() ? 1 : 0) != 0);
    }

    @Test
    public void testCreateRandomVolumeSet() throws Exception {
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerVolumeSet vSet = util.createRandomVolumeSet(StorageType.SSD, 10);
        Assert.assertEquals((long)10L, (long)vSet.getVolumeCount());
        Assert.assertEquals((Object)StorageType.SSD.toString(), (Object)((DiskBalancerVolume)vSet.getVolumes().get(0)).getStorageType());
    }

    @Test
    public void testCreateRandomDataNode() throws Exception {
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerDataNode node = util.createRandomDataNode(new StorageType[]{StorageType.DISK, StorageType.RAM_DISK}, 10);
        Assert.assertNotNull((Object)node.getNodeDataDensity());
    }

    @Test
    public void testDiskQueues() throws Exception {
        int x;
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerDataNode node = util.createRandomDataNode(new StorageType[]{StorageType.DISK, StorageType.RAM_DISK}, 3);
        TreeSet sortedQueue = ((DiskBalancerVolumeSet)node.getVolumeSets().get(StorageType.DISK.toString())).getSortedQueue();
        LinkedList<DiskBalancerVolume> reverseList = new LinkedList<DiskBalancerVolume>();
        LinkedList<DiskBalancerVolume> highList = new LinkedList<DiskBalancerVolume>();
        int queueSize = sortedQueue.size();
        for (x = 0; x < queueSize; ++x) {
            reverseList.add((DiskBalancerVolume)sortedQueue.first());
            highList.add((DiskBalancerVolume)sortedQueue.first());
        }
        Collections.reverse(reverseList);
        for (x = 0; x < queueSize; ++x) {
            Assert.assertEquals((long)((DiskBalancerVolume)reverseList.get(x)).getCapacity(), (long)((DiskBalancerVolume)highList.get(x)).getCapacity());
            Assert.assertEquals((long)((DiskBalancerVolume)reverseList.get(x)).getReserved(), (long)((DiskBalancerVolume)highList.get(x)).getReserved());
            Assert.assertEquals((long)((DiskBalancerVolume)reverseList.get(x)).getUsed(), (long)((DiskBalancerVolume)highList.get(x)).getUsed());
        }
    }

    @Test
    public void testNoBalancingNeededEvenDataSpread() throws Exception {
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume v1 = util.createRandomVolume(StorageType.SSD);
        v1.setCapacity(0x10000000000L);
        v1.setReserved(0x1900000000L);
        v1.setUsed(0x7D00000000L);
        DiskBalancerVolume v2 = util.createRandomVolume(StorageType.SSD);
        v2.setCapacity(0x10000000000L);
        v2.setReserved(0x1900000000L);
        v2.setUsed(0x7D00000000L);
        node.addVolume(v1);
        node.addVolume(v2);
        for (DiskBalancerVolumeSet vsets : node.getVolumeSets().values()) {
            Assert.assertFalse((boolean)vsets.isBalancingNeeded(10.0));
        }
    }

    @Test
    public void testNoBalancingNeededTransientDisks() throws Exception {
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume v1 = util.createRandomVolume(StorageType.RAM_DISK);
        v1.setCapacity(0x10000000000L);
        v1.setReserved(0x1900000000L);
        v1.setUsed(0x40000000L);
        DiskBalancerVolume v2 = util.createRandomVolume(StorageType.RAM_DISK);
        v2.setCapacity(0x10000000000L);
        v2.setReserved(0x1900000000L);
        v2.setUsed(0x7D00000000L);
        node.addVolume(v1);
        node.addVolume(v2);
        for (DiskBalancerVolumeSet vsets : node.getVolumeSets().values()) {
            Assert.assertFalse((boolean)vsets.isBalancingNeeded(10.0));
        }
    }

    @Test
    public void testNoBalancingNeededFailedDisks() throws Exception {
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume v1 = util.createRandomVolume(StorageType.SSD);
        v1.setCapacity(0x10000000000L);
        v1.setReserved(0x1900000000L);
        v1.setUsed(0x40000000L);
        v1.setFailed(true);
        DiskBalancerVolume v2 = util.createRandomVolume(StorageType.SSD);
        v2.setCapacity(0x10000000000L);
        v2.setReserved(0x1900000000L);
        v2.setUsed(0x7D00000000L);
        node.addVolume(v1);
        node.addVolume(v2);
        for (DiskBalancerVolumeSet vsets : node.getVolumeSets().values()) {
            Assert.assertFalse((boolean)vsets.isBalancingNeeded(10.0));
        }
    }

    @Test
    public void testNeedBalancingUnevenDataSpread() throws Exception {
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerDataNode node = new DiskBalancerDataNode(UUID.randomUUID().toString());
        DiskBalancerVolume v1 = util.createRandomVolume(StorageType.SSD);
        v1.setCapacity(0x10000000000L);
        v1.setReserved(0x1900000000L);
        v1.setUsed(0L);
        DiskBalancerVolume v2 = util.createRandomVolume(StorageType.SSD);
        v2.setCapacity(0x10000000000L);
        v2.setReserved(0x1900000000L);
        v2.setUsed(0x7D00000000L);
        node.addVolume(v1);
        node.addVolume(v2);
        for (DiskBalancerVolumeSet vsets : node.getVolumeSets().values()) {
            Assert.assertTrue((boolean)vsets.isBalancingNeeded(10.0));
        }
    }

    @Test
    public void testVolumeSerialize() throws Exception {
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerVolume volume = util.createRandomVolume(StorageType.DISK);
        String originalString = volume.toJson();
        DiskBalancerVolume parsedVolume = DiskBalancerVolume.parseJson((String)originalString);
        String parsedString = parsedVolume.toJson();
        Assert.assertEquals((Object)originalString, (Object)parsedString);
    }

    @Test
    public void testClusterSerialize() throws Exception {
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerCluster cluster = util.createRandCluster(3, new StorageType[]{StorageType.DISK, StorageType.RAM_DISK, StorageType.SSD}, 3);
        DiskBalancerCluster newCluster = DiskBalancerCluster.parseJson((String)cluster.toJson());
        Assert.assertEquals((Object)cluster.getNodes(), (Object)newCluster.getNodes());
        Assert.assertEquals((long)cluster.getNodes().size(), (long)newCluster.getNodes().size());
    }

    @Test
    public void testUsageLimitedToCapacity() throws Exception {
        DiskBalancerTestUtil util = new DiskBalancerTestUtil();
        DiskBalancerVolume v1 = util.createRandomVolume(StorageType.DISK);
        v1.setCapacity(0x40000000L);
        v1.setUsed(0x80000000L);
        Assert.assertEquals((long)v1.getUsed(), (long)v1.getCapacity());
        DiskBalancerVolume v2 = util.createRandomVolume(StorageType.DISK);
        v2.setCapacity(0x80000000L);
        v2.setUsed(0x40000000L);
        Assert.assertEquals((long)v1.getUsed(), (long)0x40000000L);
    }
}

