/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerSafeMode;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.junit.Assert;

public class BlockManagerTestUtil {
    static final long SLEEP_TIME = 1000L;

    public static void setNodeReplicationLimit(BlockManager blockManager, int limit) {
        blockManager.maxReplicationStreams = limit;
    }

    public static DatanodeDescriptor getDatanode(FSNamesystem ns, String storageID) {
        ns.readLock();
        try {
            DatanodeDescriptor datanodeDescriptor = ns.getBlockManager().getDatanodeManager().getDatanode(storageID);
            return datanodeDescriptor;
        }
        finally {
            ns.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<BlockInfo> getBlockIterator(FSNamesystem ns, String storageID, int startBlock) {
        ns.readLock();
        try {
            DatanodeDescriptor dn = ns.getBlockManager().getDatanodeManager().getDatanode(storageID);
            Iterator iterator = dn.getBlockIterator(startBlock);
            return iterator;
        }
        finally {
            ns.readUnlock();
        }
    }

    public static Iterator<BlockInfo> getBlockIterator(DatanodeStorageInfo s) {
        return s.getBlockIterator();
    }

    public static void updateState(BlockManager blockManager) {
        blockManager.updateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getReplicaInfo(FSNamesystem namesystem, Block b) {
        BlockManager bm = namesystem.getBlockManager();
        namesystem.readLock();
        try {
            BlockInfo storedBlock = bm.getStoredBlock(b);
            int[] nArray = new int[]{BlockManagerTestUtil.getNumberOfRacks(bm, b), bm.countNodes(storedBlock).liveReplicas(), bm.neededReconstruction.contains(storedBlock) ? 1 : 0, BlockManagerTestUtil.getNumberOfDomains(bm, b)};
            return nArray;
        }
        finally {
            namesystem.readUnlock();
        }
    }

    private static int getNumberOfRacks(BlockManager blockManager, Block b) {
        HashSet<String> rackSet = new HashSet<String>(0);
        Collection corruptNodes = BlockManagerTestUtil.getCorruptReplicas(blockManager).getNodes(b);
        for (DatanodeStorageInfo storage : blockManager.blocksMap.getStorages(b)) {
            String rackName;
            DatanodeDescriptor cur = storage.getDatanodeDescriptor();
            if (cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur) || rackSet.contains(rackName = cur.getNetworkLocation())) continue;
            rackSet.add(rackName);
        }
        return rackSet.size();
    }

    private static int getNumberOfDomains(BlockManager blockManager, Block b) {
        HashSet<String> domSet = new HashSet<String>(0);
        Collection corruptNodes = BlockManagerTestUtil.getCorruptReplicas(blockManager).getNodes(b);
        for (DatanodeStorageInfo storage : blockManager.blocksMap.getStorages(b)) {
            String domain;
            DatanodeDescriptor cur = storage.getDatanodeDescriptor();
            if (cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur) || (domain = cur.getUpgradeDomain()) == null || domSet.contains(domain)) continue;
            domSet.add(domain);
        }
        return domSet.size();
    }

    public static void stopRedundancyThread(BlockManager blockManager) throws IOException {
        blockManager.enableRMTerminationForTesting();
        blockManager.getRedundancyThread().interrupt();
        try {
            blockManager.getRedundancyThread().join();
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted while trying to stop RedundancyMonitor");
        }
    }

    public static void wakeupPendingReconstructionTimerThread(BlockManager blockManager) {
        blockManager.pendingReconstruction.getTimerThread().interrupt();
    }

    public static HeartbeatManager getHeartbeatManager(BlockManager blockManager) {
        return blockManager.getDatanodeManager().getHeartbeatManager();
    }

    public static CorruptReplicasMap getCorruptReplicas(BlockManager blockManager) {
        return blockManager.corruptReplicas;
    }

    public static void waitForMarkedDeleteQueueIsEmpty(BlockManager blockManager) throws InterruptedException {
        while (!blockManager.getMarkedDeleteQueue().isEmpty()) {
            Thread.sleep(1000L);
        }
        return;
    }

    public static int getComputedDatanodeWork(BlockManager blockManager) throws IOException {
        return blockManager.computeDatanodeWork();
    }

    public static int computeInvalidationWork(BlockManager bm) {
        return bm.computeInvalidateWork(Integer.MAX_VALUE);
    }

    public static void checkRedundancy(BlockManager blockManager) {
        blockManager.computeDatanodeWork();
        blockManager.processPendingReconstructions();
        blockManager.rescanPostponedMisreplicatedBlocks();
    }

    public static int computeAllPendingWork(BlockManager bm) {
        int work = BlockManagerTestUtil.computeInvalidationWork(bm);
        return work += bm.computeBlockReconstructionWork(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noticeDeadDatanode(NameNode nn, String dnName) {
        FSNamesystem namesystem = nn.getNamesystem();
        namesystem.writeLock();
        try {
            DatanodeManager dnm = namesystem.getBlockManager().getDatanodeManager();
            HeartbeatManager hbm = dnm.getHeartbeatManager();
            HeartbeatManager dnds = hbm.getDatanodes();
            DatanodeDescriptor theDND = null;
            for (DatanodeDescriptor dnd : dnds) {
                if (!dnd.getXferAddr().equals(dnName)) continue;
                theDND = dnd;
            }
            Assert.assertNotNull((String)("Could not find DN with name: " + dnName), theDND);
            HeartbeatManager heartbeatManager = hbm;
            synchronized (heartbeatManager) {
                DFSTestUtil.setDatanodeDead((DatanodeInfo)theDND);
                hbm.heartbeatCheck();
            }
        }
        finally {
            namesystem.writeUnlock();
        }
    }

    public static void setWritingPrefersLocalNode(BlockManager bm, boolean prefer) {
        BlockPlacementPolicy bpp = bm.getBlockPlacementPolicy();
        Preconditions.checkState((boolean)(bpp instanceof BlockPlacementPolicyDefault), (String)"Must use default policy, got %s", bpp.getClass());
        ((BlockPlacementPolicyDefault)bpp).setPreferLocalNode(prefer);
    }

    public static void checkHeartbeat(BlockManager bm) {
        HeartbeatManager hbm = bm.getDatanodeManager().getHeartbeatManager();
        hbm.restartHeartbeatStopWatch();
        hbm.heartbeatCheck();
    }

    public static int checkHeartbeatAndGetUnderReplicatedBlocksCount(FSNamesystem namesystem, BlockManager bm) {
        namesystem.writeLock();
        try {
            bm.getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            int n = bm.getUnderReplicatedNotMissingBlocks();
            return n;
        }
        finally {
            namesystem.writeUnlock();
        }
    }

    public static DatanodeStorageInfo updateStorage(DatanodeDescriptor dn, DatanodeStorage s) {
        return dn.updateStorage(s);
    }

    public static void rescanPostponedMisreplicatedBlocks(BlockManager bm) {
        bm.rescanPostponedMisreplicatedBlocks();
    }

    public static DatanodeDescriptor getLocalDatanodeDescriptor(boolean initializeStorage) {
        DatanodeDescriptor dn = new DatanodeDescriptor(DFSTestUtil.getLocalDatanodeID());
        if (initializeStorage) {
            dn.updateStorage(new DatanodeStorage(DatanodeStorage.generateUuid()));
        }
        return dn;
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation, boolean initializeStorage) {
        return BlockManagerTestUtil.getDatanodeDescriptor(ipAddr, rackLocation, initializeStorage ? new DatanodeStorage(DatanodeStorage.generateUuid()) : null);
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation, DatanodeStorage storage) {
        return BlockManagerTestUtil.getDatanodeDescriptor(ipAddr, rackLocation, storage, "host");
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation, DatanodeStorage storage, String hostname) {
        DatanodeDescriptor dn = DFSTestUtil.getDatanodeDescriptor(ipAddr, 9866, rackLocation, hostname);
        if (storage != null) {
            dn.updateStorage(storage);
        }
        return dn;
    }

    public static DatanodeStorageInfo newDatanodeStorageInfo(DatanodeDescriptor dn, DatanodeStorage s) {
        return new DatanodeStorageInfo(dn, s);
    }

    public static StorageReport[] getStorageReportsForDatanode(DatanodeDescriptor dnd) {
        ArrayList<StorageReport> reports = new ArrayList<StorageReport>();
        for (DatanodeStorageInfo storage : dnd.getStorageInfos()) {
            DatanodeStorage dns = new DatanodeStorage(storage.getStorageID(), storage.getState(), storage.getStorageType());
            StorageReport report = new StorageReport(dns, false, storage.getCapacity(), storage.getDfsUsed(), storage.getRemaining(), storage.getBlockPoolUsed(), 0L);
            reports.add(report);
        }
        return reports.toArray(StorageReport.EMPTY_ARRAY);
    }

    public static void recheckDecommissionState(DatanodeManager dm) throws ExecutionException, InterruptedException {
        dm.getDatanodeAdminManager().runMonitorForTest();
    }

    public static boolean isNodeHealthyForDecommissionOrMaintenance(BlockManager blockManager, DatanodeDescriptor dn) {
        return blockManager.isNodeHealthyForDecommissionOrMaintenance(dn);
    }

    public static void addBlockToBeReplicated(DatanodeDescriptor node, Block block, DatanodeStorageInfo[] targets) {
        node.addBlockToBeReplicated(block, targets);
    }

    public static void setStartupSafeModeForTest(BlockManager bm) {
        BlockManagerSafeMode bmSafeMode = (BlockManagerSafeMode)Whitebox.getInternalState((Object)bm, (String)"bmSafeMode");
        Whitebox.setInternalState((Object)bmSafeMode, (String)"extension", (Object)Integer.MAX_VALUE);
        Whitebox.setInternalState((Object)bmSafeMode, (String)"status", (Object)BlockManagerSafeMode.BMSafeModeStatus.EXTENSION);
    }

    public static boolean isDatanodeRemoved(NameNode nn, String dnUuid) {
        DatanodeManager dnm = nn.getNamesystem().getBlockManager().getDatanodeManager();
        return !dnm.getNetworkTopology().contains((Node)dnm.getDatanode(dnUuid));
    }

    public static void removeStorage(BlockInfo block, DatanodeStorageInfo storage) {
        block.removeStorage(storage);
    }

    public static void addStorage(BlockInfo block, DatanodeStorageInfo storage, Block reportedBlock) {
        block.addStorage(storage, reportedBlock);
    }
}

