/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.hdfs.server.balancer.BalancerParameters;
import org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import org.apache.hadoop.hdfs.server.balancer.ExitStatus;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(TestBalancer.class);
    static final long CAPACITY = 5000L;
    static final String RACK0 = "/rack0";
    static final String RACK1 = "/rack1";
    static final String RACK2 = "/rack2";
    private static final String fileName = "/tmp.txt";
    static final Path filePath;
    private static final String username = "balancer";
    private static String principal;
    private static File baseDir;
    private static String keystoresDir;
    private static String sslConfDir;
    private static MiniKdc kdc;
    private static File keytabFile;
    private MiniDFSCluster cluster;
    private AtomicInteger numGetBlocksCalls;
    private AtomicLong startGetBlocksTime;
    private AtomicLong endGetBlocksTime;
    ClientProtocol client;
    static final long TIMEOUT = 40000L;
    static final double CAPACITY_ALLOWED_VARIANCE = 0.005;
    static final double BALANCE_ALLOWED_VARIANCE = 0.11;
    static final int DEFAULT_BLOCK_SIZE = 100;
    private static final Random r;
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final int dataBlocks = this.ecPolicy.getNumDataUnits();
    private final int parityBlocks = this.ecPolicy.getNumParityUnits();
    private final int groupSize = this.dataBlocks + this.parityBlocks;
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int stripesPerBlock = 4;
    private final int defaultBlockSize = this.cellSize * 4;

    @Before
    public void setup() {
        this.numGetBlocksCalls = new AtomicInteger(0);
        this.startGetBlocksTime = new AtomicLong(Long.MAX_VALUE);
        this.endGetBlocksTime = new AtomicLong(Long.MIN_VALUE);
    }

    @After
    public void shutdown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    public static void initTestSetup() {
        NameNodeConnector.setWrite2IdFile((boolean)false);
    }

    static void initConf(Configuration conf) {
        conf.setLong("dfs.blocksize", 100L);
        conf.setInt("dfs.bytes-per-checksum", 100);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.namenode.redundancy.interval.seconds", 1L);
        SimulatedFSDataset.setFactory(conf);
        conf.setLong("dfs.balancer.movedWinWidth", 2000L);
        conf.setLong("dfs.balancer.getBlocks.min-block-size", 1L);
        conf.setInt("dfs.balancer.max-no-move-interval", 5000);
    }

    void initConfWithStripe(Configuration conf) {
        conf.setLong("dfs.blocksize", (long)this.defaultBlockSize);
        conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        conf.setLong("dfs.heartbeat.interval", 1L);
        SimulatedFSDataset.setFactory(conf);
        conf.setLong("dfs.namenode.redundancy.interval.seconds", 1L);
        conf.setLong("dfs.balancer.movedWinWidth", 2000L);
        conf.setLong("dfs.balancer.getBlocks.min-block-size", 1L);
    }

    static void initSecureConf(Configuration conf) throws Exception {
        baseDir = GenericTestUtils.getTestDir((String)TestBalancer.class.getSimpleName());
        FileUtil.fullyDelete((File)baseDir);
        Assert.assertTrue((boolean)baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        kdc = new MiniKdc(kdcConf, baseDir);
        kdc.start();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        KerberosName.resetDefaultRealm();
        Assert.assertTrue((String)"Expected configuration to enable security", (boolean)UserGroupInformation.isSecurityEnabled());
        keytabFile = new File(baseDir, "balancer.keytab");
        String keytab = keytabFile.getAbsolutePath();
        String krbInstance = Path.WINDOWS ? "127.0.0.1" : "localhost";
        principal = "balancer/" + krbInstance + "@" + kdc.getRealm();
        String spnegoPrincipal = "HTTP/" + krbInstance + "@" + kdc.getRealm();
        kdc.createPrincipal(keytabFile, new String[]{username, "balancer/" + krbInstance, "HTTP/" + krbInstance});
        conf.set("dfs.namenode.kerberos.principal", principal);
        conf.set("dfs.namenode.keytab.file", keytab);
        conf.set("dfs.datanode.kerberos.principal", principal);
        conf.set("dfs.datanode.keytab.file", keytab);
        conf.set("dfs.web.authentication.kerberos.principal", spnegoPrincipal);
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.data.transfer.protection", "authentication");
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        conf.setInt("ipc.client.connect.max.retries.on.sasl", 10);
        conf.setBoolean("dfs.balancer.keytab.enabled", true);
        conf.set("dfs.balancer.address", "localhost:0");
        conf.set("dfs.balancer.keytab.file", keytab);
        conf.set("dfs.balancer.kerberos.principal", principal);
        keystoresDir = baseDir.getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestBalancer.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        conf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
        TestBalancer.initConf(conf);
    }

    @AfterClass
    public static void destroy() throws Exception {
        if (kdc != null) {
            kdc.stop();
            FileUtil.fullyDelete((File)baseDir);
            KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
        }
    }

    public static void createFile(MiniDFSCluster cluster, Path filePath, long fileLen, short replicationFactor, int nnIndex) throws IOException, InterruptedException, TimeoutException {
        DistributedFileSystem fs = cluster.getFileSystem(nnIndex);
        DFSTestUtil.createFile((FileSystem)fs, filePath, fileLen, replicationFactor, r.nextLong());
        DFSTestUtil.waitReplication((FileSystem)fs, filePath, replicationFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedBlock[] generateBlocks(Configuration conf, long size, short numNodes) throws IOException, InterruptedException, TimeoutException {
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numNodes).build();
        try {
            this.cluster.waitActive();
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            short replicationFactor = (short)(numNodes - 1);
            long fileLen = size / (long)replicationFactor;
            TestBalancer.createFile(this.cluster, filePath, fileLen, replicationFactor, 0);
            List locatedBlocks = this.client.getBlockLocations(fileName, 0L, fileLen).getLocatedBlocks();
            int numOfBlocks = locatedBlocks.size();
            ExtendedBlock[] blocks = new ExtendedBlock[numOfBlocks];
            for (int i = 0; i < numOfBlocks; ++i) {
                ExtendedBlock b = ((LocatedBlock)locatedBlocks.get(i)).getBlock();
                blocks[i] = new ExtendedBlock(b.getBlockPoolId(), b.getBlockId(), b.getNumBytes(), b.getGenerationStamp());
            }
            ExtendedBlock[] extendedBlockArray = blocks;
            return extendedBlockArray;
        }
        finally {
            this.cluster.shutdown();
        }
    }

    static Block[][] distributeBlocks(ExtendedBlock[] blocks, short replicationFactor, long[] distribution) {
        int i;
        long[] usedSpace = new long[distribution.length];
        System.arraycopy(distribution, 0, usedSpace, 0, distribution.length);
        ArrayList blockReports = new ArrayList(usedSpace.length);
        Block[][] results = new Block[usedSpace.length][];
        for (i = 0; i < usedSpace.length; ++i) {
            blockReports.add(new ArrayList());
        }
        for (i = 0; i < blocks.length; ++i) {
            for (int j = 0; j < replicationFactor; ++j) {
                boolean notChosen = true;
                while (notChosen) {
                    int chosenIndex = r.nextInt(usedSpace.length);
                    if (usedSpace[chosenIndex] <= 0L) continue;
                    notChosen = false;
                    ((List)blockReports.get(chosenIndex)).add(blocks[i].getLocalBlock());
                    int n = chosenIndex;
                    usedSpace[n] = usedSpace[n] - blocks[i].getNumBytes();
                }
            }
        }
        for (i = 0; i < usedSpace.length; ++i) {
            List nodeBlockList = (List)blockReports.get(i);
            results[i] = nodeBlockList.toArray(new Block[nodeBlockList.size()]);
        }
        return results;
    }

    static long sum(long[] x) {
        long s = 0L;
        for (long a : x) {
            s += a;
        }
        return s;
    }

    private void testUnevenDistribution(Configuration conf, long[] distribution, long[] capacities, String[] racks) throws Exception {
        int numDatanodes = distribution.length;
        if (capacities.length != numDatanodes || racks.length != numDatanodes) {
            throw new IllegalArgumentException("Array length is not the same");
        }
        long totalUsedSpace = TestBalancer.sum(distribution);
        ExtendedBlock[] blocks = this.generateBlocks(conf, totalUsedSpace, (short)numDatanodes);
        Block[][] blocksDN = TestBalancer.distributeBlocks(blocks, (short)(numDatanodes - 1), distribution);
        conf.set("dfs.namenode.safemode.threshold-pct", "0.0f");
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDatanodes).format(false).racks(racks).simulatedCapacities(capacities).build();
        this.cluster.waitActive();
        this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
        for (int i = 0; i < blocksDN.length; ++i) {
            this.cluster.injectBlocks(i, Arrays.asList(blocksDN[i]), null);
        }
        long totalCapacity = TestBalancer.sum(capacities);
        this.runBalancer(conf, totalUsedSpace, totalCapacity);
        this.cluster.shutdown();
    }

    static void waitForHeartBeat(long expectedUsedSpace, long expectedTotalSpace, ClientProtocol client, MiniDFSCluster cluster) throws IOException, TimeoutException {
        long timeout = 40000L;
        long failtime = timeout <= 0L ? Long.MAX_VALUE : Time.monotonicNow() + timeout;
        while (true) {
            long[] status = client.getStats();
            double totalSpaceVariance = Math.abs((double)status[0] - (double)expectedTotalSpace) / (double)expectedTotalSpace;
            double usedSpaceVariance = Math.abs((double)status[1] - (double)expectedUsedSpace) / (double)expectedUsedSpace;
            if (totalSpaceVariance < 0.005 && usedSpaceVariance < 0.005) break;
            if (Time.monotonicNow() > failtime) {
                throw new TimeoutException("Cluster failed to reached expected values of totalSpace (current: " + status[0] + ", expected: " + expectedTotalSpace + "), or usedSpace (current: " + status[1] + ", expected: " + expectedUsedSpace + "), in more than " + timeout + " msec.");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static void waitForBalancer(long totalUsedSpace, long totalCapacity, ClientProtocol client, MiniDFSCluster cluster, BalancerParameters p) throws IOException, TimeoutException {
        TestBalancer.waitForBalancer(totalUsedSpace, totalCapacity, client, cluster, p, 0);
    }

    static void waitForBalancer(long totalUsedSpace, long totalCapacity, ClientProtocol client, MiniDFSCluster cluster, BalancerParameters p, int expectedExcludedNodes) throws IOException, TimeoutException {
        TestBalancer.waitForBalancer(totalUsedSpace, totalCapacity, client, cluster, p, expectedExcludedNodes, true);
    }

    static void waitForBalancer(long totalUsedSpace, long totalCapacity, ClientProtocol client, MiniDFSCluster cluster, BalancerParameters p, int expectedExcludedNodes, boolean checkExcludeNodesUtilization) throws IOException, TimeoutException {
        boolean balanced;
        long failtime;
        long timeout = 40000L;
        long l = failtime = timeout <= 0L ? Long.MAX_VALUE : Time.monotonicNow() + timeout;
        if (!p.getIncludedNodes().isEmpty()) {
            totalCapacity = (long)p.getIncludedNodes().size() * 5000L;
        }
        if (!p.getExcludedNodes().isEmpty()) {
            totalCapacity -= (long)p.getExcludedNodes().size() * 5000L;
        }
        double avgUtilization = (double)totalUsedSpace / (double)totalCapacity;
        do {
            DatanodeInfo[] datanodeReport = client.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
            Assert.assertEquals((long)datanodeReport.length, (long)cluster.getDataNodes().size());
            balanced = true;
            int actualExcludedNodeCount = 0;
            for (DatanodeInfo datanode : datanodeReport) {
                double nodeUtilization = (double)datanode.getDfsUsed() / (double)datanode.getCapacity();
                if (Dispatcher.Util.isExcluded((Set)p.getExcludedNodes(), (DatanodeInfo)datanode)) {
                    if (checkExcludeNodesUtilization) {
                        Assert.assertTrue((nodeUtilization == 0.0 ? 1 : 0) != 0);
                    }
                    ++actualExcludedNodeCount;
                    continue;
                }
                if (!Dispatcher.Util.isIncluded((Set)p.getIncludedNodes(), (DatanodeInfo)datanode)) {
                    Assert.assertTrue((nodeUtilization == 0.0 ? 1 : 0) != 0);
                    ++actualExcludedNodeCount;
                    continue;
                }
                if (!(Math.abs(avgUtilization - nodeUtilization) > 0.11)) continue;
                balanced = false;
                if (Time.monotonicNow() > failtime) {
                    throw new TimeoutException("Rebalancing expected avg utilization to become " + avgUtilization + ", but on datanode " + datanode + " it remains at " + nodeUtilization + " after more than " + 40000L + " msec.");
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            Assert.assertEquals((long)expectedExcludedNodes, (long)actualExcludedNodeCount);
        } while (!balanced);
    }

    String long2String(long[] array) {
        if (array.length == 0) {
            return "<empty>";
        }
        StringBuilder b = new StringBuilder("[").append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            b.append(", ").append(array[i]);
        }
        return b.append("]").toString();
    }

    private void doTest(Configuration conf, long[] capacities, String[] racks, long newCapacity, String newRack, boolean useTool) throws Exception {
        this.doTest(conf, capacities, racks, newCapacity, newRack, null, useTool, false);
    }

    private void doTest(Configuration conf, long[] capacities, String[] racks, long newCapacity, String newRack, NewNodeInfo nodes, boolean useTool, boolean useFile) throws Exception {
        this.doTest(conf, capacities, racks, newCapacity, newRack, nodes, useTool, useFile, false, 0.3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(Configuration conf, long[] capacities, String[] racks, long newCapacity, String newRack, NewNodeInfo nodes, boolean useTool, boolean useFile, boolean useNamesystemSpy, double clusterUtilization) throws Exception {
        LOG.info("capacities = " + this.long2String(capacities));
        LOG.info("racks      = " + Arrays.asList(racks));
        LOG.info("newCapacity= " + newCapacity);
        LOG.info("newRack    = " + newRack);
        LOG.info("useTool    = " + useTool);
        Assert.assertEquals((long)capacities.length, (long)racks.length);
        int numOfDatanodes = capacities.length;
        try {
            this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            this.cluster.getConfiguration(0).setInt("dfs.replication", 3);
            conf.setInt("dfs.replication", 3);
            if (useNamesystemSpy) {
                LOG.info("Using Spy Namesystem");
                this.spyFSNamesystem(this.cluster.getNameNode());
            }
            this.cluster.startDataNodes(conf, numOfDatanodes, true, HdfsServerConstants.StartupOption.REGULAR, racks, null, capacities, false);
            this.cluster.waitClusterUp();
            this.cluster.waitActive();
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            long totalCapacity = TestBalancer.sum(capacities);
            long totalUsedSpace = (long)((double)totalCapacity * clusterUtilization);
            TestBalancer.createFile(this.cluster, filePath, totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes, 0);
            if (nodes == null) {
                this.cluster.startDataNodes(conf, 1, true, null, new String[]{newRack}, null, new long[]{newCapacity});
                totalCapacity += newCapacity;
                this.cluster.triggerHeartbeats();
            } else {
                if (nodes.getNumberofIncludeNodes() > 0) {
                    for (DataNode dn : this.cluster.getDataNodes()) {
                        nodes.getNodesToBeIncluded().add(dn.getDatanodeId().getHostName());
                    }
                }
                String[] newRacks = new String[nodes.getNumberofNewNodes()];
                long[] newCapacities = new long[nodes.getNumberofNewNodes()];
                for (int i = 0; i < nodes.getNumberofNewNodes(); ++i) {
                    newRacks[i] = newRack;
                    newCapacities[i] = newCapacity;
                }
                if (nodes.getNames() != null) {
                    this.cluster.startDataNodes(conf, nodes.getNumberofNewNodes(), true, null, newRacks, nodes.getNames(), newCapacities);
                    this.cluster.triggerHeartbeats();
                    totalCapacity += newCapacity * (long)nodes.getNumberofNewNodes();
                } else {
                    int i;
                    int totalNodes;
                    this.cluster.startDataNodes(conf, nodes.getNumberofNewNodes(), true, null, newRacks, null, newCapacities);
                    this.cluster.triggerHeartbeats();
                    totalCapacity += newCapacity * (long)nodes.getNumberofNewNodes();
                    if (nodes.getNumberofIncludeNodes() > 0) {
                        totalNodes = this.cluster.getDataNodes().size();
                        for (i = 0; i < nodes.getNumberofIncludeNodes(); ++i) {
                            nodes.getNodesToBeIncluded().add(this.cluster.getDataNodes().get(totalNodes - 1 - i).getDatanodeId().getXferAddr());
                        }
                    }
                    if (nodes.getNumberofExcludeNodes() > 0) {
                        totalNodes = this.cluster.getDataNodes().size();
                        for (i = 0; i < nodes.getNumberofExcludeNodes(); ++i) {
                            nodes.getNodesToBeExcluded().add(this.cluster.getDataNodes().get(totalNodes - 1 - i).getDatanodeId().getXferAddr());
                        }
                    }
                }
            }
            BalancerParameters.Builder pBuilder = new BalancerParameters.Builder();
            if (nodes != null) {
                pBuilder.setExcludedNodes(nodes.getNodesToBeExcluded());
                pBuilder.setIncludedNodes(nodes.getNodesToBeIncluded());
                pBuilder.setRunDuringUpgrade(false);
            }
            BalancerParameters p = pBuilder.build();
            int expectedExcludedNodes = 0;
            if (nodes != null) {
                if (!nodes.getNodesToBeExcluded().isEmpty()) {
                    expectedExcludedNodes = nodes.getNodesToBeExcluded().size();
                } else if (!nodes.getNodesToBeIncluded().isEmpty()) {
                    expectedExcludedNodes = this.cluster.getDataNodes().size() - nodes.getNodesToBeIncluded().size();
                }
            }
            if (useTool) {
                this.runBalancerCli(conf, totalUsedSpace, totalCapacity, p, useFile, expectedExcludedNodes);
            } else {
                this.runBalancer(conf, totalUsedSpace, totalCapacity, p, expectedExcludedNodes);
            }
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    private void runBalancer(Configuration conf, long totalUsedSpace, long totalCapacity) throws Exception {
        this.runBalancer(conf, totalUsedSpace, totalCapacity, BalancerParameters.DEFAULT, 0);
    }

    private void runBalancer(Configuration conf, long totalUsedSpace, long totalCapacity, BalancerParameters p, int excludedNodes) throws Exception {
        this.runBalancer(conf, totalUsedSpace, totalCapacity, p, excludedNodes, true);
    }

    private void runBalancer(Configuration conf, long totalUsedSpace, long totalCapacity, BalancerParameters p, int excludedNodes, boolean checkExcludeNodesUtilization) throws Exception {
        TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity, this.client, this.cluster);
        int retry = 5;
        while (retry > 0) {
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            int run = TestBalancer.runBalancer(namenodes, p, conf);
            if (conf.getInt("dfs.datanode.balance.max.concurrent.moves", 100) == 0) {
                Assert.assertEquals((long)ExitStatus.NO_MOVE_PROGRESS.getExitCode(), (long)run);
                return;
            }
            Assert.assertEquals((long)ExitStatus.SUCCESS.getExitCode(), (long)run);
            TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity, this.client, this.cluster);
            LOG.info("  .");
            try {
                TestBalancer.waitForBalancer(totalUsedSpace, totalCapacity, this.client, this.cluster, p, excludedNodes, checkExcludeNodesUtilization);
                break;
            }
            catch (TimeoutException e) {
                if (--retry == 0) {
                    throw e;
                }
                LOG.warn("The cluster has not balanced yet, retry...");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int runBalancer(Collection<URI> namenodes, BalancerParameters p, Configuration conf) throws IOException, InterruptedException {
        block15: {
            block14: {
                sleeptime = conf.getLong("dfs.heartbeat.interval", 3L) * 2000L + conf.getLong("dfs.namenode.redundancy.interval.seconds", 3L) * 1000L;
                TestBalancer.LOG.info("namenodes  = " + namenodes);
                TestBalancer.LOG.info("parameters = " + p);
                TestBalancer.LOG.info("Print stack trace", new Throwable());
                System.out.println("Time Stamp               Iteration#  Bytes Already Moved  Bytes Left To Move  Bytes Being Moved");
                connectors = Collections.emptyList();
                try {
                    connectors = NameNodeConnector.newNameNodeConnectors(namenodes, (String)Balancer.class.getSimpleName(), (Path)Balancer.BALANCER_ID_PATH, (Configuration)conf, (int)BalancerParameters.DEFAULT.getMaxIdleIteration());
                    done = false;
                    iteration = 0;
lbl11:
                    // 2 sources

                    while (!done) {
                        done = true;
                        Collections.shuffle(connectors);
lbl14:
                        // 4 sources

                        for (NameNodeConnector nnc : connectors) {
                            b = new Balancer(nnc, p, conf);
                            r = b.runOneIteration();
                            r.print(iteration, nnc, System.out);
                            b.resetData(conf);
                            if (r.getExitStatus() == ExitStatus.IN_PROGRESS) {
                                done = false;
                                continue;
                            }
                            if (r.getExitStatus() != ExitStatus.SUCCESS) {
                                var12_13 = r.getExitStatus().getExitCode();
                                var13_14 = connectors.iterator();
                                break block14;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl47
                    }
                    break block15;
                }
                catch (Throwable var15_16) {
                    var16_17 = connectors.iterator();
                    while (true) {
                        if (!var16_17.hasNext()) {
                            throw var15_16;
                        }
                        nnc = (NameNodeConnector)var16_17.next();
                        IOUtils.cleanupWithLogger((Logger)TestBalancer.LOG, (Closeable[])new Closeable[]{nnc});
                    }
                }
            }
            while (true) {
                if (!var13_14.hasNext()) {
                    return var12_13;
                }
                nnc = (NameNodeConnector)var13_14.next();
                IOUtils.cleanupWithLogger((Logger)TestBalancer.LOG, (Closeable[])new Closeable[]{nnc});
            }
lbl-1000:
            // 1 sources

            {
                if (iteration <= 0) ** GOTO lbl14
                Assert.assertTrue((boolean)(r.getBytesAlreadyMoved() > 0L));
                ** GOTO lbl14
lbl47:
                // 1 sources

                if (!done) {
                    Thread.sleep(sleeptime);
                }
                ++iteration;
                ** GOTO lbl11
            }
        }
        var6_6 = connectors.iterator();
        while (true) {
            if (!var6_6.hasNext()) {
                return ExitStatus.SUCCESS.getExitCode();
            }
            nnc = (NameNodeConnector)var6_6.next();
            IOUtils.cleanupWithLogger((Logger)TestBalancer.LOG, (Closeable[])new Closeable[]{nnc});
        }
    }

    private void runBalancerCli(Configuration conf, long totalUsedSpace, long totalCapacity, BalancerParameters p, boolean useFile, int expectedExcludedNodes) throws Exception {
        TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity, this.client, this.cluster);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-policy");
        args.add("datanode");
        File excludeHostsFile = null;
        if (!p.getExcludedNodes().isEmpty()) {
            args.add("-exclude");
            if (useFile) {
                excludeHostsFile = GenericTestUtils.getTestDir((String)"exclude-hosts-file");
                PrintWriter pw = new PrintWriter(excludeHostsFile);
                for (Object host : p.getExcludedNodes()) {
                    pw.write((String)host + "\n");
                }
                pw.close();
                args.add("-f");
                args.add(excludeHostsFile.getAbsolutePath());
            } else {
                args.add(StringUtils.join((Iterable)p.getExcludedNodes(), (char)','));
            }
        }
        File includeHostsFile = null;
        if (!p.getIncludedNodes().isEmpty()) {
            args.add("-include");
            if (useFile) {
                includeHostsFile = GenericTestUtils.getTestDir((String)"include-hosts-file");
                PrintWriter pw = new PrintWriter(includeHostsFile);
                for (String host : p.getIncludedNodes()) {
                    pw.write(host + "\n");
                }
                pw.close();
                args.add("-f");
                args.add(includeHostsFile.getAbsolutePath());
            } else {
                args.add(StringUtils.join((Iterable)p.getIncludedNodes(), (char)','));
            }
        }
        Balancer.Cli tool = new Balancer.Cli();
        tool.setConf(conf);
        int r = tool.run(args.toArray(new String[0]));
        Assert.assertEquals((String)"Tools should exit 0 on success", (long)0L, (long)r);
        TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity, this.client, this.cluster);
        LOG.info("Rebalancing with default ctor.");
        TestBalancer.waitForBalancer(totalUsedSpace, totalCapacity, this.client, this.cluster, p, expectedExcludedNodes);
        if (excludeHostsFile != null && excludeHostsFile.exists()) {
            excludeHostsFile.delete();
        }
        if (includeHostsFile != null && includeHostsFile.exists()) {
            includeHostsFile.delete();
        }
    }

    private void oneNodeTest(Configuration conf, boolean useTool) throws Exception {
        this.doTest(conf, new long[]{5000L}, new String[]{RACK0}, 2500L, RACK0, useTool);
    }

    private void twoNodeTest(Configuration conf) throws Exception {
        this.doTest(conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, false);
    }

    public void integrationTest(Configuration conf) throws Exception {
        TestBalancer.initConf(conf);
        this.oneNodeTest(conf, false);
    }

    @Test(timeout=100000L)
    public void testUnknownDatanodeSimple() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.testUnknownDatanode((Configuration)conf);
    }

    private void testUnknownDatanode(Configuration conf) throws IOException, InterruptedException, TimeoutException {
        long[] distribution = new long[]{2500L, 3500L, 0L};
        long[] capacities = new long[]{5000L, 5000L, 5000L};
        String[] racks = new String[]{RACK0, RACK1, RACK1};
        int numDatanodes = distribution.length;
        if (capacities.length != numDatanodes || racks.length != numDatanodes) {
            throw new IllegalArgumentException("Array length is not the same");
        }
        long totalUsedSpace = TestBalancer.sum(distribution);
        ExtendedBlock[] blocks = this.generateBlocks(conf, totalUsedSpace, (short)numDatanodes);
        Block[][] blocksDN = TestBalancer.distributeBlocks(blocks, (short)(numDatanodes - 1), distribution);
        conf.set("dfs.namenode.safemode.threshold-pct", "0.0f");
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDatanodes).format(false).racks(racks).simulatedCapacities(capacities).build();
        this.cluster.waitActive();
        this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
        for (int i = 0; i < 3; ++i) {
            this.cluster.injectBlocks(i, Arrays.asList(blocksDN[i]), null);
        }
        this.cluster.startDataNodes(conf, 1, true, null, new String[]{RACK0}, null, new long[]{5000L});
        this.cluster.triggerHeartbeats();
        Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        HashSet<String> datanodes = new HashSet<String>();
        datanodes.add(this.cluster.getDataNodes().get(0).getDatanodeId().getHostName());
        BalancerParameters.Builder pBuilder = new BalancerParameters.Builder();
        pBuilder.setExcludedNodes(datanodes);
        pBuilder.setRunDuringUpgrade(false);
        int r = Balancer.run((Collection)namenodes, (BalancerParameters)pBuilder.build(), (Configuration)conf);
        Assert.assertEquals((long)ExitStatus.SUCCESS.getExitCode(), (long)r);
    }

    @Test(timeout=100000L)
    public void testBalancerCliParseWithThresholdOutOfBoundaries() {
        String[] parameters = new String[]{"-threshold", "0"};
        String reason = "IllegalArgumentException is expected when threshold value is out of boundary.";
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Number out of range: threshold = 0.0", (Object)e.getMessage());
        }
        parameters = new String[]{"-threshold", "101"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Number out of range: threshold = 101.0", (Object)e.getMessage());
        }
    }

    @Test(timeout=100000L)
    public void testBalancer0() throws Exception {
        this.testBalancer0Internal((Configuration)new HdfsConfiguration());
    }

    void testBalancer0Internal(Configuration conf) throws Exception {
        TestBalancer.initConf(conf);
        this.oneNodeTest(conf, false);
        this.twoNodeTest(conf);
    }

    @Test(timeout=100000L)
    public void testBalancer1() throws Exception {
        this.testBalancer1Internal((Configuration)new HdfsConfiguration());
    }

    void testBalancer1Internal(Configuration conf) throws Exception {
        TestBalancer.initConf(conf);
        this.testUnevenDistribution(conf, new long[]{2500L, 500L}, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1});
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testBalancerWithZeroThreadsForMove() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.balance.max.concurrent.moves", 0);
        this.testBalancer1Internal((Configuration)conf);
    }

    @Test(timeout=100000L)
    public void testBalancerWithNonZeroThreadsForMove() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.balance.max.concurrent.moves", 8);
        this.testBalancer1Internal((Configuration)conf);
    }

    @Test(timeout=100000L)
    public void testBalancer2() throws Exception {
        this.testBalancer2Internal((Configuration)new HdfsConfiguration());
    }

    void testBalancer2Internal(Configuration conf) throws Exception {
        TestBalancer.initConf(conf);
        this.testBalancerDefaultConstructor(conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBalancerDefaultConstructor(Configuration conf, long[] capacities, String[] racks, long newCapacity, String newRack) throws Exception {
        int numOfDatanodes = capacities.length;
        Assert.assertEquals((long)numOfDatanodes, (long)racks.length);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(capacities.length).racks(racks).simulatedCapacities(capacities).build();
        try {
            this.cluster.waitActive();
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            long totalCapacity = TestBalancer.sum(capacities);
            long totalUsedSpace = totalCapacity * 3L / 10L;
            TestBalancer.createFile(this.cluster, filePath, totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes, 0);
            this.cluster.startDataNodes(conf, 1, true, null, new String[]{newRack}, new long[]{newCapacity});
            this.runBalancer(conf, totalUsedSpace, totalCapacity += newCapacity);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=100000L)
    public void testBalancerCliParseWithWrongParams() {
        String[] parameters = new String[]{"-threshold"};
        String reason = "IllegalArgumentException is expected when value is not specified";
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-policy"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-threshold", "1", "-policy"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-threshold", "1", "-include"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-threshold", "1", "-exclude"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-include", "-f"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-exclude", "-f"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-include", "testnode1", "-exclude", "testnode2"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)"IllegalArgumentException is expected when both -exclude and -include are specified");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-blockpools"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)"IllegalArgumentException is expected when a value is not specified for the blockpool flag");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-source"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)(reason + " for -source parameter"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBalancerCliParseBlockpools() {
        String[] parameters = new String[]{"-blockpools", "bp-1,bp-2,bp-3"};
        BalancerParameters p = Balancer.Cli.parse((String[])parameters);
        Assert.assertEquals((long)3L, (long)p.getBlockPools().size());
        parameters = new String[]{"-blockpools", "bp-1"};
        p = Balancer.Cli.parse((String[])parameters);
        Assert.assertEquals((long)1L, (long)p.getBlockPools().size());
        parameters = new String[]{"-blockpools", "bp-1,,bp-2"};
        p = Balancer.Cli.parse((String[])parameters);
        Assert.assertEquals((long)3L, (long)p.getBlockPools().size());
        parameters = new String[]{"-blockpools", "bp-1,"};
        p = Balancer.Cli.parse((String[])parameters);
        Assert.assertEquals((long)1L, (long)p.getBlockPools().size());
    }

    @Test(timeout=100000L)
    public void testExitZeroOnSuccess() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.oneNodeTest((Configuration)conf, true);
    }

    @Test(timeout=100000L)
    public void testBalancerWithExcludeList() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> excludeHosts = new HashSet<String>();
        excludeHosts.add("datanodeY");
        excludeHosts.add("datanodeZ");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, excludeHosts, BalancerParameters.DEFAULT.getIncludedNodes()), false, false);
    }

    @Test(timeout=100000L)
    public void testBalancerWithExcludeListWithPorts() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 2, 0), false, false);
    }

    @Test(timeout=100000L)
    public void testBalancerCliWithExcludeList() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> excludeHosts = new HashSet<String>();
        excludeHosts.add("datanodeY");
        excludeHosts.add("datanodeZ");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, excludeHosts, BalancerParameters.DEFAULT.getIncludedNodes()), true, false);
    }

    @Test(timeout=100000L)
    public void testBalancerCliWithExcludeListWithPorts() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 2, 0), true, false);
    }

    @Test(timeout=100000L)
    public void testBalancerCliWithExcludeListInAFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> excludeHosts = new HashSet<String>();
        excludeHosts.add("datanodeY");
        excludeHosts.add("datanodeZ");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, excludeHosts, BalancerParameters.DEFAULT.getIncludedNodes()), true, true);
    }

    @Test(timeout=100000L)
    public void testBalancerCliWithExcludeListWithPortsInAFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 2, 0), true, true);
    }

    @Test(timeout=100000L)
    public void testBalancerWithIncludeList() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> includeHosts = new HashSet<String>();
        includeHosts.add("datanodeY");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, BalancerParameters.DEFAULT.getExcludedNodes(), includeHosts), false, false);
    }

    @Test(timeout=100000L)
    public void testBalancerWithIncludeListWithPorts() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 0, 1), false, false);
    }

    @Test(timeout=100000L)
    public void testBalancerCliWithIncludeList() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> includeHosts = new HashSet<String>();
        includeHosts.add("datanodeY");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, BalancerParameters.DEFAULT.getExcludedNodes(), includeHosts), true, false);
    }

    @Test(timeout=100000L)
    public void testBalancerCliWithIncludeListWithPorts() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 0, 1), true, false);
    }

    @Test(timeout=100000L)
    public void testBalancerCliWithIncludeListInAFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> includeHosts = new HashSet<String>();
        includeHosts.add("datanodeY");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, BalancerParameters.DEFAULT.getExcludedNodes(), includeHosts), true, true);
    }

    @Test(timeout=100000L)
    public void testBalancerCliWithIncludeListWithPortsInAFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 0, 1), true, true);
    }

    @Test(timeout=300000L)
    public void testBalancerDuringUpgrade() throws Exception {
        int SEED = 1027565;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.namenode.redundancy.interval.seconds", 1L);
        conf.setLong("dfs.balancer.getBlocks.min-block-size", 1L);
        int BLOCK_SIZE = 0x100000;
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).storageCapacities(new long[]{0xA00000L}).storageTypes(new StorageType[]{StorageType.DEFAULT}).storagesPerDatanode(1).build();
        this.cluster.waitActive();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)fs, path1, 0x100000, 0x200000L, 0x100000L, (short)1, 1027565L);
        this.cluster.startDataNodes((Configuration)conf, 1, true, null, null);
        this.cluster.triggerHeartbeats();
        Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        BalancerParameters p = BalancerParameters.DEFAULT;
        fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        fs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
        fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        Assert.assertEquals((long)ExitStatus.UNFINALIZED_UPGRADE.getExitCode(), (long)Balancer.run((Collection)namenodes, (BalancerParameters)p, (Configuration)conf));
        BalancerParameters.Builder b = new BalancerParameters.Builder();
        b.setRunDuringUpgrade(true);
        BalancerParameters runDuringUpgrade = b.build();
        Assert.assertEquals((long)ExitStatus.SUCCESS.getExitCode(), (long)Balancer.run((Collection)namenodes, (BalancerParameters)runDuringUpgrade, (Configuration)conf));
        fs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.FINALIZE);
        Assert.assertEquals((long)ExitStatus.SUCCESS.getExitCode(), (long)Balancer.run((Collection)namenodes, (BalancerParameters)p, (Configuration)conf));
    }

    @Test(timeout=100000L)
    public void testManyBalancerSimultaneously() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        long[] capacities = new long[]{20000L};
        String[] racks = new String[]{RACK0};
        long newCapacity = 10000L;
        String newRack = RACK0;
        LOG.info("capacities = " + this.long2String(capacities));
        LOG.info("racks      = " + Arrays.asList(racks));
        LOG.info("newCapacity= " + newCapacity);
        LOG.info("newRack    = " + newRack);
        LOG.info("useTool    = false");
        Assert.assertEquals((long)capacities.length, (long)racks.length);
        int numOfDatanodes = capacities.length;
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(capacities.length).racks(racks).simulatedCapacities(capacities).build();
        this.cluster.waitActive();
        this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
        long totalCapacity = TestBalancer.sum(capacities);
        long totalUsedSpace = totalCapacity * 3L / 10L;
        TestBalancer.createFile(this.cluster, filePath, totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes, 0);
        this.cluster.startDataNodes((Configuration)conf, 1, true, null, new String[]{newRack}, new long[]{newCapacity});
        this.cluster.triggerHeartbeats();
        DistributedFileSystem fs = this.cluster.getFileSystem(0);
        FSDataOutputStream out = fs.create(Balancer.BALANCER_ID_PATH, false);
        out.writeBytes(InetAddress.getLocalHost().getHostName());
        out.hflush();
        Assert.assertTrue((String)"'balancer.id' file doesn't exist!", (boolean)fs.exists(Balancer.BALANCER_ID_PATH));
        String[] args = new String[]{"-policy", "datanode"};
        Balancer.Cli tool = new Balancer.Cli();
        tool.setConf((Configuration)conf);
        int exitCode = tool.run(args);
        Assert.assertEquals((String)"Exit status code mismatches", (long)ExitStatus.IO_EXCEPTION.getExitCode(), (long)exitCode);
        out.close();
        Assert.assertTrue((String)"'balancer.id' file doesn't exist!", (boolean)fs.exists(Balancer.BALANCER_ID_PATH));
        exitCode = tool.run(args);
        Assert.assertEquals((String)"Exit status code mismatches", (long)ExitStatus.SUCCESS.getExitCode(), (long)exitCode);
    }

    public void integrationTestWithStripedFile(Configuration conf) throws Exception {
        this.initConfWithStripe(conf);
        this.doTestBalancerWithStripedFile(conf);
    }

    @Test(timeout=200000L)
    public void testBalancerWithStripedFile() throws Exception {
        Configuration conf = new Configuration();
        this.initConfWithStripe(conf);
        NameNodeConnector.setWrite2IdFile((boolean)true);
        this.doTestBalancerWithStripedFile(conf);
        NameNodeConnector.setWrite2IdFile((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestBalancerWithStripedFile(Configuration conf) throws Exception {
        int numOfDatanodes = this.dataBlocks + this.parityBlocks + 3;
        int numOfRacks = this.dataBlocks;
        long capacity = 20 * this.defaultBlockSize;
        long[] capacities = new long[numOfDatanodes];
        for (int i = 0; i < capacities.length; ++i) {
            capacities[i] = capacity;
        }
        String[] racks = new String[numOfDatanodes];
        for (int i = 0; i < numOfDatanodes; ++i) {
            racks[i] = "/rack" + i % numOfRacks;
        }
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numOfDatanodes).racks(racks).simulatedCapacities(capacities).build();
        try {
            this.cluster.waitActive();
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            this.client.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            this.client.setErasureCodingPolicy("/", StripedFileTestUtil.getDefaultECPolicy().getName());
            long totalCapacity = TestBalancer.sum(capacities);
            long fileLen = totalCapacity * 3L / 10L;
            long totalUsedSpace = fileLen * (long)(this.dataBlocks + this.parityBlocks) / (long)this.dataBlocks;
            DistributedFileSystem fs = this.cluster.getFileSystem(0);
            DFSTestUtil.createFile((FileSystem)fs, filePath, fileLen, (short)3, r.nextLong());
            LocatedBlocks locatedBlocks = this.client.getBlockLocations(fileName, 0L, fileLen);
            StripedFileTestUtil.verifyLocatedStripedBlocks(locatedBlocks, this.groupSize);
            String newRack = "/rack" + ++numOfRacks;
            this.cluster.startDataNodes(conf, 2, true, null, new String[]{newRack, newRack}, null, new long[]{capacity, capacity});
            this.cluster.triggerHeartbeats();
            BalancerParameters p = BalancerParameters.DEFAULT;
            this.runBalancer(conf, totalUsedSpace, totalCapacity += capacity * 2L, p, 0);
            this.cluster.triggerHeartbeats();
            this.cluster.triggerDeletionReports();
            locatedBlocks = this.client.getBlockLocations(fileName, 0L, fileLen);
            StripedFileTestUtil.verifyLocatedStripedBlocks(locatedBlocks, this.groupSize);
            this.testNullStripedBlocks(conf);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testBalancerWithExcludeListWithStripedFile() throws Exception {
        Configuration conf = new Configuration();
        this.initConfWithStripe(conf);
        NameNodeConnector.setWrite2IdFile((boolean)true);
        this.doTestBalancerWithExcludeListWithStripedFile(conf);
        NameNodeConnector.setWrite2IdFile((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestBalancerWithExcludeListWithStripedFile(Configuration conf) throws Exception {
        int numOfDatanodes = this.dataBlocks + this.parityBlocks + 5;
        int numOfRacks = this.dataBlocks;
        long capacity = 20 * this.defaultBlockSize;
        long[] capacities = new long[numOfDatanodes];
        Arrays.fill(capacities, capacity);
        String[] racks = new String[numOfDatanodes];
        for (int i = 0; i < numOfDatanodes; ++i) {
            racks[i] = "/rack" + i % numOfRacks;
        }
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numOfDatanodes).racks(racks).simulatedCapacities(capacities).build();
        try {
            this.cluster.waitActive();
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            this.client.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            this.client.setErasureCodingPolicy("/", StripedFileTestUtil.getDefaultECPolicy().getName());
            long totalCapacity = TestBalancer.sum(capacities);
            long fileLen = totalCapacity * 3L / 10L;
            long totalUsedSpace = fileLen * (long)(this.dataBlocks + this.parityBlocks) / (long)this.dataBlocks;
            DistributedFileSystem fs = this.cluster.getFileSystem(0);
            DFSTestUtil.createFile((FileSystem)fs, filePath, fileLen, (short)3, r.nextLong());
            LocatedBlocks locatedBlocks = this.client.getBlockLocations(fileName, 0L, fileLen);
            StripedFileTestUtil.verifyLocatedStripedBlocks(locatedBlocks, this.groupSize);
            DatanodeInfo[] datanodeReport = this.client.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
            long totalBlocks = 0L;
            for (DatanodeInfo dn : datanodeReport) {
                totalBlocks += (long)dn.getNumBlocks();
            }
            String newRack = "/rack" + ++numOfRacks;
            this.cluster.startDataNodes(conf, 2, true, null, new String[]{newRack, newRack}, null, new long[]{capacity, capacity});
            totalCapacity += capacity * 2L;
            this.cluster.triggerHeartbeats();
            HashSet<String> excludedList = new HashSet<String>();
            excludedList.add(datanodeReport[0].getXferAddr());
            BalancerParameters.Builder pBuilder = new BalancerParameters.Builder();
            pBuilder.setExcludedNodes(excludedList);
            this.runBalancer(conf, totalUsedSpace, totalCapacity, pBuilder.build(), excludedList.size(), false);
            long blocksBeforeBalancer = totalBlocks;
            GenericTestUtils.waitFor(() -> {
                DatanodeInfo[] datanodeInfos = null;
                try {
                    this.cluster.triggerHeartbeats();
                    datanodeInfos = this.client.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                }
                long blocksAfterBalancer = 0L;
                for (DatanodeInfo dn : datanodeInfos) {
                    blocksAfterBalancer += (long)dn.getNumBlocks();
                }
                return blocksBeforeBalancer == blocksAfterBalancer;
            }, (long)3000L, (long)60000L);
            locatedBlocks = this.client.getBlockLocations(fileName, 0L, fileLen);
            StripedFileTestUtil.verifyLocatedStripedBlocks(locatedBlocks, this.groupSize);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    private void testNullStripedBlocks(Configuration conf) throws IOException {
        Dispatcher spyDispatcher;
        NameNodeConnector nnc = (NameNodeConnector)NameNodeConnector.newNameNodeConnectors((Collection)DFSUtil.getInternalNsRpcUris((Configuration)conf), (String)Balancer.class.getSimpleName(), (Path)Balancer.BALANCER_ID_PATH, (Configuration)conf, (int)BalancerParameters.DEFAULT.getMaxIdleIteration()).get(0);
        Dispatcher dispatcher = new Dispatcher(nnc, Collections.emptySet(), Collections.emptySet(), 1L, 1, 0, 1, 1, conf);
        Dispatcher dispatcher2 = spyDispatcher = (Dispatcher)Mockito.spy((Object)dispatcher);
        Objects.requireNonNull(dispatcher2);
        Dispatcher.PendingMove move = new Dispatcher.PendingMove(dispatcher2, (Dispatcher.Source)Mockito.mock(Dispatcher.Source.class), (Dispatcher.DDatanode.StorageGroup)Mockito.mock(Dispatcher.DDatanode.StorageGroup.class));
        Dispatcher.DBlockStriped block = (Dispatcher.DBlockStriped)Mockito.mock(Dispatcher.DBlockStriped.class);
        ((Dispatcher.DBlockStriped)Mockito.doReturn(null).when((Object)block)).getInternalBlock((Dispatcher.DDatanode.StorageGroup)Mockito.any());
        ((Dispatcher)Mockito.doReturn((Object)true).when((Object)spyDispatcher)).isGoodBlockCandidate((Dispatcher.DDatanode.StorageGroup)Mockito.any(), (Dispatcher.DDatanode.StorageGroup)Mockito.any(), (StorageType)Mockito.any(), (Dispatcher.DBlock)Mockito.any());
        Mockito.when((Object)move.markMovedIfGoodBlock((Dispatcher.DBlock)block, StorageType.DEFAULT)).thenCallRealMethod();
        Assert.assertFalse((boolean)move.markMovedIfGoodBlock((Dispatcher.DBlock)block, StorageType.DEFAULT));
    }

    @Test(timeout=300000L)
    public void testBalancerWithKeytabs() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        try {
            TestBalancer.initSecureConf((Configuration)conf);
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytabFile.getAbsolutePath());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>((Configuration)conf){
                final /* synthetic */ Configuration val$conf;
                {
                    this.val$conf = configuration;
                }

                @Override
                public Void run() throws Exception {
                    TestBalancer.this.testUnknownDatanode(this.val$conf);
                    Assert.assertTrue((boolean)UserGroupInformation.isLoginKeytabBased());
                    return null;
                }
            });
        }
        finally {
            UserGroupInformation.reset();
            UserGroupInformation.setConfiguration((Configuration)new Configuration());
        }
    }

    private void spyFSNamesystem(NameNode nn) throws IOException {
        FSNamesystem fsnSpy = NameNodeAdapter.spyOnNamesystem(nn);
        ((FSNamesystem)Mockito.doAnswer((Answer)new Answer<BlocksWithLocations>(){

            public BlocksWithLocations answer(InvocationOnMock invocation) throws Throwable {
                long startTime = Time.monotonicNow();
                TestBalancer.this.startGetBlocksTime.getAndUpdate(curr -> Math.min(curr, startTime));
                BlocksWithLocations blk = (BlocksWithLocations)invocation.callRealMethod();
                long endTime = Time.monotonicNow();
                TestBalancer.this.endGetBlocksTime.getAndUpdate(curr -> Math.max(curr, endTime));
                TestBalancer.this.numGetBlocksCalls.incrementAndGet();
                return blk;
            }
        }).when((Object)fsnSpy)).getBlocks((DatanodeID)Mockito.any(DatanodeID.class), Mockito.anyLong(), Mockito.anyLong());
    }

    void testBalancerRPCDelay(int getBlocksMaxQps) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        conf.setInt("dfs.balancer.dispatcherThreads", 30);
        conf.setInt("dfs.namenode.get-blocks.max-qps", getBlocksMaxQps);
        int numDNs = 20;
        long[] capacities = new long[numDNs];
        String[] racks = new String[numDNs];
        for (int i = 0; i < numDNs; ++i) {
            capacities[i] = 5000L;
            racks[i] = i < numDNs / 2 ? RACK0 : RACK1;
        }
        this.doTest((Configuration)conf, capacities, racks, 5000L, RACK2, new PortNumberBasedNodes(1, 0, 0), false, false, true, 0.5);
        Assert.assertTrue((String)("Number of getBlocks should be not less than " + getBlocksMaxQps), (this.numGetBlocksCalls.get() >= getBlocksMaxQps ? 1 : 0) != 0);
        long durationMs = 1L + this.endGetBlocksTime.get() - this.startGetBlocksTime.get();
        int durationSec = (int)Math.ceil((double)durationMs / 1000.0);
        LOG.info("Balancer executed {} getBlocks in {} msec (round up to {} sec)", new Object[]{this.numGetBlocksCalls.get(), durationMs, durationSec});
        long getBlockCallsPerSecond = this.numGetBlocksCalls.get() / durationSec;
        Assert.assertTrue((String)("Expected balancer getBlocks calls per second <= " + getBlocksMaxQps), (getBlockCallsPerSecond <= (long)getBlocksMaxQps ? 1 : 0) != 0);
    }

    public static void main(String[] args) throws Exception {
        TestBalancer balancerTest = new TestBalancer();
        balancerTest.testBalancer0();
        balancerTest.testBalancer1();
        balancerTest.testBalancer2();
    }

    static {
        GenericTestUtils.setLogLevel((Logger)Balancer.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)Dispatcher.LOG, (Level)Level.DEBUG);
        filePath = new Path(fileName);
        r = new Random();
        TestBalancer.initTestSetup();
    }

    static class PortNumberBasedNodes
    extends NewNodeInfo {
        int newNodes;
        int excludeNodes;
        int includeNodes;

        public PortNumberBasedNodes(int newNodes, int excludeNodes, int includeNodes) {
            this.newNodes = newNodes;
            this.excludeNodes = excludeNodes;
            this.includeNodes = includeNodes;
        }

        @Override
        String[] getNames() {
            return null;
        }

        @Override
        int getNumberofNewNodes() {
            return this.newNodes;
        }

        @Override
        int getNumberofIncludeNodes() {
            return this.includeNodes;
        }

        @Override
        int getNumberofExcludeNodes() {
            return this.excludeNodes;
        }
    }

    static class HostNameBasedNodes
    extends NewNodeInfo {
        String[] hostnames;

        public HostNameBasedNodes(String[] hostnames, Set<String> nodesToBeExcluded, Set<String> nodesToBeIncluded) {
            this.hostnames = hostnames;
            this.nodesToBeExcluded = nodesToBeExcluded;
            this.nodesToBeIncluded = nodesToBeIncluded;
        }

        @Override
        String[] getNames() {
            return this.hostnames;
        }

        @Override
        int getNumberofNewNodes() {
            return this.hostnames.length;
        }

        @Override
        int getNumberofIncludeNodes() {
            return this.nodesToBeIncluded.size();
        }

        @Override
        int getNumberofExcludeNodes() {
            return this.nodesToBeExcluded.size();
        }
    }

    static abstract class NewNodeInfo {
        Set<String> nodesToBeExcluded = new HashSet<String>();
        Set<String> nodesToBeIncluded = new HashSet<String>();

        NewNodeInfo() {
        }

        abstract String[] getNames();

        abstract int getNumberofNewNodes();

        abstract int getNumberofIncludeNodes();

        abstract int getNumberofExcludeNodes();

        public Set<String> getNodesToBeIncluded() {
            return this.nodesToBeIncluded;
        }

        public Set<String> getNodesToBeExcluded() {
            return this.nodesToBeExcluded;
        }
    }
}

