/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdfs.qjournal.client.QuorumCall;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.junit.Assert;
import org.junit.Test;

public class TestQuorumCall {
    @Test(timeout=10000L)
    public void testQuorums() throws Exception {
        ImmutableMap futures = ImmutableMap.of((Object)"f1", (Object)SettableFuture.create(), (Object)"f2", (Object)SettableFuture.create(), (Object)"f3", (Object)SettableFuture.create());
        QuorumCall q = QuorumCall.create((Map)futures);
        Assert.assertEquals((long)0L, (long)q.countResponses());
        ((SettableFuture)futures.get("f1")).set((Object)"first future");
        q.waitFor(1, 0, 0, 100000, "test");
        q.waitFor(0, 1, 0, 100000, "test");
        Assert.assertEquals((long)1L, (long)q.countResponses());
        ((SettableFuture)futures.get("f2")).setException((Throwable)new Exception("error"));
        Assert.assertEquals((long)2L, (long)q.countResponses());
        ((SettableFuture)futures.get("f3")).set((Object)"second future");
        q.waitFor(3, 0, 100, 100000, "test");
        q.waitFor(0, 2, 100, 100000, "test");
        Assert.assertEquals((long)3L, (long)q.countResponses());
        Assert.assertEquals((Object)"f1=first future,f3=second future", (Object)Joiner.on((String)",").withKeyValueSeparator("=").join(new TreeMap(q.getResults())));
        try {
            q.waitFor(0, 4, 100, 10, "test");
            Assert.fail((String)"Didn't time out waiting for more responses than came back");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testQuorumFailsWithoutResponse() throws Exception {
        ImmutableMap futures = ImmutableMap.of((Object)"f1", (Object)SettableFuture.create());
        QuorumCall q = QuorumCall.create((Map)futures);
        Assert.assertEquals((String)"The number of quorum calls for which a response has been received should be 0", (long)0L, (long)q.countResponses());
        try {
            q.waitFor(0, 1, 100, 10, "test");
            Assert.fail((String)"Didn't time out waiting for more responses than came back");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testQuorumSucceedsWithLongPause() throws Exception {
        ImmutableMap futures = ImmutableMap.of((Object)"f1", (Object)SettableFuture.create());
        FakeTimer timer = new FakeTimer((Map)futures){
            private int callCount = 0;
            final /* synthetic */ Map val$futures;
            {
                this.val$futures = map;
            }

            public long monotonicNowNanos() {
                ++this.callCount;
                if (this.callCount == 1) {
                    long old = super.monotonicNowNanos();
                    this.advance(1000000L);
                    return old;
                }
                if (this.callCount == 10) {
                    ((SettableFuture)this.val$futures.get("f1")).set((Object)"first future");
                    return super.monotonicNowNanos();
                }
                return super.monotonicNowNanos();
            }
        };
        QuorumCall q = QuorumCall.create((Map)futures, (Timer)timer);
        Assert.assertEquals((long)0L, (long)q.countResponses());
        q.waitFor(1, 0, 0, 3000, "test");
    }
}

