/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFsWithXAttrs {
    private static MiniDFSCluster cluster;
    private static Configuration clusterConf;
    private static FileContext fc;
    private static FileContext fc2;
    private FileContext fcView;
    private FileContext fcTarget;
    private FileContext fcTarget2;
    private Configuration fsViewConf;
    private Path targetTestRoot;
    private Path targetTestRoot2;
    private Path mountOnNn1;
    private Path mountOnNn2;
    private FileContextTestHelper fileContextTestHelper = new FileContextTestHelper("/tmp/TestViewFsWithXAttrs");
    protected static final String name1 = "user.a1";
    protected static final byte[] value1;
    protected static final String name2 = "user.a2";
    protected static final byte[] value2;

    @BeforeClass
    public static void clusterSetupAtBeginning() throws IOException {
        cluster = new MiniDFSCluster.Builder(clusterConf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(2).build();
        cluster.waitClusterUp();
        fc = FileContext.getFileContext((URI)cluster.getURI(0), (Configuration)clusterConf);
        fc2 = FileContext.getFileContext((URI)cluster.getURI(1), (Configuration)clusterConf);
    }

    @AfterClass
    public static void ClusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fcTarget = fc;
        this.fcTarget2 = fc2;
        this.targetTestRoot = this.fileContextTestHelper.getAbsoluteTestRootPath(fc);
        this.targetTestRoot2 = this.fileContextTestHelper.getAbsoluteTestRootPath(fc2);
        this.fcTarget.delete(this.targetTestRoot, true);
        this.fcTarget2.delete(this.targetTestRoot2, true);
        this.fcTarget.mkdir(this.targetTestRoot, new FsPermission(488), true);
        this.fcTarget2.mkdir(this.targetTestRoot2, new FsPermission(488), true);
        this.fsViewConf = ViewFileSystemTestSetup.createConfig();
        this.setupMountPoints();
        this.fcView = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)this.fsViewConf);
    }

    private void setupMountPoints() {
        this.mountOnNn1 = new Path("/mountOnNn1");
        this.mountOnNn2 = new Path("/mountOnNn2");
        ConfigUtil.addLink((Configuration)this.fsViewConf, (String)this.mountOnNn1.toString(), (URI)this.targetTestRoot.toUri());
        ConfigUtil.addLink((Configuration)this.fsViewConf, (String)this.mountOnNn2.toString(), (URI)this.targetTestRoot2.toUri());
    }

    @After
    public void tearDown() throws Exception {
        this.fcTarget.delete(this.fileContextTestHelper.getTestRootPath(this.fcTarget), true);
        this.fcTarget2.delete(this.fileContextTestHelper.getTestRootPath(this.fcTarget2), true);
    }

    @Test
    public void testXAttrOnMountEntry() throws Exception {
        this.fcView.setXAttr(this.mountOnNn1, name1, value1);
        this.fcView.setXAttr(this.mountOnNn1, name2, value2);
        Assert.assertEquals((long)2L, (long)this.fcView.getXAttrs(this.mountOnNn1).size());
        Assert.assertArrayEquals((byte[])value1, (byte[])this.fcView.getXAttr(this.mountOnNn1, name1));
        Assert.assertArrayEquals((byte[])value2, (byte[])this.fcView.getXAttr(this.mountOnNn1, name2));
        Assert.assertArrayEquals((byte[])value1, (byte[])fc.getXAttr(this.targetTestRoot, name1));
        Assert.assertArrayEquals((byte[])value2, (byte[])fc.getXAttr(this.targetTestRoot, name2));
        Assert.assertEquals((long)0L, (long)this.fcView.getXAttrs(this.mountOnNn2).size());
        Assert.assertEquals((long)0L, (long)fc2.getXAttrs(this.targetTestRoot2).size());
        this.fcView.removeXAttr(this.mountOnNn1, name1);
        this.fcView.removeXAttr(this.mountOnNn1, name2);
        Assert.assertEquals((long)0L, (long)this.fcView.getXAttrs(this.mountOnNn1).size());
        Assert.assertEquals((long)0L, (long)fc.getXAttrs(this.targetTestRoot).size());
        this.fcView.setXAttr(this.mountOnNn2, name1, value1);
        this.fcView.setXAttr(this.mountOnNn2, name2, value2);
        Assert.assertEquals((long)2L, (long)this.fcView.getXAttrs(this.mountOnNn2).size());
        Assert.assertArrayEquals((byte[])value1, (byte[])this.fcView.getXAttr(this.mountOnNn2, name1));
        Assert.assertArrayEquals((byte[])value2, (byte[])this.fcView.getXAttr(this.mountOnNn2, name2));
        Assert.assertArrayEquals((byte[])value1, (byte[])fc2.getXAttr(this.targetTestRoot2, name1));
        Assert.assertArrayEquals((byte[])value2, (byte[])fc2.getXAttr(this.targetTestRoot2, name2));
        this.fcView.removeXAttr(this.mountOnNn2, name1);
        this.fcView.removeXAttr(this.mountOnNn2, name2);
        Assert.assertEquals((long)0L, (long)this.fcView.getXAttrs(this.mountOnNn2).size());
        Assert.assertEquals((long)0L, (long)fc2.getXAttrs(this.targetTestRoot2).size());
    }

    static {
        clusterConf = new Configuration();
        value1 = new byte[]{49, 50, 51};
        value2 = new byte[]{55, 56, 57};
    }
}

