/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestViewFileSystemLinkFallback
extends ViewFileSystemBaseTest {
    private static FileSystem fsDefault;
    private static MiniDFSCluster cluster;
    private static final int NAME_SPACES_COUNT = 3;
    private static final int DATA_NODES_COUNT = 3;
    private static final int FS_INDEX_DEFAULT = 0;
    private static final String LINK_FALLBACK_CLUSTER_1_NAME = "Cluster1";
    private static final FileSystem[] FS_HDFS;
    private static final Configuration CONF;
    private static final File TEST_DIR;
    private static final String TEST_BASE_PATH = "/tmp/TestViewFileSystemLinkFallback";
    private static final Logger LOG;
    private static URI viewFsDefaultClusterUri;

    protected FileSystemTestHelper createFileSystemHelper() {
        return new FileSystemTestHelper(TEST_BASE_PATH);
    }

    @BeforeClass
    public static void clusterSetupAtBeginning() throws IOException, LoginException, URISyntaxException {
        SupportsBlocks = true;
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(CONF).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).numDataNodes(3).build();
        cluster.waitClusterUp();
        for (int i = 0; i < 3; ++i) {
            TestViewFileSystemLinkFallback.FS_HDFS[i] = cluster.getFileSystem(i);
        }
        fsDefault = FS_HDFS[0];
        viewFsDefaultClusterUri = new URI("viewfs", "default", "/", null, null);
    }

    @AfterClass
    public static void clusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fsDefault;
        super.setUp();
    }

    void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = fsDefault.makeQualified(new Path("/"));
        for (FileStatus status : fsDefault.listStatus(this.targetTestRoot)) {
            fsDefault.delete(status.getPath(), true);
        }
    }

    void setupMountPoints() {
        super.setupMountPoints();
        ConfigUtil.addLinkFallback((Configuration)this.conf, (String)LINK_FALLBACK_CLUSTER_1_NAME, (URI)this.targetTestRoot.toUri());
    }

    int getExpectedDelegationTokenCount() {
        return 1;
    }

    int getExpectedDelegationTokenCountWithCredentials() {
        return 1;
    }

    @Test
    public void testConfLinkFallback() throws Exception {
        Path testBasePath = new Path(TEST_BASE_PATH);
        Path testLevel2Dir = new Path(TEST_BASE_PATH, "dir1/dirA");
        Path testBaseFile = new Path(testBasePath, "testBaseFile.log");
        Path testBaseFileRelative = new Path(testLevel2Dir, "../../testBaseFile.log");
        Path testLevel2File = new Path(testLevel2Dir, "testLevel2File.log");
        this.fsTarget.mkdirs(testLevel2Dir);
        this.fsTarget.createNewFile(testBaseFile);
        FSDataOutputStream dataOutputStream = this.fsTarget.append(testBaseFile);
        dataOutputStream.write(1);
        dataOutputStream.close();
        this.fsTarget.createNewFile(testLevel2File);
        dataOutputStream = this.fsTarget.append(testLevel2File);
        dataOutputStream.write("test link fallback".toString().getBytes());
        dataOutputStream.close();
        String clusterName = "ClusterFallback";
        URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
        Configuration conf = new Configuration();
        ConfigUtil.addLinkFallback((Configuration)conf, (String)clusterName, (URI)this.fsTarget.getUri());
        FileSystem vfs = FileSystem.get((URI)viewFsUri, (Configuration)conf);
        Assert.assertEquals(ViewFileSystem.class, vfs.getClass());
        FileStatus baseFileStat = vfs.getFileStatus(new Path(viewFsUri.toString() + testBaseFile.toUri().toString()));
        LOG.info("BaseFileStat: " + baseFileStat);
        FileStatus baseFileRelStat = vfs.getFileStatus(new Path(viewFsUri.toString() + testBaseFileRelative.toUri().toString()));
        LOG.info("BaseFileRelStat: " + baseFileRelStat);
        Assert.assertEquals((String)("Unexpected file length for " + testBaseFile), (long)1L, (long)baseFileStat.getLen());
        Assert.assertEquals((String)("Unexpected file length for " + testBaseFileRelative), (long)baseFileStat.getLen(), (long)baseFileRelStat.getLen());
        FileStatus level2FileStat = vfs.getFileStatus(new Path(viewFsUri.toString() + testLevel2File.toUri().toString()));
        LOG.info("Level2FileStat: " + level2FileStat);
        vfs.close();
    }

    @Test
    public void testConfLinkFallbackWithRegularLinks() throws Exception {
        Path testBasePath = new Path(TEST_BASE_PATH);
        Path testLevel2Dir = new Path(TEST_BASE_PATH, "dir1/dirA");
        Path testBaseFile = new Path(testBasePath, "testBaseFile.log");
        Path testLevel2File = new Path(testLevel2Dir, "testLevel2File.log");
        this.fsTarget.mkdirs(testLevel2Dir);
        this.fsTarget.createNewFile(testBaseFile);
        this.fsTarget.createNewFile(testLevel2File);
        FSDataOutputStream dataOutputStream = this.fsTarget.append(testLevel2File);
        dataOutputStream.write("test link fallback".toString().getBytes());
        dataOutputStream.close();
        String clusterName = "ClusterFallback";
        URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/internalDir/linkToDir2", (URI)new Path(this.targetTestRoot, "dir2").toUri());
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/internalDir/internalDirB/linkToDir3", (URI)new Path(this.targetTestRoot, "dir3").toUri());
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/danglingLink", (URI)new Path(this.targetTestRoot, "missingTarget").toUri());
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/linkToAFile", (URI)new Path(this.targetTestRoot, "aFile").toUri());
        System.out.println("ViewFs link fallback " + this.fsTarget.getUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (String)clusterName, (URI)this.targetTestRoot.toUri());
        FileSystem vfs = FileSystem.get((URI)viewFsUri, (Configuration)conf);
        Assert.assertEquals(ViewFileSystem.class, vfs.getClass());
        FileStatus baseFileStat = vfs.getFileStatus(new Path(viewFsUri.toString() + testBaseFile.toUri().toString()));
        LOG.info("BaseFileStat: " + baseFileStat);
        Assert.assertEquals((String)("Unexpected file length for " + testBaseFile), (long)0L, (long)baseFileStat.getLen());
        FileStatus level2FileStat = vfs.getFileStatus(new Path(viewFsUri.toString() + testLevel2File.toUri().toString()));
        LOG.info("Level2FileStat: " + level2FileStat);
        dataOutputStream = vfs.append(testLevel2File);
        dataOutputStream.write("Writing via viewfs fallback path".getBytes());
        dataOutputStream.close();
        FileStatus level2FileStatAfterWrite = vfs.getFileStatus(new Path(viewFsUri.toString() + testLevel2File.toUri().toString()));
        Assert.assertTrue((String)("Unexpected file length for " + testLevel2File), (level2FileStatAfterWrite.getLen() > level2FileStat.getLen() ? 1 : 0) != 0);
        vfs.close();
    }

    @Test
    public void testConfLinkFallbackWithMountPoint() throws Exception {
        TEST_DIR.mkdirs();
        Configuration conf = new Configuration();
        String clusterName = "ClusterX";
        String mountPoint = "/user";
        URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
        String expectedErrorMsg = "Invalid linkFallback entry in config: linkFallback./user";
        String mountTableEntry = "fs.viewfs.mounttable." + clusterName + "." + "linkFallback" + "." + mountPoint;
        conf.set(mountTableEntry, TEST_DIR.toURI().toString());
        try {
            FileSystem.get((URI)viewFsUri, (Configuration)conf);
            Assert.fail((String)"Shouldn't allow linkMergeSlash to take extra mount points!");
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Unexpected error: " + e.getMessage()), (boolean)e.getMessage().contains(expectedErrorMsg));
        }
    }

    @Test
    public void testListingWithFallbackLink() throws Exception {
        Path dir1 = new Path(this.targetTestRoot, "fallbackDir/dir1");
        this.fsTarget.mkdirs(dir1);
        String clusterName = "default";
        URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
        HashSet<Path> beforeFallback = new HashSet<Path>();
        try (FileSystem vfs = FileSystem.get((URI)viewFsUri, (Configuration)this.conf);){
            for (FileStatus stat : vfs.listStatus(new Path(viewFsUri.toString()))) {
                beforeFallback.add(stat.getPath());
            }
        }
        ConfigUtil.addLinkFallback((Configuration)this.conf, (String)clusterName, (URI)new Path(this.targetTestRoot, "fallbackDir").toUri());
        vfs = FileSystem.get((URI)viewFsUri, (Configuration)this.conf);
        try {
            HashSet<Path> afterFallback = new HashSet<Path>();
            for (FileStatus stat : vfs.listStatus(new Path(viewFsUri.toString()))) {
                afterFallback.add(stat.getPath());
            }
            afterFallback.removeAll(beforeFallback);
            Assert.assertTrue((String)"Listing didn't include fallback link", (afterFallback.size() == 1 ? 1 : 0) != 0);
            Path[] fallbackArray = new Path[afterFallback.size()];
            afterFallback.toArray(fallbackArray);
            Path expected = new Path(viewFsUri.toString(), "dir1");
            Assert.assertEquals((String)"Path did not match", (Object)expected, (Object)fallbackArray[0]);
            Path childDir = new Path(fallbackArray[0], "child");
            vfs.mkdirs(childDir);
            FileStatus status = this.fsTarget.getFileStatus(new Path(dir1, "child"));
            Assert.assertTrue((boolean)status.isDirectory());
            Assert.assertTrue((boolean)vfs.getFileStatus(childDir).isDirectory());
        }
        finally {
            if (vfs != null) {
                vfs.close();
            }
        }
    }

    @Test
    public void testListingWithFallbackLinkWithSameMountDirectories() throws Exception {
        Path dir1 = new Path(this.targetTestRoot, "fallbackDir/user");
        Path dir2 = new Path(this.targetTestRoot, "fallbackDir/user1");
        this.fsTarget.mkdirs(dir1);
        this.fsTarget.mkdirs(dir2);
        String clusterName = "default";
        HashSet<Path> beforeFallback = new HashSet<Path>();
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)this.conf);){
            for (FileStatus stat : vfs.listStatus(new Path(viewFsDefaultClusterUri.toString()))) {
                beforeFallback.add(stat.getPath());
            }
        }
        ConfigUtil.addLinkFallback((Configuration)this.conf, (String)clusterName, (URI)new Path(this.targetTestRoot, "fallbackDir").toUri());
        vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)this.conf);
        try {
            HashSet<Path> afterFallback = new HashSet<Path>();
            for (FileStatus stat : vfs.listStatus(new Path(viewFsDefaultClusterUri.toString()))) {
                afterFallback.add(stat.getPath());
            }
            afterFallback.removeAll(beforeFallback);
            Assert.assertEquals((String)"The same directory name in fallback link should be shaded", (long)1L, (long)afterFallback.size());
            Path[] fallbackArray = new Path[afterFallback.size()];
            Path expected = new Path(viewFsDefaultClusterUri.toString(), "user1");
            Assert.assertEquals((String)"Path did not match", (Object)expected, (Object)afterFallback.toArray(fallbackArray)[0]);
            Path childDir = new Path(fallbackArray[0], "child");
            vfs.mkdirs(childDir);
            FileStatus status = this.fsTarget.getFileStatus(new Path(dir2, "child"));
            Assert.assertTrue((boolean)status.isDirectory());
            Assert.assertTrue((boolean)vfs.getFileStatus(childDir).isDirectory());
        }
        finally {
            if (vfs != null) {
                vfs.close();
            }
        }
    }

    @Test
    public void testListingWithFallbackLinkWithSameMountDirectoryTree() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path dir1 = new Path(this.targetTestRoot, "fallbackDir/user1/hive/warehouse/partition-0");
        Path dir2 = new Path(this.targetTestRoot, "fallbackDir/user1/hive/warehouse1");
        this.fsTarget.mkdirs(dir1);
        this.fsTarget.mkdirs(dir2);
        this.fsTarget.setPermission(new Path(this.targetTestRoot, "fallbackDir/user1/hive/"), FsPermission.valueOf((String)"-rwxr--r--"));
        HashSet<Path> beforeFallback = new HashSet<Path>();
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            for (FileStatus stat : vfs.listStatus(new Path(viewFsDefaultClusterUri.toString(), "/user1/hive/"))) {
                beforeFallback.add(stat.getPath());
            }
        }
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)new Path(this.targetTestRoot, "fallbackDir").toUri());
        vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        try {
            HashSet<Path> afterFallback = new HashSet<Path>();
            for (FileStatus stat : vfs.listStatus(new Path(viewFsDefaultClusterUri.toString(), "/user1/hive/"))) {
                afterFallback.add(stat.getPath());
                if (!dir1.getName().equals(stat.getPath().getName())) continue;
                Assert.assertEquals((Object)FsPermission.valueOf((String)"-rwxr--r--"), (Object)stat.getPermission());
            }
            afterFallback.removeAll(beforeFallback);
            Assert.assertEquals((String)"The same directory name in fallback link should be shaded", (long)1L, (long)afterFallback.size());
        }
        finally {
            if (vfs != null) {
                vfs.close();
            }
        }
    }

    @Test
    public void testLSOnLinkParentWithFallbackLinkWithSameMountDirectoryTree() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path dir1 = new Path(this.targetTestRoot, "fallbackDir/user1/hive/warehouse/partition-0");
        Path dir2 = new Path(this.targetTestRoot, "fallbackDir/user1/hive/warehouse1");
        this.fsTarget.mkdirs(dir1);
        this.fsTarget.mkdirs(dir2);
        this.fsTarget.setPermission(new Path(this.targetTestRoot, "fallbackDir/user1/hive/warehouse/partition-0"), FsPermission.valueOf((String)"-rwxr--r--"));
        this.fsTarget.setPermission(this.targetTestRoot, FsPermission.valueOf((String)"-rwxr--rw-"));
        HashSet<Path> beforeFallback = new HashSet<Path>();
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            for (FileStatus stat : vfs.listStatus(new Path(viewFsDefaultClusterUri.toString(), "/user1/hive/warehouse/"))) {
                beforeFallback.add(stat.getPath());
            }
        }
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)new Path(this.targetTestRoot, "fallbackDir").toUri());
        vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        try {
            HashSet<Path> afterFallback = new HashSet<Path>();
            for (FileStatus stat : vfs.listStatus(new Path(viewFsDefaultClusterUri.toString(), "/user1/hive/warehouse/"))) {
                afterFallback.add(stat.getPath());
                if (!dir1.getName().equals(stat.getPath().getName())) continue;
                Assert.assertEquals((Object)FsPermission.valueOf((String)"-rwxr--rw-"), (Object)stat.getPermission());
            }
            afterFallback.removeAll(beforeFallback);
            Assert.assertEquals((String)"Just to make sure paths are same.", (long)0L, (long)afterFallback.size());
        }
        finally {
            if (vfs != null) {
                vfs.close();
            }
        }
    }

    @Test
    public void testLSOnRootWithFallbackLinkWithSameMountDirectories() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path dir1 = new Path(this.targetTestRoot, "fallbackDir/user1");
        Path dir2 = new Path(this.targetTestRoot, "fallbackDir/user2");
        this.fsTarget.mkdirs(dir1);
        this.fsTarget.mkdirs(dir2, FsPermission.valueOf((String)"-rwxr--r--"));
        this.fsTarget.setPermission(this.targetTestRoot, FsPermission.valueOf((String)"-rwxr--rw-"));
        HashSet<Path> beforeFallback = new HashSet<Path>();
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            for (FileStatus stat : vfs.listStatus(new Path(viewFsDefaultClusterUri.toString(), "/"))) {
                beforeFallback.add(stat.getPath());
            }
        }
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)new Path(this.targetTestRoot, "fallbackDir").toUri());
        vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);
        try {
            HashSet<Path> afterFallback = new HashSet<Path>();
            for (FileStatus stat : vfs.listStatus(new Path(viewFsDefaultClusterUri.toString(), "/"))) {
                afterFallback.add(stat.getPath());
                if (dir1.getName().equals(stat.getPath().getName())) {
                    Assert.assertEquals((Object)FsPermission.valueOf((String)"-rwxr--rw-"), (Object)stat.getPermission());
                    continue;
                }
                Assert.assertEquals((String)("Path is: " + stat.getPath()), (Object)FsPermission.valueOf((String)"-rwxr--r--"), (Object)stat.getPermission());
            }
            afterFallback.removeAll(beforeFallback);
            Assert.assertEquals((long)1L, (long)afterFallback.size());
            Assert.assertEquals((String)"/user2 dir from fallback should be listed.", (Object)"user2", (Object)((Path)afterFallback.iterator().next()).getName());
        }
        finally {
            if (vfs != null) {
                vfs.close();
            }
        }
    }

    @Test
    public void testLSOnLinkParentWhereMountLinkMatchesWithAFileUnderFallback() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", true);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/part-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path file1 = new Path(this.targetTestRoot, "fallbackDir/user1/hive/warehouse/part-0");
        this.fsTarget.createNewFile(file1);
        Path dir2 = new Path(this.targetTestRoot, "fallbackDir/user1/hive/warehouse1");
        this.fsTarget.mkdirs(dir2);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)new Path(this.targetTestRoot, "fallbackDir").toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            for (FileStatus stat : vfs.listStatus(new Path(viewFsDefaultClusterUri.toString(), "/user1/hive/warehouse/"))) {
                if (!file1.getName().equals(stat.getPath().getName())) continue;
                Assert.assertFalse((boolean)stat.isFile());
                Assert.assertFalse((boolean)stat.isDirectory());
                Assert.assertTrue((boolean)stat.isSymlink());
                Path fileUnderDir = new Path(stat.getPath(), "check");
                Assert.assertTrue((boolean)vfs.mkdirs(fileUnderDir));
                Assert.assertTrue((boolean)this.fsTarget.exists(new Path(this.targetTestRoot, fileUnderDir.getName())));
            }
        }
    }

    @Test
    public void testMkdirsOfLinkParentWithFallbackLinkWithSameMountDirectoryTree() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path dir1 = new Path(this.targetTestRoot, "fallbackDir/user1/hive/warehouse/partition-0");
        this.fsTarget.mkdirs(dir1);
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path p = new Path("/user1/hive/warehouse/test");
            Path test = Path.mergePaths((Path)fallbackTarget, (Path)p);
            Assert.assertFalse((boolean)this.fsTarget.exists(test));
            Assert.assertTrue((boolean)vfs.mkdirs(p));
            Assert.assertTrue((boolean)this.fsTarget.exists(test));
        }
    }

    @Test
    public void testMkdirsOfRootWithFallbackLinkAndMountWithSameDirTree() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path dir1 = new Path(this.targetTestRoot, "fallbackDir/user1");
        this.fsTarget.mkdirs(dir1);
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path p = new Path("/");
            Path test = Path.mergePaths((Path)fallbackTarget, (Path)p);
            Assert.assertTrue((boolean)this.fsTarget.exists(test));
            Assert.assertTrue((boolean)vfs.mkdirs(p));
            Assert.assertTrue((boolean)this.fsTarget.exists(test));
        }
    }

    @Test
    public void testMkdirsOfNewDirWithOutMatchingToMountOrFallbackDirTree() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path p = new Path("/user2");
            Path test = Path.mergePaths((Path)fallbackTarget, (Path)p);
            Assert.assertFalse((boolean)this.fsTarget.exists(test));
            Assert.assertTrue((boolean)vfs.mkdirs(p));
            Assert.assertTrue((boolean)this.fsTarget.exists(test));
        }
    }

    @Test
    public void testMkdirsWithFallbackLinkWithMountPathMatchingDirExist() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path immediateLevelToInternalDir = new Path("/user1/test");
            Path test = Path.mergePaths((Path)fallbackTarget, (Path)immediateLevelToInternalDir);
            Assert.assertFalse((boolean)this.fsTarget.exists(test));
            Assert.assertTrue((boolean)vfs.mkdirs(immediateLevelToInternalDir));
            Assert.assertTrue((boolean)this.fsTarget.exists(test));
        }
    }

    @Test
    public void testMkdirsOfDeepTreeWithFallbackLinkAndMountPathMatchingDirExist() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path multipleLevelToInternalDir = new Path("/user1/test/test");
            Path test = Path.mergePaths((Path)fallbackTarget, (Path)multipleLevelToInternalDir);
            Assert.assertFalse((boolean)this.fsTarget.exists(test));
            Assert.assertTrue((boolean)vfs.mkdirs(multipleLevelToInternalDir));
            Assert.assertTrue((boolean)this.fsTarget.exists(test));
        }
    }

    @Test
    public void testMkdirsShouldReturnFalseWhenFallbackFSNotAvailable() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("fs.viewfs.mount.links.as.symlinks", false);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/test", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path nextLevelToInternalDir = new Path("/user1/test1");
            Path test = Path.mergePaths((Path)fallbackTarget, (Path)nextLevelToInternalDir);
            Assert.assertFalse((boolean)this.fsTarget.exists(test));
            Assert.assertNotNull((Object)vfs.getFileStatus(new Path("/user1")));
            Assert.assertFalse((boolean)this.fsTarget.exists(test.getParent()));
            cluster.shutdownNameNodes();
            LambdaTestUtils.intercept(IOException.class, () -> vfs.mkdirs(nextLevelToInternalDir));
            cluster.restartNameNodes();
            Assert.assertTrue((boolean)vfs.mkdirs(nextLevelToInternalDir));
            Assert.assertTrue((boolean)this.fsTarget.exists(test));
        }
    }

    @Test
    public void testCreateFileOnInternalMountDirWithSameDirTreeExistInFallback() throws Exception {
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        Path dir1 = new Path(fallbackTarget, "user1/hive/warehouse/partition-0");
        this.fsTarget.mkdirs(dir1);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path vfsTestFile = new Path("/user1/hive/warehouse/test.file");
            Path testFileInFallback = Path.mergePaths((Path)fallbackTarget, (Path)vfsTestFile);
            Assert.assertFalse((boolean)this.fsTarget.exists(testFileInFallback));
            Assert.assertTrue((boolean)this.fsTarget.exists(testFileInFallback.getParent()));
            vfs.create(vfsTestFile).close();
            Assert.assertTrue((boolean)this.fsTarget.exists(testFileInFallback));
        }
    }

    @Test
    public void testCreateNewFileWithOutMatchingToMountDirOrFallbackDirPath() throws Exception {
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/warehouse/partition-0", (URI)new Path(this.targetTestRoot.toString()).toUri());
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path vfsTestFile = new Path("/user2/test.file");
            Path testFileInFallback = Path.mergePaths((Path)fallbackTarget, (Path)vfsTestFile);
            Assert.assertFalse((boolean)this.fsTarget.exists(testFileInFallback));
            Assert.assertFalse((boolean)this.fsTarget.exists(testFileInFallback.getParent()));
            vfs.create(vfsTestFile).close();
            Assert.assertTrue((boolean)this.fsTarget.exists(testFileInFallback));
        }
    }

    @Test
    public void testCreateFileOnRootWithFallbackEnabled() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path vfsTestFile = new Path("/test.file");
            Path testFileInFallback = Path.mergePaths((Path)fallbackTarget, (Path)vfsTestFile);
            Assert.assertFalse((boolean)this.fsTarget.exists(testFileInFallback));
            vfs.create(vfsTestFile).close();
            Assert.assertTrue((boolean)this.fsTarget.exists(testFileInFallback));
        }
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateFileOnRootWithFallbackWithFileAlreadyExist() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        Path testFile = new Path(fallbackTarget, "test.file");
        this.fsTarget.create(testFile).close();
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path vfsTestFile = new Path("/test.file");
            Assert.assertTrue((boolean)this.fsTarget.exists(testFile));
            vfs.create(vfsTestFile, false).close();
        }
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateFileWhereThePathIsSameAsItsMountLinkPath() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path vfsTestDir = new Path("/user1/hive");
            Assert.assertFalse((boolean)this.fsTarget.exists(Path.mergePaths((Path)fallbackTarget, (Path)vfsTestDir)));
            vfs.create(vfsTestDir).close();
        }
    }

    @Test
    public void testCreateFileSameAsInternalDirPath() throws Exception {
        Configuration conf = new Configuration();
        Path fallbackTarget = new Path(this.targetTestRoot, "fallbackDir");
        this.fsTarget.mkdirs(fallbackTarget);
        ConfigUtil.addLink((Configuration)conf, (String)"/user1/hive/", (URI)new Path(this.targetTestRoot.toString()).toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)fallbackTarget.toUri());
        try (FileSystem vfs = FileSystem.get((URI)viewFsDefaultClusterUri, (Configuration)conf);){
            Path vfsTestDir = new Path("/user1");
            Assert.assertFalse((boolean)this.fsTarget.exists(Path.mergePaths((Path)fallbackTarget, (Path)vfsTestDir)));
            try {
                vfs.create(vfsTestDir);
                Assert.fail((String)"Should fail to create file as this is an internal dir.");
            }
            catch (NotInMountpointException notInMountpointException) {
                // empty catch block
            }
        }
    }

    static {
        FS_HDFS = new FileSystem[3];
        CONF = new Configuration();
        TEST_DIR = GenericTestUtils.getTestDir((String)TestViewFileSystemLinkFallback.class.getSimpleName());
        LOG = LoggerFactory.getLogger(TestViewFileSystemLinkFallback.class);
    }
}

