/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.Closeable;
import java.util.EnumSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestXAttrWithSnapshot {
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static DistributedFileSystem hdfs;
    private static int pathCount;
    private static Path path;
    private static Path snapshotPath;
    private static Path snapshotPath2;
    private static Path snapshotPath3;
    private static String snapshotName;
    private static String snapshotName2;
    private static String snapshotName3;
    private final int SUCCESS = 0;
    private static final String name1 = "user.a1";
    private static final byte[] value1;
    private static final byte[] newValue1;
    private static final String name2 = "user.a2";
    private static final byte[] value2;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void init() throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        TestXAttrWithSnapshot.initCluster(true);
    }

    @AfterClass
    public static void shutdown() throws Exception {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{hdfs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() {
        path = new Path("/p" + ++pathCount);
        snapshotName = "snapshot" + pathCount;
        snapshotName2 = snapshotName + "-2";
        snapshotName3 = snapshotName + "-3";
        snapshotPath = new Path(path, new Path(".snapshot", snapshotName));
        snapshotPath2 = new Path(path, new Path(".snapshot", snapshotName2));
        snapshotPath3 = new Path(path, new Path(".snapshot", snapshotName3));
    }

    @Test(timeout=120000L)
    public void testModifyReadsCurrentState() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        hdfs.setXAttr(path, name1, value1);
        hdfs.setXAttr(path, name2, value2);
        Map xattrs = hdfs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assert.assertEquals((long)xattrs.size(), (long)0L);
        hdfs.setXAttr(path, name1, value2, EnumSet.of(XAttrSetFlag.REPLACE));
        xattrs = hdfs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        hdfs.setXAttr(path, name2, value1, EnumSet.of(XAttrSetFlag.REPLACE));
        xattrs = hdfs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assert.assertEquals((long)xattrs.size(), (long)0L);
        hdfs.removeXAttr(path, name1);
        hdfs.removeXAttr(path, name2);
        xattrs = hdfs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)0L);
    }

    @Test
    public void testXattrWithSnapshotAndNNRestart() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        hdfs.allowSnapshot(path);
        hdfs.createSnapshot(path, snapshotName);
        SnapshotDiffReport report = hdfs.getSnapshotDiffReport(path, snapshotName, "");
        System.out.println(report);
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        report = hdfs.getSnapshotDiffReport(path, snapshotName, "");
        System.out.println(report);
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        hdfs.saveNamespace();
        hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        cluster.restartNameNode(true);
        report = hdfs.getSnapshotDiffReport(path, snapshotName, "");
        System.out.println(report);
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
    }

    @Test(timeout=120000L)
    public void testRemoveReadsCurrentState() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        hdfs.setXAttr(path, name1, value1);
        hdfs.setXAttr(path, name2, value2);
        Map xattrs = hdfs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assert.assertEquals((long)xattrs.size(), (long)0L);
        hdfs.removeXAttr(path, name2);
        xattrs = hdfs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        hdfs.removeXAttr(path, name1);
        xattrs = hdfs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)0L);
    }

    @Test
    public void testXAttrForSnapshotRootAfterChange() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        hdfs.setXAttr(path, name2, value2);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Map xattrs = hdfs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        hdfs.setXAttr(path, name1, newValue1);
        TestXAttrWithSnapshot.doSnapshotRootChangeAssertions(path, snapshotPath);
        TestXAttrWithSnapshot.restart(false);
        TestXAttrWithSnapshot.doSnapshotRootChangeAssertions(path, snapshotPath);
        TestXAttrWithSnapshot.restart(true);
        TestXAttrWithSnapshot.doSnapshotRootChangeAssertions(path, snapshotPath);
    }

    private static void doSnapshotRootChangeAssertions(Path path, Path snapshotPath) throws Exception {
        Map xattrs = hdfs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
    }

    @Test
    public void testXAttrForSnapshotRootAfterRemove() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        hdfs.setXAttr(path, name2, value2);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Map xattrs = hdfs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        hdfs.removeXAttr(path, name1);
        hdfs.removeXAttr(path, name2);
        TestXAttrWithSnapshot.doSnapshotRootRemovalAssertions(path, snapshotPath);
        TestXAttrWithSnapshot.restart(false);
        TestXAttrWithSnapshot.doSnapshotRootRemovalAssertions(path, snapshotPath);
        TestXAttrWithSnapshot.restart(true);
        TestXAttrWithSnapshot.doSnapshotRootRemovalAssertions(path, snapshotPath);
    }

    private static void doSnapshotRootRemovalAssertions(Path path, Path snapshotPath) throws Exception {
        Map xattrs = hdfs.getXAttrs(path);
        Assert.assertEquals((long)0L, (long)xattrs.size());
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assert.assertEquals((long)2L, (long)xattrs.size());
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
    }

    @Test
    public void testSuccessiveSnapshotXAttrChanges() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Map xattrs = hdfs.getXAttrs(snapshotPath);
        Assert.assertEquals((long)1L, (long)xattrs.size());
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        hdfs.setXAttr(path, name1, newValue1);
        hdfs.setXAttr(path, name2, value2);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName2);
        xattrs = hdfs.getXAttrs(snapshotPath2);
        Assert.assertEquals((long)2L, (long)xattrs.size());
        Assert.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        hdfs.setXAttr(path, name1, value1);
        hdfs.removeXAttr(path, name2);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName3);
        xattrs = hdfs.getXAttrs(snapshotPath3);
        Assert.assertEquals((long)1L, (long)xattrs.size());
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assert.assertEquals((long)1L, (long)xattrs.size());
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        xattrs = hdfs.getXAttrs(snapshotPath2);
        Assert.assertEquals((long)2L, (long)xattrs.size());
        Assert.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        hdfs.deleteSnapshot(path, snapshotName2);
        xattrs = hdfs.getXAttrs(snapshotPath);
        Assert.assertEquals((long)1L, (long)xattrs.size());
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        xattrs = hdfs.getXAttrs(snapshotPath3);
        Assert.assertEquals((long)1L, (long)xattrs.size());
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        hdfs.deleteSnapshot(path, snapshotName);
        hdfs.deleteSnapshot(path, snapshotName3);
    }

    @Test
    public void testSetXAttrSnapshotPath() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        this.exception.expect(SnapshotAccessControlException.class);
        hdfs.setXAttr(snapshotPath, name1, value1);
    }

    @Test
    public void testRemoveXAttrSnapshotPath() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        this.exception.expect(SnapshotAccessControlException.class);
        hdfs.removeXAttr(snapshotPath, name1);
    }

    @Test(timeout=120000L)
    public void testCopySnapshotShouldPreserveXAttrs() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        hdfs.setXAttr(path, name1, value1);
        hdfs.setXAttr(path, name2, value2);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Path snapshotCopy = new Path(path.toString() + "-copy");
        String[] argv = new String[]{"-cp", "-px", snapshotPath.toUri().toString(), snapshotCopy.toUri().toString()};
        int ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
        Assert.assertEquals((String)"cp -px is not working on a snapshot", (long)0L, (long)ret);
        Map xattrs = hdfs.getXAttrs(snapshotCopy);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
    }

    private static void initCluster(boolean format) throws Exception {
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
    }

    private static void restart(boolean checkpoint) throws Exception {
        NameNode nameNode = cluster.getNameNode();
        if (checkpoint) {
            NameNodeAdapter.enterSafeMode(nameNode, false);
            NameNodeAdapter.saveNamespace(nameNode);
        }
        TestXAttrWithSnapshot.shutdown();
        TestXAttrWithSnapshot.initCluster(false);
    }

    static {
        pathCount = 0;
        value1 = new byte[]{49, 50, 51};
        newValue1 = new byte[]{49, 49, 49};
        value2 = new byte[]{55, 56, 57};
    }
}

