/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BaseReplicationPolicyTest;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestBlockPlacementPolicyDebugLoggingBuilder
extends BaseReplicationPolicyTest {
    public TestBlockPlacementPolicyDebugLoggingBuilder() {
        this.blockPlacementPolicy = BlockPlacementPolicyDefault.class.getName();
    }

    @Override
    DatanodeDescriptor[] getDatanodeDescriptors(Configuration conf) {
        String[] racks = new String[]{"/d1/r1/n1", "/d1/r1/n2", "/d1/r2/n3"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        return DFSTestUtil.toDatanodeDescriptor(this.storages);
    }

    @Test
    public void testChooseRandomDynamicallyChangeLogger() throws Exception {
        BlockPlacementPolicyDefault repl = (BlockPlacementPolicyDefault)Mockito.spy((Object)((BlockPlacementPolicyDefault)this.replicator));
        GenericTestUtils.setLogLevel((Logger)BlockPlacementPolicy.LOG, (Level)Level.INFO);
        ArrayList<DatanodeStorageInfo> results = new ArrayList<DatanodeStorageInfo>();
        results.add(this.storages[0]);
        results.add(this.storages[1]);
        results.add(this.storages[2]);
        HashSet excludeNodes = new HashSet();
        ((BlockPlacementPolicyDefault)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                GenericTestUtils.setLogLevel((Logger)BlockPlacementPolicy.LOG, (Level)Level.DEBUG);
                return TestBlockPlacementPolicyDebugLoggingBuilder.this.dataNodes[0];
            }
        }).when((Object)repl)).chooseDataNode("/", excludeNodes);
        ((BlockPlacementPolicyDefault)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                GenericTestUtils.setLogLevel((Logger)BlockPlacementPolicy.LOG, (Level)Level.DEBUG);
                return TestBlockPlacementPolicyDebugLoggingBuilder.this.dataNodes[0];
            }
        }).when((Object)repl)).chooseDataNode("/", excludeNodes, StorageType.DISK);
        EnumMap<StorageType, Integer> types = new EnumMap<StorageType, Integer>(StorageType.class);
        types.put(StorageType.DISK, 1);
        repl.chooseRandom(1, "/", excludeNodes, 1024L, 3, results, false, types);
    }
}

