/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hdfs.TestDFSStripedOutputStreamWithFailureBase;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ParameterizedTestDFSStripedOutputStreamWithFailure
extends TestDFSStripedOutputStreamWithFailureBase {
    public static final Logger LOG = LoggerFactory.getLogger(ParameterizedTestDFSStripedOutputStreamWithFailure.class);
    private int base;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (int i = 0; i <= 10; ++i) {
            parameters.add(new Object[]{RANDOM.nextInt(220)});
        }
        return parameters;
    }

    public ParameterizedTestDFSStripedOutputStreamWithFailure(int base) {
        this.base = base;
    }

    @Test(timeout=240000L)
    public void runTestWithSingleFailure() {
        Assume.assumeTrue((this.base >= 0 ? 1 : 0) != 0);
        if (this.base > this.lengths.size()) {
            this.base %= this.lengths.size();
        }
        int i = this.base;
        Integer length = this.getLength(i);
        Assume.assumeTrue((String)("Skip test " + i + " since length=null."), (length != null ? 1 : 0) != 0);
        Assume.assumeTrue((String)("Test " + i + ", length=" + length + ", is not chosen to run."), (RANDOM.nextInt(16) != 0 ? 1 : 0) != 0);
        System.out.println("Run test " + i + ", length=" + length);
        this.runTest(length);
    }
}

