/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class NSQuotaExceededException
extends QuotaExceededException {
    protected static final long serialVersionUID = 1L;
    private String prefix;

    public NSQuotaExceededException() {
    }

    public NSQuotaExceededException(String msg) {
        super(msg);
    }

    public NSQuotaExceededException(long quota, long count) {
        super(quota, count);
    }

    @Override
    public String getMessage() {
        Object msg = super.getMessage();
        if (msg == null) {
            msg = "The NameSpace quota (directories and files)" + (String)(this.pathName == null ? "" : " of directory " + this.pathName) + " is exceeded: quota=" + this.quota + " file count=" + this.count;
            if (this.prefix != null) {
                msg = this.prefix + ": " + (String)msg;
            }
        }
        return msg;
    }

    public void setMessagePrefix(String prefix) {
        this.prefix = prefix;
    }
}

