/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class EncryptionZoneIterator
extends BatchedRemoteIterator<Long, EncryptionZone> {
    private final ClientProtocol namenode;
    private final Tracer tracer;

    public EncryptionZoneIterator(ClientProtocol namenode, Tracer tracer) {
        super((Object)0L);
        this.namenode = namenode;
        this.tracer = tracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> makeRequest(Long prevId) throws IOException {
        try (TraceScope scope = this.tracer.newScope("listEncryptionZones");){
            BatchedRemoteIterator.BatchedEntries<EncryptionZone> batchedEntries = this.namenode.listEncryptionZones(prevId);
            return batchedEntries;
        }
    }

    public Long elementToPrevKey(EncryptionZone entry) {
        return entry.getId();
    }
}

