/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeFormatException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClusterId {
    private static final Logger LOG = LoggerFactory.getLogger(TestClusterId.class);
    File hdfsDir;
    Configuration config;

    private String getClusterId(Configuration config) throws IOException {
        Collection dirsToFormat = FSNamesystem.getNamespaceDirs((Configuration)config);
        List editsToFormat = FSNamesystem.getNamespaceEditsDirs((Configuration)config);
        FSImage fsImage = new FSImage(config, dirsToFormat, editsToFormat);
        Iterator sdit = fsImage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE);
        Storage.StorageDirectory sd = (Storage.StorageDirectory)sdit.next();
        Properties props = Storage.readPropertiesFile((File)sd.getVersionFile());
        String cid = props.getProperty("clusterID");
        LOG.info("successfully formated : sd=" + sd.getCurrentDir() + ";cid=" + cid);
        return cid;
    }

    @Before
    public void setUp() throws IOException {
        ExitUtil.disableSystemExit();
        String baseDir = PathUtils.getTestDirName(this.getClass());
        this.hdfsDir = new File(baseDir, "dfs/name");
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete test directory '" + this.hdfsDir + "'");
        }
        LOG.info("hdfsdir is " + this.hdfsDir.getAbsolutePath());
        HdfsServerConstants.StartupOption.FORMAT.setForceFormat(false);
        HdfsServerConstants.StartupOption.FORMAT.setInteractiveFormat(true);
        this.config = new Configuration();
        this.config.set("dfs.namenode.name.dir", this.hdfsDir.getPath());
    }

    @After
    public void tearDown() throws IOException {
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not tearDown test directory '" + this.hdfsDir + "'");
        }
    }

    @Test
    public void testFormatClusterIdOption() throws IOException {
        NameNode.format((Configuration)this.config);
        String cid = this.getClusterId(this.config);
        Assert.assertTrue((String)"Didn't get new ClusterId", (cid != null && !cid.equals("") ? 1 : 0) != 0);
        HdfsServerConstants.StartupOption.FORMAT.setClusterId("mycluster");
        NameNode.format((Configuration)this.config);
        cid = this.getClusterId(this.config);
        Assert.assertTrue((String)"ClusterId didn't match", (boolean)cid.equals("mycluster"));
        HdfsServerConstants.StartupOption.FORMAT.setClusterId("");
        NameNode.format((Configuration)this.config);
        String newCid = this.getClusterId(this.config);
        Assert.assertFalse((String)"ClusterId should not be the same", (boolean)newCid.equals(cid));
    }

    @Test
    public void testFormat() throws IOException {
        String[] argv = new String[]{"-format"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            Assert.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((String)"Format should have succeeded", (long)0L, (long)e.status);
        }
        String cid = this.getClusterId(this.config);
        Assert.assertTrue((String)"Didn't get new ClusterId", (cid != null && !cid.equals("") ? 1 : 0) != 0);
    }

    @Test
    public void testFormatWithEmptyDir() throws IOException {
        if (!this.hdfsDir.mkdirs()) {
            Assert.fail((String)("Failed to create dir " + this.hdfsDir.getPath()));
        }
        String[] argv = new String[]{"-format"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            Assert.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((String)"Format should have succeeded", (long)0L, (long)e.status);
        }
        String cid = this.getClusterId(this.config);
        Assert.assertTrue((String)"Didn't get new ClusterId", (cid != null && !cid.equals("") ? 1 : 0) != 0);
    }

    @Test
    public void testFormatWithForce() throws IOException {
        if (!this.hdfsDir.mkdirs()) {
            Assert.fail((String)("Failed to create dir " + this.hdfsDir.getPath()));
        }
        String[] argv = new String[]{"-format", "-force"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            Assert.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((String)"Format should have succeeded", (long)0L, (long)e.status);
        }
        String cid = this.getClusterId(this.config);
        Assert.assertTrue((String)"Didn't get new ClusterId", (cid != null && !cid.equals("") ? 1 : 0) != 0);
    }

    @Test
    public void testFormatWithForceAndClusterId() throws IOException {
        if (!this.hdfsDir.mkdirs()) {
            Assert.fail((String)("Failed to create dir " + this.hdfsDir.getPath()));
        }
        String myId = "testFormatWithForceAndClusterId";
        String[] argv = new String[]{"-format", "-force", "-clusterid", myId};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            Assert.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((String)"Format should have succeeded", (long)0L, (long)e.status);
        }
        String cId = this.getClusterId(this.config);
        Assert.assertEquals((String)"ClusterIds do not match", (Object)myId, (Object)cId);
    }

    @Test
    public void testFormatWithInvalidClusterIdOption() throws IOException {
        String[] argv = new String[]{"-format", "-clusterid", "-force"};
        PrintStream origErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stdErr = new PrintStream(baos);
        System.setErr(stdErr);
        NameNode.createNameNode((String[])argv, (Configuration)this.config);
        Assert.assertTrue((boolean)baos.toString("UTF-8").contains("Usage: java NameNode"));
        System.setErr(origErr);
        File version = new File(this.hdfsDir, "current/VERSION");
        Assert.assertFalse((String)"Check version should not exist", (boolean)version.exists());
    }

    @Test
    public void testFormatWithNoClusterIdOption() throws IOException {
        String[] argv = new String[]{"-format", "-clusterid"};
        PrintStream origErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stdErr = new PrintStream(baos);
        System.setErr(stdErr);
        NameNode.createNameNode((String[])argv, (Configuration)this.config);
        Assert.assertTrue((boolean)baos.toString("UTF-8").contains("Usage: java NameNode"));
        System.setErr(origErr);
        File version = new File(this.hdfsDir, "current/VERSION");
        Assert.assertFalse((String)"Check version should not exist", (boolean)version.exists());
    }

    @Test
    public void testFormatWithEmptyClusterIdOption() throws IOException {
        String[] argv = new String[]{"-format", "-clusterid", ""};
        PrintStream origErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stdErr = new PrintStream(baos);
        System.setErr(stdErr);
        NameNode.createNameNode((String[])argv, (Configuration)this.config);
        Assert.assertTrue((boolean)baos.toString("UTF-8").contains("Usage: java NameNode"));
        System.setErr(origErr);
        File version = new File(this.hdfsDir, "current/VERSION");
        Assert.assertFalse((String)"Check version should not exist", (boolean)version.exists());
    }

    @Test
    public void testFormatWithNonInteractive() throws IOException {
        File data = new File(this.hdfsDir, "file");
        if (!data.mkdirs()) {
            Assert.fail((String)("Failed to create dir " + data.getPath()));
        }
        String[] argv = new String[]{"-format", "-nonInteractive"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            Assert.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((String)"Format should have been aborted with exit code 1", (long)1L, (long)e.status);
        }
        File version = new File(this.hdfsDir, "current/VERSION");
        Assert.assertFalse((String)"Check version should not exist", (boolean)version.exists());
    }

    @Test
    public void testFormatWithNonInteractiveNameDirDoesNotExit() throws IOException {
        String[] argv = new String[]{"-format", "-nonInteractive"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            Assert.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((String)"Format should have succeeded", (long)0L, (long)e.status);
        }
        String cid = this.getClusterId(this.config);
        Assert.assertTrue((String)"Didn't get new ClusterId", (cid != null && !cid.equals("") ? 1 : 0) != 0);
    }

    @Test
    public void testFormatWithNonInteractiveAndForce() throws IOException {
        if (!this.hdfsDir.mkdirs()) {
            Assert.fail((String)("Failed to create dir " + this.hdfsDir.getPath()));
        }
        String[] argv = new String[]{"-format", "-nonInteractive", "-force"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            Assert.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((String)"Format should have succeeded", (long)0L, (long)e.status);
        }
        String cid = this.getClusterId(this.config);
        Assert.assertTrue((String)"Didn't get new ClusterId", (cid != null && !cid.equals("") ? 1 : 0) != 0);
    }

    @Test
    public void testFormatWithoutForceEnterYes() throws IOException, InterruptedException {
        File data = new File(this.hdfsDir, "file");
        if (!data.mkdirs()) {
            Assert.fail((String)("Failed to create dir " + data.getPath()));
        }
        InputStream origIn = System.in;
        ByteArrayInputStream bins = new ByteArrayInputStream("Y\n".getBytes());
        System.setIn(bins);
        String[] argv = new String[]{"-format"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            Assert.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((String)"Format should have succeeded", (long)0L, (long)e.status);
        }
        System.setIn(origIn);
        String cid = this.getClusterId(this.config);
        Assert.assertTrue((String)"Didn't get new ClusterId", (cid != null && !cid.equals("") ? 1 : 0) != 0);
    }

    @Test
    public void testFormatWithoutForceEnterNo() throws IOException, InterruptedException {
        File data = new File(this.hdfsDir, "file");
        if (!data.mkdirs()) {
            Assert.fail((String)("Failed to create dir " + data.getPath()));
        }
        InputStream origIn = System.in;
        ByteArrayInputStream bins = new ByteArrayInputStream("N\n".getBytes());
        System.setIn(bins);
        String[] argv = new String[]{"-format"};
        try {
            NameNode.createNameNode((String[])argv, (Configuration)this.config);
            Assert.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((String)"Format should not have succeeded", (long)1L, (long)e.status);
        }
        System.setIn(origIn);
        File version = new File(this.hdfsDir, "current/VERSION");
        Assert.assertFalse((String)"Check version should not exist", (boolean)version.exists());
    }

    @Test
    public void testNNFormatFailure() throws Exception {
        NameNode.initMetrics((Configuration)this.config, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(this.config);
        this.config.setBoolean("dfs.reformat.disabled", true);
        try {
            NameNode.format((Configuration)this.config);
            Assert.fail((String)"NN format should fail.");
        }
        catch (NameNodeFormatException e) {
            GenericTestUtils.assertExceptionContains((String)"NameNode format aborted as reformat is disabled for this cluster", (Throwable)e);
        }
    }

    @Test
    public void testNNFormatSuccess() throws Exception {
        NameNode.initMetrics((Configuration)this.config, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        this.config.setBoolean("dfs.reformat.disabled", true);
        DFSTestUtil.formatNameNode(this.config);
    }
}

