/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageTransactionalStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.Holder;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FSImageTestUtil {
    public static final Logger LOG = LoggerFactory.getLogger(FSImageTestUtil.class);
    private static final long IMAGE_TXID_POS = 24L;

    public static String getFileMD5(File file) throws IOException {
        return MD5FileUtils.computeMd5ForFile((File)file).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageFileMD5IgnoringTxId(File imageFile) throws IOException {
        File tmpFile = File.createTempFile("hadoop_imagefile_tmp", "fsimage");
        tmpFile.deleteOnExit();
        try {
            Files.copy((File)imageFile, (File)tmpFile);
            RandomAccessFile raf = new RandomAccessFile(tmpFile, "rw");
            try {
                raf.seek(24L);
                raf.writeLong(0L);
                raf.close();
                raf = null;
            }
            finally {
                IOUtils.closeStream((Closeable)raf);
            }
            String string = FSImageTestUtil.getFileMD5(tmpFile);
            return string;
        }
        finally {
            tmpFile.delete();
        }
    }

    public static Storage.StorageDirectory mockStorageDirectory(File currentDir, NNStorage.NameNodeDirType type) {
        Storage.StorageDirectory sd = (Storage.StorageDirectory)Mockito.mock(Storage.StorageDirectory.class);
        ((Storage.StorageDirectory)Mockito.doReturn((Object)type).when((Object)sd)).getStorageDirType();
        ((Storage.StorageDirectory)Mockito.doReturn((Object)currentDir).when((Object)sd)).getCurrentDir();
        ((Storage.StorageDirectory)Mockito.doReturn((Object)currentDir).when((Object)sd)).getRoot();
        ((Storage.StorageDirectory)Mockito.doReturn((Object)FSImageTestUtil.mockFile(true)).when((Object)sd)).getVersionFile();
        ((Storage.StorageDirectory)Mockito.doReturn((Object)FSImageTestUtil.mockFile(false)).when((Object)sd)).getPreviousDir();
        return sd;
    }

    static Storage.StorageDirectory mockStorageDirectory(Storage.StorageDirType type, boolean previousExists, String ... fileNames) {
        Storage.StorageDirectory sd = (Storage.StorageDirectory)Mockito.mock(Storage.StorageDirectory.class);
        ((Storage.StorageDirectory)Mockito.doReturn((Object)type).when((Object)sd)).getStorageDirType();
        ((Storage.StorageDirectory)Mockito.doReturn((Object)FSImageTestUtil.mockFile(true)).when((Object)sd)).getVersionFile();
        ((Storage.StorageDirectory)Mockito.doReturn((Object)FSImageTestUtil.mockFile(true)).when((Object)sd)).getRoot();
        ((Storage.StorageDirectory)Mockito.doReturn((Object)FSImageTestUtil.mockFile(previousExists)).when((Object)sd)).getPreviousDir();
        File[] files = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            files[i] = new File(fileNames[i]);
        }
        File mockDir = (File)Mockito.spy((Object)new File("/dir/current"));
        ((File)Mockito.doReturn((Object)files).when((Object)mockDir)).listFiles();
        ((Storage.StorageDirectory)Mockito.doReturn((Object)mockDir).when((Object)sd)).getCurrentDir();
        return sd;
    }

    static File mockFile(boolean exists) {
        File mockFile = (File)Mockito.mock(File.class);
        ((File)Mockito.doReturn((Object)exists).when((Object)mockFile)).exists();
        return mockFile;
    }

    public static FSImageTransactionalStorageInspector inspectStorageDirectory(File dir, NNStorage.NameNodeDirType dirType) throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        inspector.inspectDirectory(FSImageTestUtil.mockStorageDirectory(dir, dirType));
        return inspector;
    }

    public static FSEditLog createStandaloneEditLog(File logDir) throws IOException {
        Assert.assertTrue((logDir.mkdirs() || logDir.exists() ? 1 : 0) != 0);
        if (!FileUtil.fullyDeleteContents((File)logDir)) {
            throw new IOException("Unable to delete contents of " + logDir);
        }
        NNStorage storage = (NNStorage)Mockito.mock(NNStorage.class);
        Storage.StorageDirectory sd = FSImageTestUtil.mockStorageDirectory(logDir, NNStorage.NameNodeDirType.EDITS);
        ArrayList sds = Lists.newArrayList((Object[])new Storage.StorageDirectory[]{sd});
        ((NNStorage)Mockito.doReturn((Object)sds).when((Object)storage)).dirIterable((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS);
        ((NNStorage)Mockito.doReturn((Object)sd).when((Object)storage)).getStorageDirectory((URI)Matchers.anyObject());
        FSEditLog editLog = new FSEditLog(new Configuration(), storage, (List)ImmutableList.of((Object)logDir.toURI()));
        editLog.initJournalsForWrite();
        return editLog;
    }

    public static void createAbortedLogWithMkdirs(File editsLogDir, int numDirs, long firstTxId, long newInodeId) throws IOException {
        FSEditLog editLog = FSImageTestUtil.createStandaloneEditLog(editsLogDir);
        editLog.setNextTxId(firstTxId);
        editLog.openForWrite();
        PermissionStatus perms = PermissionStatus.createImmutable((String)"fakeuser", (String)"fakegroup", (FsPermission)FsPermission.createImmutable((short)493));
        for (int i = 1; i <= numDirs; ++i) {
            String dirName = "dir" + i;
            INodeDirectory dir = new INodeDirectory(newInodeId + (long)i - 1L, DFSUtil.string2Bytes((String)dirName), perms, 0L);
            editLog.logMkDir("/" + dirName, (INode)dir);
        }
        editLog.logSync();
        editLog.abortCurrentLogSegment();
    }

    public static EnumMap<FSEditLogOpCodes, Holder<Integer>> countEditLogOpTypes(File editLog) throws Exception {
        EditLogFileInputStream elis = new EditLogFileInputStream(editLog);
        try {
            EnumMap<FSEditLogOpCodes, Holder<Integer>> enumMap = FSImageTestUtil.countEditLogOpTypes((EditLogInputStream)elis);
            return enumMap;
        }
        finally {
            IOUtils.closeStream((Closeable)elis);
        }
    }

    public static EnumMap<FSEditLogOpCodes, Holder<Integer>> countEditLogOpTypes(EditLogInputStream elis) throws IOException {
        FSEditLogOp op;
        EnumMap<FSEditLogOpCodes, Holder<Integer>> opCounts = new EnumMap<FSEditLogOpCodes, Holder<Integer>>(FSEditLogOpCodes.class);
        while ((op = elis.readOp()) != null) {
            Holder i = opCounts.get(op.opCode);
            if (i == null) {
                i = new Holder((Object)0);
                opCounts.put(op.opCode, (Holder<Integer>)i);
            }
            Holder holder = i;
            Integer n = (Integer)holder.held;
            holder.held = (Integer)holder.held + 1;
            Integer n2 = holder.held;
        }
        return opCounts;
    }

    public static void assertSameNewestImage(List<File> dirs) throws Exception {
        if (dirs.size() < 2) {
            return;
        }
        long imageTxId = -1L;
        ArrayList<File> imageFiles = new ArrayList<File>();
        for (File dir : dirs) {
            FSImageTransactionalStorageInspector inspector = FSImageTestUtil.inspectStorageDirectory(dir, NNStorage.NameNodeDirType.IMAGE);
            List latestImages = inspector.getLatestImages();
            assert (!latestImages.isEmpty());
            long thisTxId = ((FSImageStorageInspector.FSImageFile)latestImages.get(0)).getCheckpointTxId();
            if (imageTxId != -1L && thisTxId != imageTxId) {
                Assert.fail((String)("Storage directory " + dir + " does not have the same last image index " + imageTxId + " as another"));
            }
            imageTxId = thisTxId;
            imageFiles.add(((FSImageStorageInspector.FSImageFile)inspector.getLatestImages().get(0)).getFile());
        }
        FSImageTestUtil.assertFileContentsSame(imageFiles.toArray(new File[0]));
    }

    public static void assertParallelFilesAreIdentical(List<File> dirs, Set<String> ignoredFileNames) throws Exception {
        HashMap<String, ArrayList<File>> groupedByName = new HashMap<String, ArrayList<File>>();
        for (File dir : dirs) {
            for (File f : dir.listFiles()) {
                if (ignoredFileNames.contains(f.getName())) continue;
                ArrayList<File> fileList = (ArrayList<File>)groupedByName.get(f.getName());
                if (fileList == null) {
                    fileList = new ArrayList<File>();
                    groupedByName.put(f.getName(), fileList);
                }
                fileList.add(f);
            }
        }
        for (List sameNameList : groupedByName.values()) {
            if (((File)sameNameList.get(0)).isDirectory()) {
                FSImageTestUtil.assertParallelFilesAreIdentical(sameNameList, ignoredFileNames);
                continue;
            }
            if ("VERSION".equals(((File)sameNameList.get(0)).getName())) {
                FSImageTestUtil.assertPropertiesFilesSame(sameNameList.toArray(new File[0]));
                continue;
            }
            FSImageTestUtil.assertFileContentsSame(sameNameList.toArray(new File[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertPropertiesFilesSame(File[] propFiles) throws IOException {
        Set<Map.Entry<Object, Object>> prevProps = null;
        for (File f : propFiles) {
            Properties props;
            FileInputStream is = new FileInputStream(f);
            try {
                props = new Properties();
                props.load(is);
            }
            finally {
                IOUtils.closeStream((Closeable)is);
            }
            if (prevProps == null) {
                prevProps = props.entrySet();
                continue;
            }
            Sets.SetView diff = Sets.symmetricDifference(prevProps, props.entrySet());
            if (diff.isEmpty()) continue;
            Assert.fail((String)("Properties file " + f + " differs from " + propFiles[0]));
        }
    }

    public static void assertFileContentsSame(File ... files) throws Exception {
        if (files.length < 2) {
            return;
        }
        Map<File, String> md5s = FSImageTestUtil.getFileMD5s(files);
        if (Sets.newHashSet(md5s.values()).size() > 1) {
            Assert.fail((String)("File contents differed:\n  " + Joiner.on((String)"\n  ").withKeyValueSeparator("=").join(md5s)));
        }
    }

    public static void assertFileContentsDifferent(int expectedUniqueHashes, File ... files) throws Exception {
        Map<File, String> md5s = FSImageTestUtil.getFileMD5s(files);
        if (Sets.newHashSet(md5s.values()).size() != expectedUniqueHashes) {
            Assert.fail((String)("Expected " + expectedUniqueHashes + " different hashes, got:\n  " + Joiner.on((String)"\n  ").withKeyValueSeparator("=").join(md5s)));
        }
    }

    public static Map<File, String> getFileMD5s(File ... files) throws Exception {
        HashMap ret = Maps.newHashMap();
        for (File f : files) {
            Assert.assertTrue((String)("Must exist: " + f), (boolean)f.exists());
            ret.put(f, FSImageTestUtil.getFileMD5(f));
        }
        return ret;
    }

    public static List<File> getCurrentDirs(NNStorage storage, NNStorage.NameNodeDirType type) {
        ArrayList ret = Lists.newArrayList();
        for (Storage.StorageDirectory sd : storage.dirIterable((Storage.StorageDirType)type)) {
            ret.add(sd.getCurrentDir());
        }
        return ret;
    }

    public static File findLatestImageFile(Storage.StorageDirectory sd) throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        inspector.inspectDirectory(sd);
        return ((FSImageStorageInspector.FSImageFile)inspector.getLatestImages().get(0)).getFile();
    }

    public static File findNewestImageFile(String currentDirPath) throws IOException {
        Storage.StorageDirectory sd = FSImageTestUtil.mockStorageDirectory(new File(currentDirPath), NNStorage.NameNodeDirType.IMAGE);
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        inspector.inspectDirectory(sd);
        List latestImages = inspector.getLatestImages();
        return latestImages.isEmpty() ? null : ((FSImageStorageInspector.FSImageFile)latestImages.get(0)).getFile();
    }

    public static void assertNNHasCheckpoints(MiniDFSCluster cluster, List<Integer> txids) {
        FSImageTestUtil.assertNNHasCheckpoints(cluster, 0, txids);
    }

    public static void assertNNHasCheckpoints(MiniDFSCluster cluster, int nnIdx, List<Integer> txids) {
        for (File nameDir : FSImageTestUtil.getNameNodeCurrentDirs(cluster, nnIdx)) {
            LOG.info("examining name dir with files: " + Joiner.on((String)",").join((Object[])nameDir.listFiles()));
            LOG.info("Examining storage dir " + nameDir + " with contents: " + StringUtils.join((Object[])nameDir.listFiles(), (String)", "));
            Iterator<Integer> iterator = txids.iterator();
            while (iterator.hasNext()) {
                long checkpointTxId = iterator.next().intValue();
                File image = new File(nameDir, NNStorage.getImageFileName((long)checkpointTxId));
                Assert.assertTrue((String)("Expected non-empty " + image), (image.length() > 0L ? 1 : 0) != 0);
            }
        }
    }

    public static List<File> getNameNodeCurrentDirs(MiniDFSCluster cluster, int nnIdx) {
        ArrayList nameDirs = Lists.newArrayList();
        for (URI u : cluster.getNameDirs(nnIdx)) {
            nameDirs.add(new File(u.getPath(), "current"));
        }
        return nameDirs;
    }

    public static FileJournalManager.EditLogFile findLatestEditsLog(Storage.StorageDirectory sd) throws IOException {
        File currentDir = sd.getCurrentDir();
        ArrayList foundEditLogs = Lists.newArrayList((Iterable)FileJournalManager.matchEditLogs((File)currentDir));
        return (FileJournalManager.EditLogFile)Collections.max(foundEditLogs, FileJournalManager.EditLogFile.COMPARE_BY_START_TXID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void corruptVersionFile(File versionFile, String key, String value) throws IOException {
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(versionFile);
        FileOutputStream out = null;
        try {
            props.load(fis);
            IOUtils.closeStream((Closeable)fis);
            if (value == null || value.isEmpty()) {
                props.remove(key);
            } else {
                props.setProperty(key, value);
            }
            out = new FileOutputStream(versionFile);
            props.store(out, null);
            out.close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream((Closeable)fis);
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)fis);
        IOUtils.closeStream((Closeable)out);
    }

    public static void assertReasonableNameCurrentDir(File curDir) throws IOException {
        Assert.assertTrue((boolean)curDir.isDirectory());
        Assert.assertTrue((boolean)new File(curDir, "VERSION").isFile());
        Assert.assertTrue((boolean)new File(curDir, "seen_txid").isFile());
        File image = FSImageTestUtil.findNewestImageFile(curDir.toString());
        Assert.assertNotNull((Object)image);
    }

    public static void logStorageContents(Logger LOG, NNStorage storage) {
        LOG.info("current storages and corresponding sizes:");
        for (Storage.StorageDirectory sd : storage.dirIterable(null)) {
            File curDir = sd.getCurrentDir();
            LOG.info("In directory " + curDir);
            Object[] files = curDir.listFiles();
            Arrays.sort(files);
            for (Object f : files) {
                LOG.info("  file " + ((File)f).getAbsolutePath() + "; len = " + ((File)f).length());
            }
        }
    }

    public static FSImage getFSImage(NameNode node) {
        return node.getFSImage();
    }

    public static long getNSQuota(FSNamesystem ns) {
        return ns.dir.rootDir.getQuotaCounts().getNameSpace();
    }

    public static void assertNNFilesMatch(MiniDFSCluster cluster) throws Exception {
        ArrayList curDirs = Lists.newArrayList();
        curDirs.addAll(FSImageTestUtil.getNameNodeCurrentDirs(cluster, 0));
        curDirs.addAll(FSImageTestUtil.getNameNodeCurrentDirs(cluster, 1));
        ImmutableSet ignoredFiles = ImmutableSet.of((Object)"seen_txid");
        FSImageTestUtil.assertParallelFilesAreIdentical(curDirs, (Set<String>)ignoredFiles);
    }
}

