/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestBlockRecovery {
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockRecovery.class);
    private static final String DATA_DIR = MiniDFSCluster.getBaseDirectory() + "data";
    private DataNode dn;
    private Configuration conf;
    private static final long RECOVERY_ID = 3000L;
    private static final String CLUSTER_ID = "testClusterID";
    private static final String POOL_ID = "BP-TEST";
    private static final InetSocketAddress NN_ADDR = new InetSocketAddress("localhost", 5020);
    private static final long BLOCK_ID = 1000L;
    private static final long GEN_STAMP = 2000L;
    private static final long BLOCK_LEN = 3000L;
    private static final long REPLICA_LEN1 = 6000L;
    private static final long REPLICA_LEN2 = 5000L;
    private static final ExtendedBlock block = new ExtendedBlock("BP-TEST", 1000L, 3000L, 2000L);
    private static final BlockRecoveryCommand.RecoveringBlock rBlock;

    @Before
    public void startUp() throws IOException, URISyntaxException {
        this.conf = new HdfsConfiguration();
        this.conf.set("dfs.datanode.data.dir", DATA_DIR);
        this.conf.set("dfs.datanode.address", "0.0.0.0:0");
        this.conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        this.conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        this.conf.setInt("ipc.client.connect.max.retries", 0);
        FileSystem.setDefaultUri((Configuration)this.conf, (String)("hdfs://" + NN_ADDR.getHostName() + ":" + NN_ADDR.getPort()));
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>();
        File dataDir = new File(DATA_DIR);
        FileUtil.fullyDelete((File)dataDir);
        dataDir.mkdirs();
        StorageLocation location = StorageLocation.parse((String)dataDir.getPath());
        locations.add(location);
        final DatanodeProtocolClientSideTranslatorPB namenode = (DatanodeProtocolClientSideTranslatorPB)Mockito.mock(DatanodeProtocolClientSideTranslatorPB.class);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)new Answer<DatanodeRegistration>(){

            public DatanodeRegistration answer(InvocationOnMock invocation) throws Throwable {
                return (DatanodeRegistration)invocation.getArguments()[0];
            }
        }).when((Object)namenode)).registerDatanode((DatanodeRegistration)Mockito.any(DatanodeRegistration.class));
        Mockito.when((Object)namenode.versionRequest()).thenReturn((Object)new NamespaceInfo(1, CLUSTER_ID, POOL_ID, 1L));
        Mockito.when((Object)namenode.sendHeartbeat((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(VolumeFailureSummary.class))).thenReturn((Object)new HeartbeatResponse(new DatanodeCommand[0], new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 1L), null));
        this.dn = new DataNode(this.conf, locations, null){

            DatanodeProtocolClientSideTranslatorPB connectToNN(InetSocketAddress nnAddr) throws IOException {
                Assert.assertEquals((Object)NN_ADDR, (Object)nnAddr);
                return namenode;
            }
        };
        this.dn.getAllBpOs()[0].triggerHeartbeatForTests();
    }

    @After
    public void tearDown() throws IOException {
        if (this.dn != null) {
            try {
                this.dn.shutdown();
            }
            catch (Exception e) {
                LOG.error("Cannot close: ", (Throwable)e);
            }
            finally {
                File dir = new File(DATA_DIR);
                if (dir.exists()) {
                    Assert.assertTrue((String)"Cannot delete data-node dirs", (boolean)FileUtil.fullyDelete((File)dir));
                }
            }
        }
    }

    private void testSyncReplicas(ReplicaRecoveryInfo replica1, ReplicaRecoveryInfo replica2, InterDatanodeProtocol dn1, InterDatanodeProtocol dn2, long expectLen) throws IOException {
        DatanodeInfo[] locs = new DatanodeInfo[]{(DatanodeInfo)Mockito.mock(DatanodeInfo.class), (DatanodeInfo)Mockito.mock(DatanodeInfo.class)};
        BlockRecoveryCommand.RecoveringBlock rBlock = new BlockRecoveryCommand.RecoveringBlock(block, locs, 3000L);
        ArrayList<DataNode.BlockRecord> syncList = new ArrayList<DataNode.BlockRecord>(2);
        DataNode.BlockRecord record1 = new DataNode.BlockRecord((DatanodeID)DFSTestUtil.getDatanodeInfo("1.2.3.4", "bogus", 1234), dn1, replica1);
        DataNode.BlockRecord record2 = new DataNode.BlockRecord((DatanodeID)DFSTestUtil.getDatanodeInfo("1.2.3.4", "bogus", 1234), dn2, replica2);
        syncList.add(record1);
        syncList.add(record2);
        Mockito.when((Object)dn1.updateReplicaUnderRecovery((ExtendedBlock)Matchers.anyObject(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyLong())).thenReturn((Object)"storage1");
        Mockito.when((Object)dn2.updateReplicaUnderRecovery((ExtendedBlock)Matchers.anyObject(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyLong())).thenReturn((Object)"storage2");
        this.dn.syncBlock(rBlock, syncList);
    }

    @Test
    public void testFinalizedReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 6000L, 1998L, HdfsServerConstants.ReplicaState.FINALIZED);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        replica2 = new ReplicaRecoveryInfo(1000L, 5000L, 1998L, HdfsServerConstants.ReplicaState.FINALIZED);
        try {
            this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
            Assert.fail((String)"Two finalized replicas should not have different lengthes!");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Inconsistent size of finalized replicas. "));
        }
    }

    @Test
    public void testFinalizedRbwReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 6000L, 1998L, HdfsServerConstants.ReplicaState.RBW);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        replica2 = new ReplicaRecoveryInfo(1000L, 5000L, 1998L, HdfsServerConstants.ReplicaState.RBW);
        dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2, (VerificationMode)Mockito.never())).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
    }

    @Test
    public void testFinalizedRwrReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 6000L, 1998L, HdfsServerConstants.ReplicaState.RWR);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2, (VerificationMode)Mockito.never())).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.FINALIZED);
        replica2 = new ReplicaRecoveryInfo(1000L, 5000L, 1998L, HdfsServerConstants.ReplicaState.RBW);
        dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2, (VerificationMode)Mockito.never())).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
    }

    @Test
    public void testRBWReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.RBW);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 5000L, 1998L, HdfsServerConstants.ReplicaState.RBW);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        long minLen = Math.min(6000L, 5000L);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, minLen);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, minLen);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2)).updateReplicaUnderRecovery(block, 3000L, 1000L, minLen);
    }

    @Test
    public void testRBW_RWRReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.RBW);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 6000L, 1998L, HdfsServerConstants.ReplicaState.RWR);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2, (VerificationMode)Mockito.never())).updateReplicaUnderRecovery(block, 3000L, 1000L, 6000L);
    }

    @Test
    public void testRWRReplicas() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        ReplicaRecoveryInfo replica1 = new ReplicaRecoveryInfo(1000L, 6000L, 1999L, HdfsServerConstants.ReplicaState.RWR);
        ReplicaRecoveryInfo replica2 = new ReplicaRecoveryInfo(1000L, 5000L, 1998L, HdfsServerConstants.ReplicaState.RWR);
        InterDatanodeProtocol dn1 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        InterDatanodeProtocol dn2 = (InterDatanodeProtocol)Mockito.mock(InterDatanodeProtocol.class);
        long minLen = Math.min(6000L, 5000L);
        this.testSyncReplicas(replica1, replica2, dn1, dn2, minLen);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn1)).updateReplicaUnderRecovery(block, 3000L, 1000L, minLen);
        ((InterDatanodeProtocol)Mockito.verify((Object)dn2)).updateReplicaUnderRecovery(block, 3000L, 1000L, minLen);
    }

    private Collection<BlockRecoveryCommand.RecoveringBlock> initRecoveringBlocks() throws IOException {
        ArrayList<BlockRecoveryCommand.RecoveringBlock> blocks = new ArrayList<BlockRecoveryCommand.RecoveringBlock>(1);
        DatanodeInfo mockOtherDN = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] locs = new DatanodeInfo[]{new DatanodeInfo((DatanodeID)this.dn.getDNRegistrationForBP(block.getBlockPoolId())), mockOtherDN};
        BlockRecoveryCommand.RecoveringBlock rBlock = new BlockRecoveryCommand.RecoveringBlock(block, locs, 3000L);
        blocks.add(rBlock);
        return blocks;
    }

    @Test
    public void testRecoveryInProgressException() throws IOException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        DataNode spyDN = (DataNode)Mockito.spy((Object)this.dn);
        ((DataNode)Mockito.doThrow((Throwable)new RecoveryInProgressException("Replica recovery is in progress")).when((Object)spyDN)).initReplicaRecovery((BlockRecoveryCommand.RecoveringBlock)Matchers.any(BlockRecoveryCommand.RecoveringBlock.class));
        Daemon d = spyDN.recoverBlocks("fake NN", this.initRecoveringBlocks());
        d.join();
        ((DataNode)Mockito.verify((Object)spyDN, (VerificationMode)Mockito.never())).syncBlock((BlockRecoveryCommand.RecoveringBlock)Matchers.any(BlockRecoveryCommand.RecoveringBlock.class), Matchers.anyListOf(DataNode.BlockRecord.class));
    }

    @Test
    public void testErrorReplicas() throws IOException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        DataNode spyDN = (DataNode)Mockito.spy((Object)this.dn);
        ((DataNode)Mockito.doThrow((Throwable)new IOException()).when((Object)spyDN)).initReplicaRecovery((BlockRecoveryCommand.RecoveringBlock)Matchers.any(BlockRecoveryCommand.RecoveringBlock.class));
        Daemon d = spyDN.recoverBlocks("fake NN", this.initRecoveringBlocks());
        d.join();
        ((DataNode)Mockito.verify((Object)spyDN, (VerificationMode)Mockito.never())).syncBlock((BlockRecoveryCommand.RecoveringBlock)Matchers.any(BlockRecoveryCommand.RecoveringBlock.class), Matchers.anyListOf(DataNode.BlockRecord.class));
    }

    @Test
    public void testZeroLenReplicas() throws IOException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        DataNode spyDN = (DataNode)Mockito.spy((Object)this.dn);
        ((DataNode)Mockito.doReturn((Object)new ReplicaRecoveryInfo(block.getBlockId(), 0L, block.getGenerationStamp(), HdfsServerConstants.ReplicaState.FINALIZED)).when((Object)spyDN)).initReplicaRecovery((BlockRecoveryCommand.RecoveringBlock)Matchers.any(BlockRecoveryCommand.RecoveringBlock.class));
        Daemon d = spyDN.recoverBlocks("fake NN", this.initRecoveringBlocks());
        d.join();
        DatanodeProtocolClientSideTranslatorPB dnP = this.dn.getActiveNamenodeForBP(POOL_ID);
        ((DatanodeProtocol)Mockito.verify((Object)dnP)).commitBlockSynchronization(block, 3000L, 0L, true, true, DatanodeID.EMPTY_ARRAY, null);
    }

    private List<DataNode.BlockRecord> initBlockRecords(DataNode spyDN) throws IOException {
        ArrayList<DataNode.BlockRecord> blocks = new ArrayList<DataNode.BlockRecord>(1);
        DatanodeRegistration dnR = this.dn.getDNRegistrationForBP(block.getBlockPoolId());
        DataNode.BlockRecord blockRecord = new DataNode.BlockRecord(new DatanodeID((DatanodeID)dnR), (InterDatanodeProtocol)spyDN, new ReplicaRecoveryInfo(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp(), HdfsServerConstants.ReplicaState.FINALIZED));
        blocks.add(blockRecord);
        return blocks;
    }

    @Test
    public void testFailedReplicaUpdate() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        DataNode spyDN = (DataNode)Mockito.spy((Object)this.dn);
        ((DataNode)Mockito.doThrow((Throwable)new IOException()).when((Object)spyDN)).updateReplicaUnderRecovery(block, 3000L, 1000L, block.getNumBytes());
        try {
            spyDN.syncBlock(rBlock, this.initBlockRecords(spyDN));
            Assert.fail((String)"Sync should fail");
        }
        catch (IOException e) {
            e.getMessage().startsWith("Cannot recover ");
        }
    }

    @Test
    public void testNoReplicaUnderRecovery() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        this.dn.data.createRbw(StorageType.DEFAULT, block, false);
        try {
            this.dn.syncBlock(rBlock, this.initBlockRecords(this.dn));
            Assert.fail((String)"Sync should fail");
        }
        catch (IOException e) {
            e.getMessage().startsWith("Cannot recover ");
        }
        DatanodeProtocolClientSideTranslatorPB namenode = this.dn.getActiveNamenodeForBP(POOL_ID);
        ((DatanodeProtocol)Mockito.verify((Object)namenode, (VerificationMode)Mockito.never())).commitBlockSynchronization((ExtendedBlock)Matchers.any(ExtendedBlock.class), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyBoolean(), Matchers.anyBoolean(), (DatanodeID[])Matchers.any(DatanodeID[].class), (String[])Matchers.any(String[].class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotMatchedReplicaID() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + GenericTestUtils.getMethodName());
        }
        ReplicaInPipelineInterface replicaInfo = this.dn.data.createRbw(StorageType.DEFAULT, block, false).getReplica();
        try (ReplicaOutputStreams streams = null;){
            streams = replicaInfo.createStreams(true, DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)512));
            streams.getChecksumOut().write(97);
            this.dn.data.initReplicaRecovery(new BlockRecoveryCommand.RecoveringBlock(block, null, 3001L));
            try {
                this.dn.syncBlock(rBlock, this.initBlockRecords(this.dn));
                Assert.fail((String)"Sync should fail");
            }
            catch (IOException e) {
                e.getMessage().startsWith("Cannot recover ");
            }
            DatanodeProtocolClientSideTranslatorPB namenode = this.dn.getActiveNamenodeForBP(POOL_ID);
            ((DatanodeProtocol)Mockito.verify((Object)namenode, (VerificationMode)Mockito.never())).commitBlockSynchronization((ExtendedBlock)Matchers.any(ExtendedBlock.class), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyBoolean(), Matchers.anyBoolean(), (DatanodeID[])Matchers.any(DatanodeID[].class), (String[])Matchers.any(String[].class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testRaceBetweenReplicaRecoveryAndFinalizeBlock() throws Exception {
        this.tearDown();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.xceiver.stop.timeout.millis", "1000");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/test");
            FSDataOutputStream out = fs.create(path);
            out.writeBytes("data");
            out.hsync();
            List<LocatedBlock> blocks = DFSTestUtil.getAllBlocks(fs.open(path));
            final LocatedBlock block = blocks.get(0);
            final DataNode dataNode = cluster.getDataNodes().get(0);
            final AtomicBoolean recoveryInitResult = new AtomicBoolean(true);
            Thread recoveryThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DatanodeInfo[] locations = block.getLocations();
                        BlockRecoveryCommand.RecoveringBlock recoveringBlock = new BlockRecoveryCommand.RecoveringBlock(block.getBlock(), locations, block.getBlock().getGenerationStamp() + 1L);
                        FsDatasetSpi fsDatasetSpi = dataNode.data;
                        synchronized (fsDatasetSpi) {
                            Thread.sleep(2000L);
                            dataNode.initReplicaRecovery(recoveringBlock);
                        }
                    }
                    catch (Exception e) {
                        recoveryInitResult.set(false);
                    }
                }
            };
            recoveryThread.start();
            try {
                out.close();
            }
            catch (IOException e) {
                Assert.assertTrue((String)"Writing should fail", (boolean)e.getMessage().contains("are bad. Aborting..."));
            }
            finally {
                recoveryThread.join();
            }
            Assert.assertTrue((String)"Recovery should be initiated successfully", (boolean)recoveryInitResult.get());
            dataNode.updateReplicaUnderRecovery(block.getBlock(), block.getBlock().getGenerationStamp() + 1L, block.getBlock().getBlockId(), block.getBlockSize());
        }
        finally {
            if (null != cluster) {
                cluster.shutdown();
                cluster = null;
            }
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)FSNamesystem.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)LOG, (Level)Level.TRACE);
        rBlock = new BlockRecoveryCommand.RecoveringBlock(block, null, 3000L);
    }
}

