/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.BackupNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.test.PathUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHDFSServerPorts {
    public static final Logger LOG = LoggerFactory.getLogger(TestHDFSServerPorts.class);
    static final String THIS_HOST = TestHDFSServerPorts.getFullHostName() + ":0";
    private static final File TEST_DATA_DIR = PathUtils.getTestDir(TestHDFSServerPorts.class);
    Configuration config;
    File hdfsDir;

    public static String getFullHostName() {
        try {
            return DNS.getDefaultHost((String)"default");
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to determine hostname.  May interfere with obtaining valid test results.");
            return "127.0.0.1";
        }
    }

    public NameNode startNameNode() throws IOException {
        return this.startNameNode(false);
    }

    public NameNode startNameNode(boolean withService) throws IOException {
        this.hdfsDir = new File(TEST_DATA_DIR, "dfs");
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.hdfsDir + "'");
        }
        this.config = new HdfsConfiguration();
        this.config.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name1")).toString());
        FileSystem.setDefaultUri((Configuration)this.config, (String)("hdfs://" + THIS_HOST));
        if (withService) {
            NameNode.setServiceAddress((Configuration)this.config, (String)THIS_HOST);
        }
        this.config.set("dfs.namenode.http-address", THIS_HOST);
        DFSTestUtil.formatNameNode(this.config);
        String[] args = new String[]{};
        return NameNode.createNameNode((String[])args, (Configuration)this.config);
    }

    public BackupNode startBackupNode(Configuration conf) throws IOException {
        this.hdfsDir = new File(TEST_DATA_DIR, "backupNode");
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.hdfsDir + "'");
        }
        File currDir = new File(this.hdfsDir, "name2");
        File currDir2 = new File(currDir, "current");
        File currDir3 = new File(currDir, "image");
        Assert.assertTrue((boolean)currDir.mkdirs());
        Assert.assertTrue((boolean)currDir2.mkdirs());
        Assert.assertTrue((boolean)currDir3.mkdirs());
        conf.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name2")).toString());
        conf.set("dfs.namenode.edits.dir", "${dfs.namenode.name.dir}");
        String[] args = new String[]{HdfsServerConstants.StartupOption.BACKUP.getName()};
        BackupNode bu = (BackupNode)NameNode.createNameNode((String[])args, (Configuration)conf);
        return bu;
    }

    public DataNode startDataNode(int index, Configuration config) throws IOException {
        File dataNodeDir = new File(TEST_DATA_DIR, "data-" + index);
        config.set("dfs.datanode.data.dir", dataNodeDir.getPath());
        String[] args = new String[]{};
        return DataNode.createDataNode((String[])args, (Configuration)config);
    }

    public void stopDataNode(DataNode dn) {
        if (dn != null) {
            dn.shutdown();
        }
    }

    public void stopNameNode(NameNode nn) {
        if (nn != null) {
            nn.stop();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    private boolean canStartNameNode(Configuration conf) throws IOException {
        NameNode nn2 = null;
        try {
            nn2 = NameNode.createNameNode((String[])new String[0], (Configuration)conf);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            this.stopNameNode(nn2);
        }
        return true;
    }

    private boolean canStartDataNode(Configuration conf) throws IOException {
        DataNode dn = null;
        try {
            dn = DataNode.createDataNode((String[])new String[0], (Configuration)conf);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (dn != null) {
                dn.shutdown();
            }
        }
        return true;
    }

    private boolean canStartSecondaryNode(Configuration conf) throws IOException {
        SecondaryNameNode sn = null;
        try {
            sn = new SecondaryNameNode(conf);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (sn != null) {
                sn.shutdown();
            }
        }
        return true;
    }

    private boolean canStartBackupNode(Configuration conf) throws IOException {
        BackupNode bn = null;
        try {
            bn = this.startBackupNode(conf);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (bn != null) {
                bn.stop();
            }
        }
        return true;
    }

    @Test(timeout=300000L)
    public void testNameNodePorts() throws Exception {
        this.runTestNameNodePorts(false);
        this.runTestNameNodePorts(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestNameNodePorts(boolean withService) throws Exception {
        NameNode nn = null;
        try {
            nn = this.startNameNode(withService);
            HdfsConfiguration conf2 = new HdfsConfiguration(this.config);
            conf2.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name2")).toString());
            DFSTestUtil.formatNameNode((Configuration)conf2);
            boolean started = this.canStartNameNode((Configuration)conf2);
            Assert.assertFalse((boolean)started);
            FileSystem.setDefaultUri((Configuration)conf2, (String)("hdfs://" + THIS_HOST));
            started = this.canStartNameNode((Configuration)conf2);
            Assert.assertFalse((boolean)started);
            FileSystem.setDefaultUri((Configuration)conf2, (String)("hdfs://" + THIS_HOST));
            conf2.set("dfs.namenode.http-address", THIS_HOST);
            started = this.canStartNameNode((Configuration)conf2);
            if (withService) {
                Assert.assertFalse((String)"Should've failed on service port", (boolean)started);
                FileSystem.setDefaultUri((Configuration)conf2, (String)("hdfs://" + THIS_HOST));
                conf2.set("dfs.namenode.http-address", THIS_HOST);
                conf2.set("dfs.namenode.servicerpc-address", THIS_HOST);
                started = this.canStartNameNode((Configuration)conf2);
            }
            Assert.assertTrue((boolean)started);
        }
        finally {
            this.stopNameNode(nn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testDataNodePorts() throws Exception {
        NameNode nn = null;
        try {
            nn = this.startNameNode();
            HdfsConfiguration conf2 = new HdfsConfiguration(this.config);
            conf2.set("dfs.datanode.data.dir", new File(this.hdfsDir, "data").getPath());
            conf2.set("dfs.datanode.address", FileSystem.getDefaultUri((Configuration)this.config).getAuthority());
            conf2.set("dfs.datanode.http.address", THIS_HOST);
            boolean started = this.canStartDataNode((Configuration)conf2);
            Assert.assertFalse((boolean)started);
            conf2.set("dfs.datanode.address", THIS_HOST);
            conf2.set("dfs.datanode.http.address", this.config.get("dfs.namenode.http-address"));
            started = this.canStartDataNode((Configuration)conf2);
            Assert.assertFalse((boolean)started);
            conf2.set("dfs.datanode.address", THIS_HOST);
            conf2.set("dfs.datanode.http.address", THIS_HOST);
            conf2.set("dfs.datanode.ipc.address", THIS_HOST);
            started = this.canStartDataNode((Configuration)conf2);
            Assert.assertTrue((boolean)started);
        }
        finally {
            this.stopNameNode(nn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSecondaryNodePorts() throws Exception {
        NameNode nn = null;
        try {
            nn = this.startNameNode();
            HdfsConfiguration conf2 = new HdfsConfiguration(this.config);
            conf2.set("dfs.namenode.secondary.http-address", this.config.get("dfs.namenode.http-address"));
            LOG.info("= Starting 1 on: " + conf2.get("dfs.namenode.secondary.http-address"));
            boolean started = this.canStartSecondaryNode((Configuration)conf2);
            Assert.assertFalse((boolean)started);
            conf2.set("dfs.namenode.secondary.http-address", THIS_HOST);
            LOG.info("= Starting 2 on: " + conf2.get("dfs.namenode.secondary.http-address"));
            started = this.canStartSecondaryNode((Configuration)conf2);
            Assert.assertTrue((boolean)started);
        }
        finally {
            this.stopNameNode(nn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testBackupNodePorts() throws Exception {
        NameNode nn = null;
        try {
            nn = this.startNameNode();
            HdfsConfiguration backup_config = new HdfsConfiguration(this.config);
            backup_config.set("dfs.namenode.backup.address", THIS_HOST);
            backup_config.set("dfs.namenode.backup.http-address", backup_config.get("dfs.namenode.http-address"));
            LOG.info("= Starting 1 on: " + backup_config.get("dfs.namenode.backup.http-address"));
            Assert.assertFalse((String)"Backup started on same port as Namenode", (boolean)this.canStartBackupNode((Configuration)backup_config));
            backup_config.set("dfs.namenode.backup.http-address", THIS_HOST);
            LOG.info("= Starting 2 on: " + backup_config.get("dfs.namenode.backup.http-address"));
            boolean started = this.canStartBackupNode((Configuration)backup_config);
            Assert.assertTrue((String)"Backup Namenode should've started", (boolean)started);
        }
        finally {
            this.stopNameNode(nn);
        }
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }
}

