/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.TokenVerifier;
import org.apache.hadoop.hdfs.server.federation.metrics.NamenodeBeanMetrics;
import org.apache.hadoop.hdfs.server.federation.metrics.RBFMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.MountTableRefresherService;
import org.apache.hadoop.hdfs.server.federation.router.NamenodeHeartbeatService;
import org.apache.hadoop.hdfs.server.federation.router.RouterAdminServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterHeartbeatService;
import org.apache.hadoop.hdfs.server.federation.router.RouterHttpServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterMetrics;
import org.apache.hadoop.hdfs.server.federation.router.RouterMetricsService;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaManager;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUpdateService;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterSafemodeService;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.RouterStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Router
extends CompositeService
implements TokenVerifier<DelegationTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(Router.class);
    private Configuration conf;
    private String routerId;
    private RouterRpcServer rpcServer;
    private InetSocketAddress rpcAddress;
    private RouterAdminServer adminServer;
    private InetSocketAddress adminAddress;
    private RouterHttpServer httpServer;
    private StateStoreService stateStore;
    private FileSubclusterResolver subclusterResolver;
    private ActiveNamenodeResolver namenodeResolver;
    private Collection<NamenodeHeartbeatService> namenodeHeartbeatServices;
    private RouterMetricsService metrics;
    private JvmPauseMonitor pauseMonitor;
    private RouterQuotaUpdateService quotaUpdateService;
    private RouterQuotaManager quotaManager;
    private RouterStore routerStateManager;
    private RouterHeartbeatService routerHeartbeatService;
    private RouterSafemodeService safemodeService;
    private final long startTime = Time.now();
    private RouterServiceState state = RouterServiceState.UNINITIALIZED;

    public Router() {
        super(Router.class.getName());
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        boolean isRouterHeartbeatEnabled;
        boolean isNamenodeHeartbeatEnable;
        this.conf = configuration;
        this.updateRouterState(RouterServiceState.INITIALIZING);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        SecurityUtil.login((Configuration)this.conf, (String)"dfs.federation.router.keytab.file", (String)"dfs.federation.router.kerberos.principal", (String)Router.getHostName(this.conf));
        if (this.conf.getBoolean("dfs.federation.router.store.enable", true)) {
            this.stateStore = new StateStoreService();
            this.addService((Service)this.stateStore);
        }
        this.namenodeResolver = FederationUtil.newActiveNamenodeResolver(this.conf, this.stateStore);
        if (this.namenodeResolver == null) {
            throw new IOException("Cannot find namenode resolver.");
        }
        this.subclusterResolver = FederationUtil.newFileSubclusterResolver(this.conf, this);
        if (this.subclusterResolver == null) {
            throw new IOException("Cannot find subcluster resolver");
        }
        if (this.conf.getBoolean("dfs.federation.router.rpc.enable", true)) {
            this.rpcServer = this.createRpcServer();
            this.addService((Service)this.rpcServer);
            this.setRpcServerAddress(this.rpcServer.getRpcAddress());
        }
        if (this.conf.getBoolean("dfs.federation.router.admin.enable", true)) {
            this.adminServer = this.createAdminServer();
            this.addService((Service)this.adminServer);
        }
        if (this.conf.getBoolean("dfs.federation.router.http.enable", true)) {
            this.httpServer = this.createHttpServer();
            this.addService((Service)this.httpServer);
        }
        if (isNamenodeHeartbeatEnable = this.conf.getBoolean("dfs.federation.router.namenode.heartbeat.enable", isRouterHeartbeatEnabled = this.conf.getBoolean("dfs.federation.router.heartbeat.enable", true))) {
            this.namenodeHeartbeatServices = this.createNamenodeHeartbeatServices();
            for (NamenodeHeartbeatService heartbeatService : this.namenodeHeartbeatServices) {
                this.addService((Service)heartbeatService);
            }
            if (this.namenodeHeartbeatServices.isEmpty()) {
                LOG.error("Heartbeat is enabled but there are no namenodes to monitor");
            }
        }
        if (isRouterHeartbeatEnabled) {
            this.routerHeartbeatService = new RouterHeartbeatService(this);
            this.addService((Service)this.routerHeartbeatService);
        }
        if (this.conf.getBoolean("dfs.federation.router.metrics.enable", true)) {
            DefaultMetricsSystem.initialize((String)"Router");
            this.metrics = new RouterMetricsService(this);
            this.addService((Service)this.metrics);
            this.pauseMonitor = new JvmPauseMonitor();
            this.pauseMonitor.init(this.conf);
        }
        if (this.conf.getBoolean("dfs.federation.router.quota.enable", false)) {
            this.quotaManager = new RouterQuotaManager();
            this.quotaUpdateService = new RouterQuotaUpdateService(this);
            this.addService((Service)this.quotaUpdateService);
        }
        if (this.conf.getBoolean("dfs.federation.router.safemode.enable", true)) {
            this.safemodeService = new RouterSafemodeService(this);
            this.addService((Service)this.safemodeService);
        }
        if (this.conf.getBoolean("dfs.federation.router.mount-table.cache.update", false)) {
            String disabledDependentServices = this.getDisabledDependentServices();
            if (disabledDependentServices == null) {
                MountTableRefresherService refreshService = new MountTableRefresherService(this);
                this.addService((Service)refreshService);
                LOG.info("Service {} is enabled.", (Object)MountTableRefresherService.class.getSimpleName());
            } else {
                LOG.warn("Service {} not enabled: dependent service(s) {} not enabled.", (Object)MountTableRefresherService.class.getSimpleName(), (Object)disabledDependentServices);
            }
        }
        super.serviceInit(this.conf);
        if (this.stateStore != null) {
            MountTableStore mountstore = this.stateStore.getRegisteredRecordStore(MountTableStore.class);
            mountstore.setQuotaManager(this.quotaManager);
        }
    }

    private String getDisabledDependentServices() {
        if (this.stateStore == null && this.adminServer == null) {
            return StateStoreService.class.getSimpleName() + "," + RouterAdminServer.class.getSimpleName();
        }
        if (this.stateStore == null) {
            return StateStoreService.class.getSimpleName();
        }
        if (this.adminServer == null) {
            return RouterAdminServer.class.getSimpleName();
        }
        return null;
    }

    private static String getHostName(Configuration config) throws UnknownHostException {
        String name = config.get("dfs.federation.router.kerberos.principal.hostname");
        if (name == null) {
            name = InetAddress.getLocalHost().getHostName();
        }
        return name;
    }

    protected void serviceStart() throws Exception {
        if (this.safemodeService == null) {
            this.updateRouterState(RouterServiceState.RUNNING);
        }
        if (this.pauseMonitor != null) {
            this.pauseMonitor.start();
            JvmMetrics jvmMetrics = this.metrics.getJvmMetrics();
            if (jvmMetrics != null) {
                jvmMetrics.setPauseMonitor(this.pauseMonitor);
            }
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.updateRouterState(RouterServiceState.SHUTDOWN);
        if (this.pauseMonitor != null) {
            this.pauseMonitor.stop();
        }
        super.serviceStop();
    }

    public void shutDown() {
        new Thread(){

            @Override
            public void run() {
                Router.this.stop();
            }
        }.start();
    }

    protected RouterRpcServer createRpcServer() throws IOException {
        return new RouterRpcServer(this.conf, this, this.getNamenodeResolver(), this.getSubclusterResolver());
    }

    public RouterRpcServer getRpcServer() {
        return this.rpcServer;
    }

    protected void setRpcServerAddress(InetSocketAddress address) {
        this.rpcAddress = address;
        if (this.rpcAddress != null) {
            try {
                String hostname = InetAddress.getLocalHost().getHostName();
                this.setRouterId(hostname + ":" + this.rpcAddress.getPort());
            }
            catch (UnknownHostException ex) {
                LOG.error("Cannot set unique router ID, address not resolvable {}", (Object)this.rpcAddress);
            }
        }
    }

    public InetSocketAddress getRpcServerAddress() {
        return this.rpcAddress;
    }

    protected RouterAdminServer createAdminServer() throws IOException {
        return new RouterAdminServer(this.conf, this);
    }

    protected void setAdminServerAddress(InetSocketAddress address) {
        this.adminAddress = address;
    }

    public InetSocketAddress getAdminServerAddress() {
        return this.adminAddress;
    }

    protected RouterHttpServer createHttpServer() {
        return new RouterHttpServer(this);
    }

    public InetSocketAddress getHttpServerAddress() {
        if (this.httpServer != null) {
            return this.httpServer.getHttpAddress();
        }
        return null;
    }

    public void verifyToken(DelegationTokenIdentifier tokenId, byte[] password) throws IOException {
        this.getRpcServer().getRouterSecurityManager().verifyToken(tokenId, password);
    }

    protected Collection<NamenodeHeartbeatService> createNamenodeHeartbeatServices() {
        NamenodeHeartbeatService localHeartbeatService;
        HashMap<String, NamenodeHeartbeatService> ret = new HashMap<String, NamenodeHeartbeatService>();
        if (this.conf.getBoolean("dfs.federation.router.monitor.localnamenode.enable", true) && (localHeartbeatService = this.createLocalNamenodeHeartbeatService()) != null) {
            String nnDesc = localHeartbeatService.getNamenodeDesc();
            ret.put(nnDesc, localHeartbeatService);
        }
        Collection namenodes = this.conf.getTrimmedStringCollection("dfs.federation.router.monitor.namenode");
        for (String namenode : namenodes) {
            NamenodeHeartbeatService heartbeatService;
            String[] namenodeSplit = namenode.split("\\.");
            String nsId = null;
            String nnId = null;
            if (namenodeSplit.length == 2) {
                nsId = namenodeSplit[0];
                nnId = namenodeSplit[1];
            } else if (namenodeSplit.length == 1) {
                nsId = namenode;
            } else {
                LOG.error("Wrong Namenode to monitor: {}", (Object)namenode);
            }
            if (nsId == null || (heartbeatService = this.createNamenodeHeartbeatService(nsId, nnId)) == null) continue;
            ret.put(heartbeatService.getNamenodeDesc(), heartbeatService);
        }
        return ret.values();
    }

    protected NamenodeHeartbeatService createLocalNamenodeHeartbeatService() {
        String nsId = DFSUtil.getNamenodeNameServiceId((Configuration)this.conf);
        String nnId = null;
        if (HAUtil.isHAEnabled((Configuration)this.conf, (String)nsId) && (nnId = HAUtil.getNameNodeId((Configuration)this.conf, (String)nsId)) == null) {
            LOG.error("Cannot find namenode id for local {}", (Object)nsId);
        }
        return this.createNamenodeHeartbeatService(nsId, nnId);
    }

    protected NamenodeHeartbeatService createNamenodeHeartbeatService(String nsId, String nnId) {
        LOG.info("Creating heartbeat service for Namenode {} in {}", (Object)nnId, (Object)nsId);
        NamenodeHeartbeatService ret = new NamenodeHeartbeatService(this.namenodeResolver, nsId, nnId);
        return ret;
    }

    public void updateRouterState(RouterServiceState newState) {
        this.state = newState;
        if (this.routerHeartbeatService != null) {
            this.routerHeartbeatService.updateStateAsync();
        }
    }

    public RouterServiceState getRouterState() {
        return this.state;
    }

    public boolean isRouterState(RouterServiceState routerState) {
        return routerState.equals((Object)this.state);
    }

    public StateStoreService getStateStore() {
        return this.stateStore;
    }

    public RouterMetrics getRouterMetrics() {
        if (this.metrics != null) {
            return this.metrics.getRouterMetrics();
        }
        return null;
    }

    public RBFMetrics getMetrics() {
        if (this.metrics != null) {
            return this.metrics.getRBFMetrics();
        }
        return null;
    }

    public NamenodeBeanMetrics getNamenodeMetrics() throws IOException {
        if (this.metrics == null) {
            throw new IOException("Namenode metrics is not initialized");
        }
        return this.metrics.getNamenodeMetrics();
    }

    public FileSubclusterResolver getSubclusterResolver() {
        return this.subclusterResolver;
    }

    public ActiveNamenodeResolver getNamenodeResolver() {
        return this.namenodeResolver;
    }

    public RouterStore getRouterStateManager() {
        if (this.routerStateManager == null && this.stateStore != null) {
            this.routerStateManager = this.stateStore.getRegisteredRecordStore(RouterStore.class);
        }
        return this.routerStateManager;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getRouterId() {
        return this.routerId;
    }

    public void setRouterId(String id) {
        this.routerId = id;
        if (this.stateStore != null) {
            this.stateStore.setIdentifier(this.routerId);
        }
        if (this.namenodeResolver != null) {
            this.namenodeResolver.setRouterId(this.routerId);
        }
    }

    public boolean isQuotaEnabled() {
        return this.quotaManager != null;
    }

    public RouterQuotaManager getQuotaManager() {
        return this.quotaManager;
    }

    @VisibleForTesting
    RouterQuotaUpdateService getQuotaCacheUpdateService() {
        return this.quotaUpdateService;
    }

    @VisibleForTesting
    Collection<NamenodeHeartbeatService> getNamenodeHeartbeatServices() {
        return this.namenodeHeartbeatServices;
    }

    @VisibleForTesting
    RouterHeartbeatService getRouterHeartbeatService() {
        return this.routerHeartbeatService;
    }

    RouterSafemodeService getSafemodeService() {
        return this.safemodeService;
    }

    public RouterAdminServer getAdminServer() {
        return this.adminServer;
    }
}

