/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.driver.TestStateStoreDriverBase;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileBaseImpl;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileSystemImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestStateStoreFileSystem
extends TestStateStoreDriverBase {
    private static MiniDFSCluster dfsCluster;

    @BeforeClass
    public static void setupCluster() throws Exception {
        Configuration conf = FederationStateStoreTestUtils.getStateStoreConfiguration(StateStoreFileSystemImpl.class);
        conf.set("dfs.federation.router.store.driver.fs.path", "/hdfs-federation/");
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        builder.numDataNodes(1);
        dfsCluster = builder.build();
        dfsCluster.waitClusterUp();
        TestStateStoreFileSystem.getStateStore(conf);
    }

    @AfterClass
    public static void tearDownCluster() {
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
    }

    @Before
    public void startup() throws IOException {
        TestStateStoreFileSystem.removeAll(this.getStateStoreDriver());
    }

    @Test
    public void testInsert() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testInsert(this.getStateStoreDriver());
    }

    @Test
    public void testUpdate() throws IllegalArgumentException, IOException, SecurityException, ReflectiveOperationException {
        this.testPut(this.getStateStoreDriver());
    }

    @Test
    public void testDelete() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testRemove(this.getStateStoreDriver());
    }

    @Test
    public void testFetchErrors() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testFetchErrors(this.getStateStoreDriver());
    }

    @Test
    public void testMetrics() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testMetrics(this.getStateStoreDriver());
    }

    @Test
    public void testInsertWithErrorDuringWrite() throws IllegalArgumentException, IllegalAccessException, IOException {
        StateStoreFileBaseImpl driver = (StateStoreFileBaseImpl)Mockito.spy((Object)((StateStoreFileBaseImpl)this.getStateStoreDriver()));
        ((StateStoreFileBaseImpl)Mockito.doAnswer(a -> {
            BufferedWriter writer = (BufferedWriter)a.callRealMethod();
            BufferedWriter spyWriter = (BufferedWriter)Mockito.spy((Object)writer);
            ((BufferedWriter)Mockito.doThrow(IOException.class).when((Object)spyWriter)).write((String)Mockito.any(String.class));
            return spyWriter;
        }).when((Object)driver)).getWriter((String)Mockito.any());
        this.testInsertWithErrorDuringWrite((StateStoreDriver)driver, MembershipState.class);
    }
}

