/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMountTableResolver {
    private static final Logger LOG = LoggerFactory.getLogger(TestMountTableResolver.class);
    private static final int TEST_MAX_CACHE_SIZE = 10;
    private MountTableResolver mountTable;

    private Map<String, String> getMountTableEntry(String subcluster, String path) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(subcluster, path);
        return ret;
    }

    private void setupMountTable() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.federation.router.mount-table.max-cache-size", 10);
        conf.setStrings("dfs.federation.router.default.nameserviceId", new String[]{"0"});
        this.mountTable = new MountTableResolver(conf);
        Map<String, String> map = this.getMountTableEntry("1", "/");
        this.mountTable.addEntry(MountTable.newInstance((String)"/", map));
        map = this.getMountTableEntry("2", "/");
        this.mountTable.addEntry(MountTable.newInstance((String)"/tmp", map));
        map = this.getMountTableEntry("3", "/user");
        this.mountTable.addEntry(MountTable.newInstance((String)"/user", map));
        map = this.getMountTableEntry("2", "/bin");
        this.mountTable.addEntry(MountTable.newInstance((String)"/usr/bin", map));
        map = this.getMountTableEntry("2", "/user/test");
        this.mountTable.addEntry(MountTable.newInstance((String)"/user/a", map));
        map = this.getMountTableEntry("4", "/user/file1.txt");
        this.mountTable.addEntry(MountTable.newInstance((String)"/user/b/file1.txt", map));
        map = this.getMountTableEntry("1", "/user/test");
        this.mountTable.addEntry(MountTable.newInstance((String)"/user/a/demo/test/a", map));
        map = this.getMountTableEntry("3", "/user/test");
        this.mountTable.addEntry(MountTable.newInstance((String)"/user/a/demo/test/b", map));
        map = this.getMountTableEntry("2", "/tmp");
        MountTable readOnlyEntry = MountTable.newInstance((String)"/readonly", map);
        readOnlyEntry.setReadOnly(true);
        this.mountTable.addEntry(readOnlyEntry);
        map = this.getMountTableEntry("5", "/dest1");
        map.put("6", "/dest2");
        MountTable multiEntry = MountTable.newInstance((String)"/multi", map);
        this.mountTable.addEntry(multiEntry);
    }

    @Before
    public void setup() throws IOException {
        this.setupMountTable();
    }

    @Test
    public void testDestination() throws IOException {
        Assert.assertEquals((Object)"1->/tesfile1.txt", (Object)this.mountTable.getDestinationForPath("/tesfile1.txt").toString());
        Assert.assertEquals((Object)"3->/user/testfile2.txt", (Object)this.mountTable.getDestinationForPath("/user/testfile2.txt").toString());
        Assert.assertEquals((Object)"2->/user/test/testfile3.txt", (Object)this.mountTable.getDestinationForPath("/user/a/testfile3.txt").toString());
        Assert.assertEquals((Object)"3->/user/b/testfile4.txt", (Object)this.mountTable.getDestinationForPath("/user/b/testfile4.txt").toString());
        Assert.assertEquals((Object)"1->/share/file5.txt", (Object)this.mountTable.getDestinationForPath("/share/file5.txt").toString());
        Assert.assertEquals((Object)"2->/bin/file7.txt", (Object)this.mountTable.getDestinationForPath("/usr/bin/file7.txt").toString());
        Assert.assertEquals((Object)"1->/usr/file8.txt", (Object)this.mountTable.getDestinationForPath("/usr/file8.txt").toString());
        Assert.assertEquals((Object)"2->/user/test/demo/file9.txt", (Object)this.mountTable.getDestinationForPath("/user/a/demo/file9.txt").toString());
        Assert.assertEquals((Object)"3->/user/testfolder", (Object)this.mountTable.getDestinationForPath("/user/testfolder").toString());
        Assert.assertEquals((Object)"2->/user/test/b", (Object)this.mountTable.getDestinationForPath("/user/a/b").toString());
        Assert.assertEquals((Object)"3->/user/test/a", (Object)this.mountTable.getDestinationForPath("/user/test/a").toString());
        Assert.assertEquals((Object)"2->/tmp/tesfile1.txt", (Object)this.mountTable.getDestinationForPath("/readonly/tesfile1.txt").toString());
    }

    @Test
    public void testDestinationOfConsecutiveSlash() throws IOException {
        Assert.assertEquals((Object)"1->/tesfile1.txt", (Object)this.mountTable.getDestinationForPath("//tesfile1.txt///").toString());
        Assert.assertEquals((Object)"3->/user/testfile2.txt", (Object)this.mountTable.getDestinationForPath("/user///testfile2.txt").toString());
        Assert.assertEquals((Object)"2->/user/test/testfile3.txt", (Object)this.mountTable.getDestinationForPath("///user/a/testfile3.txt").toString());
        Assert.assertEquals((Object)"3->/user/b/testfile4.txt", (Object)this.mountTable.getDestinationForPath("/user/b/testfile4.txt//").toString());
    }

    @Test
    public void testDefaultNameServiceEnable() throws IOException {
        Assert.assertTrue((boolean)this.mountTable.isDefaultNSEnable());
        this.mountTable.setDefaultNameService("3");
        this.mountTable.removeEntry("/");
        Assert.assertEquals((Object)"3->/unknown", (Object)this.mountTable.getDestinationForPath("/unknown").toString());
        Map<String, String> map = this.getMountTableEntry("4", "/unknown");
        this.mountTable.addEntry(MountTable.newInstance((String)"/unknown", map));
        this.mountTable.setDefaultNSEnable(false);
        Assert.assertFalse((boolean)this.mountTable.isDefaultNSEnable());
        Assert.assertEquals((Object)"4->/unknown", (Object)this.mountTable.getDestinationForPath("/unknown").toString());
        try {
            this.mountTable.getDestinationForPath("/");
            Assert.fail((String)"The getDestinationForPath call should fail.");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"the default nameservice is disabled to read or write", (Throwable)ioe);
        }
    }

    @Test
    public void testMuiltipleDestinations() throws IOException {
        try {
            this.mountTable.getDestinationForPath("/multi");
            Assert.fail((String)"The getDestinationForPath call should fail.");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"MountTableResolver should not resolve multiple destinations", (Throwable)ioe);
        }
    }

    private void compareLists(List<String> list1, String[] list2) {
        Assert.assertEquals((long)list1.size(), (long)list2.length);
        for (String item : list2) {
            Assert.assertTrue((boolean)list1.contains(item));
        }
    }

    @Test
    public void testGetMountPoint() throws IOException {
        MountTable mtEntry = this.mountTable.getMountPoint("/");
        Assert.assertEquals((Object)"/", (Object)mtEntry.getSourcePath());
        mtEntry = this.mountTable.getMountPoint("/user");
        Assert.assertEquals((Object)"/user", (Object)mtEntry.getSourcePath());
        mtEntry = this.mountTable.getMountPoint("/user/a");
        Assert.assertEquals((Object)"/user/a", (Object)mtEntry.getSourcePath());
        mtEntry = this.mountTable.getMountPoint("/user/a/");
        Assert.assertEquals((Object)"/user/a", (Object)mtEntry.getSourcePath());
        mtEntry = this.mountTable.getMountPoint("/user/a/11");
        Assert.assertEquals((Object)"/user/a", (Object)mtEntry.getSourcePath());
        mtEntry = this.mountTable.getMountPoint("/user/a1");
        Assert.assertEquals((Object)"/user", (Object)mtEntry.getSourcePath());
    }

    @Test
    public void testGetMountPointOfConsecutiveSlashes() throws IOException {
        MountTable mtEntry = this.mountTable.getMountPoint("///");
        Assert.assertEquals((Object)"/", (Object)mtEntry.getSourcePath());
        mtEntry = this.mountTable.getMountPoint("///user//");
        Assert.assertEquals((Object)"/user", (Object)mtEntry.getSourcePath());
        mtEntry = this.mountTable.getMountPoint("/user///a");
        Assert.assertEquals((Object)"/user/a", (Object)mtEntry.getSourcePath());
        mtEntry = this.mountTable.getMountPoint("/user/a////");
        Assert.assertEquals((Object)"/user/a", (Object)mtEntry.getSourcePath());
        mtEntry = this.mountTable.getMountPoint("///user/a/11//");
        Assert.assertEquals((Object)"/user/a", (Object)mtEntry.getSourcePath());
        mtEntry = this.mountTable.getMountPoint("/user///a1///");
        Assert.assertEquals((Object)"/user", (Object)mtEntry.getSourcePath());
    }

    @Test
    public void testTrailingSlashInInputPath() throws IOException {
        this.getMountPoints(true);
    }

    @Test
    public void testGetMountPoints() throws IOException {
        this.getMountPoints(false);
    }

    private void getMountPoints(boolean trailingSlash) throws IOException {
        List mounts = this.mountTable.getMountPoints("/");
        Assert.assertEquals((long)5L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"tmp", "user", "usr", "readonly", "multi"});
        String path = trailingSlash ? "/user/" : "/user";
        mounts = this.mountTable.getMountPoints(path);
        Assert.assertEquals((long)2L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"a", "b"});
        path = trailingSlash ? "/user/a/" : "/user/a";
        mounts = this.mountTable.getMountPoints(path);
        Assert.assertEquals((long)1L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"demo"});
        path = trailingSlash ? "/user/a/demo/" : "/user/a/demo";
        mounts = this.mountTable.getMountPoints(path);
        Assert.assertEquals((long)1L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"test"});
        path = trailingSlash ? "/user/a/demo/test/" : "/user/a/demo/test";
        mounts = this.mountTable.getMountPoints(path);
        Assert.assertEquals((long)2L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"a", "b"});
        path = trailingSlash ? "/tmp/" : "/tmp";
        mounts = this.mountTable.getMountPoints(path);
        Assert.assertEquals((long)0L, (long)mounts.size());
        path = trailingSlash ? "/t/" : "/t";
        mounts = this.mountTable.getMountPoints(path);
        Assert.assertNull((Object)mounts);
        path = trailingSlash ? "/unknownpath/" : "/unknownpath";
        mounts = this.mountTable.getMountPoints(path);
        Assert.assertNull((Object)mounts);
        path = trailingSlash ? "/multi/" : "/multi";
        mounts = this.mountTable.getMountPoints(path);
        Assert.assertEquals((long)0L, (long)mounts.size());
    }

    @Test
    public void testSuccessiveSlashesInInputPath() throws IOException {
        List mounts = this.mountTable.getMountPoints("///");
        Assert.assertEquals((long)5L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"tmp", "user", "usr", "readonly", "multi"});
        String path = "///user//";
        mounts = this.mountTable.getMountPoints(path);
        Assert.assertEquals((long)2L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"a", "b"});
        path = "/user///a";
        mounts = this.mountTable.getMountPoints(path);
        Assert.assertEquals((long)1L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"demo"});
    }

    private void compareRecords(List<MountTable> list1, String[] list2) {
        Assert.assertEquals((long)list1.size(), (long)list2.length);
        for (String item : list2) {
            for (MountTable record : list1) {
                if (!record.getSourcePath().equals(item)) continue;
                return;
            }
        }
        Assert.fail();
    }

    @Test
    public void testGetMounts() throws IOException {
        List records = this.mountTable.getMounts("/");
        Assert.assertEquals((long)10L, (long)records.size());
        this.compareRecords(records, new String[]{"/", "/tmp", "/user", "/usr/bin", "user/a", "/user/a/demo/a", "/user/a/demo/b", "/user/b/file1.txt", "readonly", "multi"});
        records = this.mountTable.getMounts("/user");
        Assert.assertEquals((long)5L, (long)records.size());
        this.compareRecords(records, new String[]{"/user", "/user/a/demo/a", "/user/a/demo/b", "user/a", "/user/b/file1.txt"});
        records = this.mountTable.getMounts("/user/a");
        Assert.assertEquals((long)3L, (long)records.size());
        this.compareRecords(records, new String[]{"/user/a/demo/a", "/user/a/demo/b", "/user/a"});
        records = this.mountTable.getMounts("/tmp");
        Assert.assertEquals((long)1L, (long)records.size());
        this.compareRecords(records, new String[]{"/tmp"});
        records = this.mountTable.getMounts("/readonly");
        Assert.assertEquals((long)1L, (long)records.size());
        this.compareRecords(records, new String[]{"/readonly"});
        Assert.assertTrue((boolean)((MountTable)records.get(0)).isReadOnly());
        records = this.mountTable.getMounts("/multi");
        Assert.assertEquals((long)1L, (long)records.size());
        this.compareRecords(records, new String[]{"/multi"});
    }

    @Test
    public void testGetMountsOfConsecutiveSlashes() throws IOException {
        List records = this.mountTable.getMounts("///");
        Assert.assertEquals((long)10L, (long)records.size());
        this.compareRecords(records, new String[]{"/", "/tmp", "/user", "/usr/bin", "user/a", "/user/a/demo/a", "/user/a/demo/b", "/user/b/file1.txt", "readonly", "multi"});
        records = this.mountTable.getMounts("/user///");
        Assert.assertEquals((long)5L, (long)records.size());
        this.compareRecords(records, new String[]{"/user", "/user/a/demo/a", "/user/a/demo/b", "user/a", "/user/b/file1.txt"});
        records = this.mountTable.getMounts("///user///a");
        Assert.assertEquals((long)3L, (long)records.size());
        this.compareRecords(records, new String[]{"/user/a/demo/a", "/user/a/demo/b", "/user/a"});
    }

    @Test
    public void testRemoveSubTree() throws UnsupportedOperationException, IOException {
        this.compareLists(this.mountTable.getMountPoints("/"), new String[]{"user", "usr", "tmp", "readonly", "multi"});
        Assert.assertEquals((Object)"2", (Object)this.mountTable.getDestinationForPath("/tmp/testfile.txt").getDefaultLocation().getNameserviceId());
        this.mountTable.removeEntry("/tmp");
        this.compareLists(this.mountTable.getMountPoints("/"), new String[]{"user", "usr", "readonly", "multi"});
        Assert.assertEquals((Object)"1", (Object)this.mountTable.getDestinationForPath("/tmp/testfile.txt").getDefaultLocation().getNameserviceId());
    }

    @Test
    public void testRemoveVirtualNode() throws UnsupportedOperationException, IOException {
        this.compareLists(this.mountTable.getMountPoints("/"), new String[]{"user", "usr", "tmp", "readonly", "multi"});
        Assert.assertEquals((Object)"1", (Object)this.mountTable.getDestinationForPath("/usr/testfile.txt").getDefaultLocation().getNameserviceId());
        this.mountTable.removeEntry("/usr");
        this.compareLists(this.mountTable.getMountPoints("/"), new String[]{"user", "usr", "tmp", "readonly", "multi"});
    }

    @Test
    public void testRemoveLeafNode() throws UnsupportedOperationException, IOException {
        Assert.assertEquals((Object)"1", (Object)this.mountTable.getDestinationForPath("/user/a/demo/test/a").getDefaultLocation().getNameserviceId());
        this.mountTable.removeEntry("/user/a/demo/test/a");
        Assert.assertEquals((Object)"2", (Object)this.mountTable.getDestinationForPath("/user/a/demo/test/a").getDefaultLocation().getNameserviceId());
        this.compareLists(this.mountTable.getMountPoints("/user/a"), new String[]{"demo"});
        Assert.assertEquals((Object)"3", (Object)this.mountTable.getDestinationForPath("/user/a/demo/test/b").getDefaultLocation().getNameserviceId());
    }

    @Test
    public void testRefreshEntries() throws UnsupportedOperationException, IOException {
        this.testDestination();
        Assert.assertEquals((long)10L, (long)this.mountTable.getMounts("/").size());
        ArrayList<MountTable> records = new ArrayList<MountTable>();
        Map<String, String> map1 = this.getMountTableEntry("1", "/");
        records.add(MountTable.newInstance((String)"/1", map1));
        Map<String, String> map2 = this.getMountTableEntry("2", "/");
        records.add(MountTable.newInstance((String)"/2", map2));
        this.mountTable.refreshEntries(records);
        PathLocation destination1 = this.mountTable.getDestinationForPath("/1");
        RemoteLocation defaultLoc1 = destination1.getDefaultLocation();
        Assert.assertEquals((Object)"1", (Object)defaultLoc1.getNameserviceId());
        PathLocation destination2 = this.mountTable.getDestinationForPath("/2");
        RemoteLocation defaultLoc2 = destination2.getDefaultLocation();
        Assert.assertEquals((Object)"2", (Object)defaultLoc2.getNameserviceId());
        Assert.assertEquals((long)2L, (long)this.mountTable.getMounts("/").size());
        boolean assertionThrown = false;
        try {
            this.testDestination();
            Assert.fail();
        }
        catch (AssertionError e) {
            assertionThrown = true;
        }
        Assert.assertTrue((boolean)assertionThrown);
    }

    @Test
    public void testMountTableScalability() throws IOException {
        ArrayList emptyList = new ArrayList();
        this.mountTable.refreshEntries(emptyList);
        for (int i = 0; i < 100000; ++i) {
            Map<String, String> map = this.getMountTableEntry("1", "/" + i);
            MountTable record = MountTable.newInstance((String)("/" + i), map);
            this.mountTable.addEntry(record);
            if (i % 10000 != 0) continue;
            LOG.info("Adding flat mount record {}: {}", (Object)i, (Object)record);
        }
        Assert.assertEquals((long)100000L, (long)this.mountTable.getMountPoints("/").size());
        Assert.assertEquals((long)100000L, (long)this.mountTable.getMounts("/").size());
        this.mountTable.refreshEntries(emptyList);
        String parent = "/";
        for (int i = 0; i < 1000; ++i) {
            int index = i;
            Map<String, String> map = this.getMountTableEntry("1", "/" + index);
            if (i > 0) {
                parent = parent + "/";
            }
            parent = parent + i;
            MountTable record = MountTable.newInstance((String)parent, map);
            this.mountTable.addEntry(record);
        }
        Assert.assertEquals((long)1L, (long)this.mountTable.getMountPoints("/").size());
        Assert.assertEquals((long)1000L, (long)this.mountTable.getMounts("/").size());
        this.mountTable.refreshEntries(emptyList);
        Random rand = new Random();
        parent = "/" + Integer.toString(rand.nextInt());
        int numRootTrees = 1;
        for (int i = 0; i < 100000; ++i) {
            int index = i;
            Map<String, String> map = this.getMountTableEntry("1", "/" + index);
            if ((parent = parent + "/" + i).length() > 2000) {
                parent = "/" + Integer.toString(rand.nextInt());
                ++numRootTrees;
            }
            MountTable record = MountTable.newInstance((String)parent, map);
            this.mountTable.addEntry(record);
        }
        Assert.assertEquals((long)numRootTrees, (long)this.mountTable.getMountPoints("/").size());
        Assert.assertEquals((long)100000L, (long)this.mountTable.getMounts("/").size());
    }

    @Test
    public void testUpdate() throws IOException {
        Map<String, String> map = this.getMountTableEntry("1", "/");
        this.mountTable.addEntry(MountTable.newInstance((String)"/testupdate", map));
        MountTable entry = this.mountTable.getMountPoint("/testupdate");
        List dests = entry.getDestinations();
        Assert.assertEquals((long)1L, (long)dests.size());
        RemoteLocation dest = (RemoteLocation)dests.get(0);
        Assert.assertEquals((Object)"1", (Object)dest.getNameserviceId());
        List<MountTable> entries = Collections.singletonList(MountTable.newInstance((String)"/testupdate", this.getMountTableEntry("2", "/")));
        this.mountTable.refreshEntries(entries);
        MountTable entry1 = this.mountTable.getMountPoint("/testupdate");
        List dests1 = entry1.getDestinations();
        Assert.assertEquals((long)1L, (long)dests1.size());
        RemoteLocation dest1 = (RemoteLocation)dests1.get(0);
        Assert.assertEquals((Object)"2", (Object)dest1.getNameserviceId());
        this.mountTable.removeEntry("/testupdate");
        MountTable entry2 = this.mountTable.getMountPoint("/testupdate");
        Assert.assertNull((Object)entry2);
    }

    @Test
    public void testDisableLocalCache() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.federation.router.mount-table.cache.enable", false);
        conf.setStrings("dfs.federation.router.default.nameserviceId", new String[]{"0"});
        MountTableResolver tmpMountTable = new MountTableResolver(conf);
        Map<String, String> map = this.getMountTableEntry("1", "/");
        tmpMountTable.addEntry(MountTable.newInstance((String)"/", map));
        map = this.getMountTableEntry("2", "/tmp");
        tmpMountTable.addEntry(MountTable.newInstance((String)"/tmp", map));
        try {
            tmpMountTable.getCacheSize();
            Assert.fail((String)"getCacheSize call should fail.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"localCache is null", (Throwable)e);
        }
        Assert.assertEquals((Object)"2->/tmp/tesfile1.txt", (Object)tmpMountTable.getDestinationForPath("/tmp/tesfile1.txt").toString());
    }

    @Test
    public void testCacheCleaning() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            String filename = String.format("/user/a/file-%04d.txt", i);
            this.mountTable.getDestinationForPath(filename);
        }
        long cacheSize = this.mountTable.getCacheSize();
        Assert.assertTrue((cacheSize <= 10L ? 1 : 0) != 0);
    }

    @Test
    public void testLocationCache() throws Exception {
        ArrayList<MountTable> entries = new ArrayList<MountTable>();
        Map<String, String> map1 = this.getMountTableEntry("1", "/testlocationcache");
        MountTable entry1 = MountTable.newInstance((String)"/testlocationcache", map1);
        entries.add(entry1);
        Map<String, String> map2 = this.getMountTableEntry("2", "/anothertestlocationcache");
        MountTable entry2 = MountTable.newInstance((String)"/anothertestlocationcache", map2);
        entries.add(entry2);
        this.mountTable.refreshEntries(entries);
        Assert.assertEquals((Object)"1->/testlocationcache", (Object)this.mountTable.getDestinationForPath("/testlocationcache").toString());
        Assert.assertEquals((Object)"2->/anothertestlocationcache", (Object)this.mountTable.getDestinationForPath("/anothertestlocationcache").toString());
        entries.remove(entry1);
        this.mountTable.refreshEntries(entries);
        Assert.assertEquals((Object)"0->/testlocationcache", (Object)this.mountTable.getDestinationForPath("/testlocationcache").toString());
        Map<String, String> map3 = this.getMountTableEntry("3", "/testlocationcache");
        MountTable entry3 = MountTable.newInstance((String)"/testlocationcache", map3);
        entries.add(entry3);
        this.mountTable.refreshEntries(entries);
        Assert.assertEquals((Object)"3->/testlocationcache", (Object)this.mountTable.getDestinationForPath("/testlocationcache").toString());
        this.mountTable.removeEntry("/testlocationcache");
        this.mountTable.removeEntry("/anothertestlocationcache");
    }

    @Test
    public void testInvalidateCache() throws Exception {
        Map<String, String> map1 = this.getMountTableEntry("1", "/");
        MountTable entry1 = MountTable.newInstance((String)"/", map1);
        this.mountTable.addEntry(entry1);
        Assert.assertEquals((Object)"1->/", (Object)this.mountTable.getDestinationForPath("/").toString());
        Assert.assertEquals((Object)"1->/testInvalidateCache/foo", (Object)this.mountTable.getDestinationForPath("/testInvalidateCache/foo").toString());
        Map<String, String> map2 = this.getMountTableEntry("2", "/testInvalidateCache");
        MountTable entry2 = MountTable.newInstance((String)"/testInvalidateCache", map2);
        this.mountTable.addEntry(entry2);
        Assert.assertEquals((Object)"2->/testInvalidateCache", (Object)this.mountTable.getDestinationForPath("/testInvalidateCache").toString());
        Assert.assertEquals((Object)"2->/testInvalidateCache/foo", (Object)this.mountTable.getDestinationForPath("/testInvalidateCache/foo").toString());
    }
}

