/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.hdfs.server.federation.store.records.QueryResult;

public abstract class StateStoreBaseImpl
extends StateStoreDriver {
    @Override
    public <T extends BaseRecord> T get(Class<T> clazz, Query<T> query) throws IOException {
        List<T> records = this.getMultiple(clazz, query);
        if (records.size() > 1) {
            throw new IOException("Found more than one object in collection");
        }
        if (records.size() == 1) {
            return (T)((BaseRecord)records.get(0));
        }
        return null;
    }

    @Override
    public <T extends BaseRecord> List<T> getMultiple(Class<T> clazz, Query<T> query) throws IOException {
        QueryResult<T> result = this.get(clazz);
        List<T> records = result.getRecords();
        List<T> ret = StateStoreUtils.filterMultiple(query, records);
        if (ret == null) {
            throw new IOException("Cannot fetch records from the store");
        }
        return ret;
    }

    @Override
    public <T extends BaseRecord> boolean put(T record, boolean allowUpdate, boolean errorIfExists) throws IOException {
        ArrayList<T> singletonList = new ArrayList<T>();
        singletonList.add(record);
        return this.putAll(singletonList, allowUpdate, errorIfExists);
    }

    @Override
    public <T extends BaseRecord> boolean remove(T record) throws IOException {
        Query<T> query = new Query<T>(record);
        Class<?> clazz = record.getClass();
        Class<BaseRecord> recordClass = StateStoreUtils.getRecordClass(clazz);
        return this.remove(recordClass, query) == 1;
    }
}

