/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.ConnectionContext;
import org.apache.hadoop.hdfs.server.federation.router.ConnectionManager;
import org.apache.hadoop.hdfs.server.federation.router.ConnectionPool;
import org.apache.hadoop.hdfs.server.federation.router.ConnectionPoolId;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestConnectionManager {
    private Configuration conf;
    private ConnectionManager connManager;
    private static final String[] TEST_GROUP = new String[]{"TEST_GROUP"};
    private static final UserGroupInformation TEST_USER1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])TEST_GROUP);
    private static final UserGroupInformation TEST_USER2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])TEST_GROUP);
    private static final UserGroupInformation TEST_USER3 = UserGroupInformation.createUserForTesting((String)"user3", (String[])TEST_GROUP);
    private static final String TEST_NN_ADDRESS = "nn1:8080";
    private static final String UNRESOLVED_TEST_NN_ADDRESS = "unknownhost:8080";
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration();
        this.connManager = new ConnectionManager(this.conf);
        NetUtils.addStaticResolution((String)"nn1", (String)"localhost");
        NetUtils.createSocketAddrForHost((String)"nn1", (int)8080);
        this.connManager.start();
    }

    @After
    public void shutdown() {
        if (this.connManager != null) {
            this.connManager.close();
        }
    }

    @Test
    public void testCleanup() throws Exception {
        int i;
        Map poolMap = this.connManager.getPools();
        ConnectionPool pool1 = new ConnectionPool(this.conf, TEST_NN_ADDRESS, TEST_USER1, 0, 10, 0.5f, ClientProtocol.class);
        this.addConnectionsToPool(pool1, 9, 4);
        poolMap.put(new ConnectionPoolId(TEST_USER1, TEST_NN_ADDRESS, ClientProtocol.class), pool1);
        ConnectionPool pool2 = new ConnectionPool(this.conf, TEST_NN_ADDRESS, TEST_USER2, 0, 10, 0.5f, ClientProtocol.class);
        this.addConnectionsToPool(pool2, 10, 10);
        poolMap.put(new ConnectionPoolId(TEST_USER2, TEST_NN_ADDRESS, ClientProtocol.class), pool2);
        this.checkPoolConnections(TEST_USER1, 9, 4);
        this.checkPoolConnections(TEST_USER2, 10, 10);
        this.connManager.cleanup(pool1);
        this.checkPoolConnections(TEST_USER1, 8, 4);
        this.checkPoolConnections(TEST_USER2, 10, 10);
        this.connManager.cleanup(pool1);
        this.checkPoolConnections(TEST_USER1, 8, 4);
        this.checkPoolConnections(TEST_USER2, 10, 10);
        ConnectionPool pool3 = new ConnectionPool(this.conf, TEST_NN_ADDRESS, TEST_USER3, 2, 10, 0.5f, ClientProtocol.class);
        this.addConnectionsToPool(pool3, 8, 0);
        poolMap.put(new ConnectionPoolId(TEST_USER3, TEST_NN_ADDRESS, ClientProtocol.class), pool3);
        this.checkPoolConnections(TEST_USER3, 10, 0);
        for (i = 0; i < 10; ++i) {
            this.connManager.cleanup(pool3);
        }
        this.checkPoolConnections(TEST_USER3, 2, 0);
        this.addConnectionsToPool(pool3, 8, 2);
        this.checkPoolConnections(TEST_USER3, 10, 2);
        for (i = 0; i < 10; ++i) {
            this.connManager.cleanup(pool3);
        }
        this.checkPoolConnections(TEST_USER3, 4, 2);
    }

    @Test
    public void testConnectionCreatorWithException() throws Exception {
        ConnectionPool badPool = new ConnectionPool(this.conf, UNRESOLVED_TEST_NN_ADDRESS, TEST_USER1, 0, 10, 0.5f, ClientProtocol.class);
        ArrayBlockingQueue<ConnectionPool> queue = new ArrayBlockingQueue<ConnectionPool>(1);
        queue.add(badPool);
        ConnectionManager.ConnectionCreator connectionCreator = new ConnectionManager.ConnectionCreator(queue);
        connectionCreator.setDaemon(true);
        connectionCreator.start();
        GenericTestUtils.waitFor(() -> queue.isEmpty(), (long)50L, (long)5000L);
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertTrue((boolean)connectionCreator.isAlive());
        connectionCreator.interrupt();
    }

    @Test
    public void testGetConnectionWithException() throws Exception {
        String exceptionCause = "java.net.UnknownHostException: unknownhost";
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage(exceptionCause);
        ConnectionPool badPool = new ConnectionPool(this.conf, UNRESOLVED_TEST_NN_ADDRESS, TEST_USER1, 1, 10, 0.5f, ClientProtocol.class);
    }

    @Test
    public void testGetConnection() throws Exception {
        Map poolMap = this.connManager.getPools();
        int totalConns = 10;
        int activeConns = 5;
        ConnectionPool pool = new ConnectionPool(this.conf, TEST_NN_ADDRESS, TEST_USER1, 0, 10, 0.5f, ClientProtocol.class);
        this.addConnectionsToPool(pool, 10, activeConns);
        poolMap.put(new ConnectionPoolId(TEST_USER1, TEST_NN_ADDRESS, ClientProtocol.class), pool);
        int remainingSlots = 10 - activeConns;
        for (int i = 0; i < remainingSlots; ++i) {
            ConnectionContext cc = pool.getConnection();
            Assert.assertTrue((boolean)cc.isUsable());
            cc.getClient();
            ++activeConns;
        }
        this.checkPoolConnections(TEST_USER1, 10, activeConns);
        ConnectionContext cc = pool.getConnection();
        Assert.assertTrue((boolean)cc.isActive());
    }

    @Test
    public void testValidClientIndex() throws Exception {
        ConnectionPool pool = new ConnectionPool(this.conf, TEST_NN_ADDRESS, TEST_USER1, 2, 2, 0.5f, ClientProtocol.class);
        for (int i = -3; i <= 3; ++i) {
            pool.getClientIndex().set(i);
            ConnectionContext conn = pool.getConnection();
            Assert.assertNotNull((Object)conn);
            Assert.assertTrue((boolean)conn.isUsable());
        }
    }

    @Test
    public void getGetConnectionNamenodeProtocol() throws Exception {
        Map poolMap = this.connManager.getPools();
        int totalConns = 10;
        int activeConns = 5;
        ConnectionPool pool = new ConnectionPool(this.conf, TEST_NN_ADDRESS, TEST_USER1, 0, 10, 0.5f, NamenodeProtocol.class);
        this.addConnectionsToPool(pool, 10, activeConns);
        poolMap.put(new ConnectionPoolId(TEST_USER1, TEST_NN_ADDRESS, NamenodeProtocol.class), pool);
        int remainingSlots = 10 - activeConns;
        for (int i = 0; i < remainingSlots; ++i) {
            ConnectionContext cc = pool.getConnection();
            Assert.assertTrue((boolean)cc.isUsable());
            cc.getClient();
            ++activeConns;
        }
        this.checkPoolConnections(TEST_USER1, 10, activeConns);
        ConnectionContext cc = pool.getConnection();
        Assert.assertTrue((boolean)cc.isActive());
    }

    private void addConnectionsToPool(ConnectionPool pool, int numTotalConn, int numActiveConn) throws IOException {
        for (int i = 0; i < numTotalConn; ++i) {
            ConnectionContext cc = pool.newConnection();
            pool.addConnection(cc);
            if (i >= numActiveConn) continue;
            cc.getClient();
        }
    }

    private void checkPoolConnections(UserGroupInformation ugi, int numOfConns, int numOfActiveConns) {
        boolean connPoolFoundForUser = false;
        for (Map.Entry e : this.connManager.getPools().entrySet()) {
            if (((ConnectionPoolId)e.getKey()).getUgi() != ugi) continue;
            Assert.assertEquals((long)numOfConns, (long)((ConnectionPool)e.getValue()).getNumConnections());
            Assert.assertEquals((long)numOfActiveConns, (long)((ConnectionPool)e.getValue()).getNumActiveConnections());
            connPoolFoundForUser = true;
        }
        if (!connPoolFoundForUser) {
            Assert.fail((String)("Connection pool not found for user " + ugi.getUserName()));
        }
    }

    @Test
    public void testConfigureConnectionActiveRatio() throws IOException {
        int totalConns = 10;
        int activeConns = 7;
        Configuration tmpConf = new Configuration();
        tmpConf.setFloat("dfs.federation.router.connection.min-active-ratio", 0.8f);
        ConnectionManager tmpConnManager = new ConnectionManager(tmpConf);
        tmpConnManager.start();
        tmpConnManager.getConnection(TEST_USER1, TEST_NN_ADDRESS, NamenodeProtocol.class);
        Map poolMap = tmpConnManager.getPools();
        ConnectionPoolId connectionPoolId = new ConnectionPoolId(TEST_USER1, TEST_NN_ADDRESS, NamenodeProtocol.class);
        ConnectionPool pool = (ConnectionPool)poolMap.get(connectionPoolId);
        Assert.assertEquals((float)0.8f, (float)pool.getMinActiveRatio(), (float)0.001f);
        pool.getConnection().getClient();
        Assert.assertEquals((long)1L, (long)pool.getNumActiveConnections());
        this.addConnectionsToPool(pool, 9, activeConns - 1);
        tmpConnManager.cleanup(pool);
        Assert.assertEquals((long)9L, (long)pool.getNumConnections());
        tmpConnManager.close();
    }

    @Test
    public void testUnsupportedProtoExceptionMsg() throws Exception {
        LambdaTestUtils.intercept(IllegalStateException.class, (String)("Unsupported protocol for connection to NameNode: " + TestConnectionManager.class.getName()), () -> ConnectionPool.newConnection((Configuration)this.conf, (String)TEST_NN_ADDRESS, (UserGroupInformation)TEST_USER1, TestConnectionManager.class));
    }
}

