/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileBaseImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateStoreFileImpl
extends StateStoreFileBaseImpl {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreFileImpl.class);
    public static final String FEDERATION_STORE_FILE_DIRECTORY = "dfs.federation.router.store.driver.file.directory";
    private String rootDirectory;

    @Override
    protected boolean exists(String path) {
        File test = new File(path);
        return test.exists();
    }

    @Override
    protected boolean mkdir(String path) {
        File dir = new File(path);
        return dir.mkdirs();
    }

    @Override
    protected boolean rename(String src, String dst) {
        try {
            org.apache.hadoop.thirdparty.com.google.common.io.Files.move((File)new File(src), (File)new File(dst));
            return true;
        }
        catch (IOException e) {
            LOG.error("Cannot rename {} to {}", new Object[]{src, dst, e});
            return false;
        }
    }

    @Override
    protected boolean remove(String path) {
        File file = new File(path);
        return file.delete();
    }

    @Override
    protected String getRootDir() {
        if (this.rootDirectory == null) {
            String dir = this.getConf().get(FEDERATION_STORE_FILE_DIRECTORY);
            if (dir == null) {
                File tempDirBase = new File(System.getProperty("java.io.tmpdir"));
                File tempDir = null;
                try {
                    tempDir = Files.createTempDirectory(tempDirBase.toPath(), System.currentTimeMillis() + "-", new FileAttribute[0]).toFile();
                }
                catch (IOException e) {
                    LOG.debug("Unable to create a temporary directory. Fall back to  the default system temp directory {}", (Object)tempDirBase, (Object)e);
                    tempDir = tempDirBase;
                }
                dir = tempDir.getAbsolutePath();
                LOG.warn("The root directory is not available, using {}", (Object)dir);
            }
            this.rootDirectory = dir;
        }
        return this.rootDirectory;
    }

    @Override
    protected <T extends BaseRecord> BufferedReader getReader(String filename) {
        BufferedReader reader = null;
        try {
            LOG.debug("Loading file: {}", (Object)filename);
            File file = new File(filename);
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
            reader = new BufferedReader(isr);
        }
        catch (Exception ex) {
            LOG.error("Cannot open read stream for record {}", (Object)filename, (Object)ex);
        }
        return reader;
    }

    @Override
    protected <T extends BaseRecord> BufferedWriter getWriter(String filename) {
        BufferedWriter writer = null;
        try {
            LOG.debug("Writing file: {}", (Object)filename);
            File file = new File(filename);
            FileOutputStream fos = new FileOutputStream(file, false);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            writer = new BufferedWriter(osw);
        }
        catch (IOException e) {
            LOG.error("Cannot open write stream for record {}", (Object)filename, (Object)e);
        }
        return writer;
    }

    @Override
    public void close() throws Exception {
        this.setInitialized(false);
    }

    @Override
    protected List<String> getChildren(String path) {
        File dir = new File(path);
        Object[] files = dir.listFiles();
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            ArrayList<String> ret = new ArrayList<String>(files.length);
            for (Object file : files) {
                String filename = ((File)file).getName();
                ret.add(filename);
            }
            return ret;
        }
        return Collections.emptyList();
    }
}

