/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdfs.server.federation.metrics.StateStoreMetrics;
import org.apache.hadoop.hdfs.server.federation.store.RecordStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreCache;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.QueryResult;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachedRecordStore<R extends BaseRecord>
extends RecordStore<R>
implements StateStoreCache {
    private static final Logger LOG = LoggerFactory.getLogger(CachedRecordStore.class);
    private static final long MIN_UPDATE_MS = 500L;
    private List<R> records = new ArrayList<R>();
    private long timestamp = -1L;
    private boolean initialized = false;
    private long lastUpdate = -1L;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private boolean override = false;

    protected CachedRecordStore(Class<R> clazz, StateStoreDriver driver) {
        this(clazz, driver, false);
    }

    protected CachedRecordStore(Class<R> clazz, StateStoreDriver driver, boolean over) {
        super(clazz, driver);
        this.override = over;
    }

    private void checkCacheAvailable() throws StateStoreUnavailableException {
        if (!this.initialized) {
            throw new StateStoreUnavailableException("Cached State Store not initialized, " + this.getRecordClass().getSimpleName() + " records not valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadCache(boolean force) throws IOException {
        if (force || this.isUpdateTime()) {
            List newRecords = null;
            long t = -1L;
            try {
                QueryResult result = this.getDriver().get(this.getRecordClass());
                newRecords = result.getRecords();
                t = result.getTimestamp();
                if (this.override) {
                    this.overrideExpiredRecords(result);
                }
            }
            catch (IOException e) {
                LOG.error("Cannot get \"{}\" records from the State Store", (Object)this.getRecordClass().getSimpleName());
                this.initialized = false;
                return false;
            }
            this.writeLock.lock();
            try {
                this.records.clear();
                this.records.addAll(newRecords);
                this.timestamp = t;
                this.initialized = true;
            }
            finally {
                this.writeLock.unlock();
            }
            StateStoreMetrics metrics = this.getDriver().getMetrics();
            if (metrics != null) {
                String recordName = this.getRecordClass().getSimpleName();
                metrics.setCacheSize(recordName, this.records.size());
            }
            this.lastUpdate = Time.monotonicNow();
        }
        return true;
    }

    private boolean isUpdateTime() {
        return Time.monotonicNow() - this.lastUpdate > 500L;
    }

    public void overrideExpiredRecords(QueryResult<R> query) throws IOException {
        ArrayList<BaseRecord> commitRecords = new ArrayList<BaseRecord>();
        ArrayList<BaseRecord> deleteRecords = new ArrayList<BaseRecord>();
        List<R> newRecords = query.getRecords();
        long currentDriverTime = query.getTimestamp();
        if (newRecords == null || currentDriverTime <= 0L) {
            LOG.error("Cannot check overrides for record");
            return;
        }
        for (BaseRecord record : newRecords) {
            String recordName;
            if (record.shouldBeDeleted(currentDriverTime)) {
                recordName = StateStoreUtils.getRecordName(record.getClass());
                if (this.getDriver().remove(record)) {
                    deleteRecords.add(record);
                    LOG.info("Deleted State Store record {}: {}", (Object)recordName, (Object)record);
                    continue;
                }
                LOG.warn("Couldn't delete State Store record {}: {}", (Object)recordName, (Object)record);
                continue;
            }
            if (!record.checkExpired(currentDriverTime)) continue;
            recordName = StateStoreUtils.getRecordName(record.getClass());
            LOG.info("Override State Store record {}: {}", (Object)recordName, (Object)record);
            commitRecords.add(record);
        }
        if (commitRecords.size() > 0) {
            this.getDriver().putAll(commitRecords, true, false);
        }
        if (deleteRecords.size() > 0) {
            newRecords.removeAll(deleteRecords);
        }
    }

    public void overrideExpiredRecord(R record) throws IOException {
        ArrayList<R> newRecords = new ArrayList<R>();
        newRecords.add(record);
        long time = this.getDriver().getTime();
        QueryResult query = new QueryResult(newRecords, time);
        this.overrideExpiredRecords(query);
    }

    public List<R> getCachedRecords() throws StateStoreUnavailableException {
        this.checkCacheAvailable();
        LinkedList<R> ret = new LinkedList<R>();
        this.readLock.lock();
        try {
            ret.addAll(this.records);
        }
        finally {
            this.readLock.unlock();
        }
        return ret;
    }

    protected QueryResult<R> getCachedRecordsAndTimeStamp() throws StateStoreUnavailableException {
        this.checkCacheAvailable();
        this.readLock.lock();
        try {
            QueryResult<R> queryResult = new QueryResult<R>(this.records, this.timestamp);
            return queryResult;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

