/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.lib.wsrs.Param;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public abstract class EnumSetParam<E extends Enum<E>>
extends Param<EnumSet<E>> {
    Class<E> klass;

    public EnumSetParam(String name, Class<E> e, EnumSet<E> defaultValue) {
        super(name, defaultValue);
        this.klass = e;
    }

    @Override
    protected EnumSet<E> parse(String str) throws Exception {
        EnumSet<E> set = EnumSet.noneOf(this.klass);
        if (!str.isEmpty()) {
            for (String sub : str.split(",")) {
                set.add(Enum.valueOf(this.klass, StringUtils.toUpperCase((String)sub.trim())));
            }
        }
        return set;
    }

    @Override
    protected String getDomain() {
        return Arrays.asList((Enum[])this.klass.getEnumConstants()).toString();
    }

    public static <E extends Enum<E>> String toString(EnumSet<E> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        Iterator i = set.iterator();
        b.append(i.next());
        while (i.hasNext()) {
            b.append(',').append(i.next());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return this.getName() + "=" + EnumSetParam.toString((EnumSet)this.value);
    }
}

