/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.lib.util.Check;

@InterfaceAudience.Private
public abstract class ConfigurationUtils {
    public static void copy(Configuration source, Configuration target) {
        Check.notNull(source, "source");
        Check.notNull(target, "target");
        for (Map.Entry entry : source) {
            target.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void injectDefaults(Configuration source, Configuration target) {
        Check.notNull(source, "source");
        Check.notNull(target, "target");
        for (Map.Entry entry : source) {
            if (target.get((String)entry.getKey()) != null) continue;
            target.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Configuration resolve(Configuration conf) {
        Configuration resolved = new Configuration(false);
        for (Map.Entry entry : conf) {
            resolved.set((String)entry.getKey(), conf.get((String)entry.getKey()));
        }
        return resolved;
    }

    public static void load(Configuration conf, InputStream is) throws IOException {
        conf.addResource(is);
    }
}

