/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.hdfs.DFSOpsCountStatistics;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDFSOpsCountStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(TestDFSOpsCountStatistics.class);
    private static final String NO_SUCH_OP = "no-such-dfs-operation-dude";
    private final DFSOpsCountStatistics statistics = new DFSOpsCountStatistics();
    private final Map<DFSOpsCountStatistics.OpType, AtomicLong> expectedOpsCountMap = new HashMap<DFSOpsCountStatistics.OpType, AtomicLong>();
    @Rule
    public final Timeout globalTimeout = new Timeout(10000);
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Before
    public void setup() {
        for (DFSOpsCountStatistics.OpType opType : DFSOpsCountStatistics.OpType.values()) {
            this.expectedOpsCountMap.put(opType, new AtomicLong());
        }
        this.incrementOpsCountByRandomNumbers();
    }

    @Test
    public void testOpTypeSymbolsAreUnique() {
        HashSet<String> opTypeSymbols = new HashSet<String>();
        for (DFSOpsCountStatistics.OpType opType : DFSOpsCountStatistics.OpType.values()) {
            Assert.assertFalse((boolean)opTypeSymbols.contains(opType.getSymbol()));
            opTypeSymbols.add(opType.getSymbol());
        }
        Assert.assertEquals((long)DFSOpsCountStatistics.OpType.values().length, (long)opTypeSymbols.size());
    }

    @Test
    public void testGetLongStatistics() {
        int iterations = 0;
        Iterator iter = this.statistics.getLongStatistics();
        while (iter.hasNext()) {
            StorageStatistics.LongStatistic longStat = (StorageStatistics.LongStatistic)iter.next();
            Assert.assertNotNull((Object)longStat);
            DFSOpsCountStatistics.OpType opType = DFSOpsCountStatistics.OpType.fromSymbol((String)longStat.getName());
            Assert.assertNotNull((Object)opType);
            Assert.assertTrue((boolean)this.expectedOpsCountMap.containsKey(opType));
            Assert.assertEquals((long)this.expectedOpsCountMap.get(opType).longValue(), (long)longStat.getValue());
            iterations = (short)(iterations + 1);
        }
        Assert.assertEquals((long)DFSOpsCountStatistics.OpType.values().length, (long)iterations);
    }

    @Test
    public void testGetLong() {
        Assert.assertNull((Object)this.statistics.getLong(null));
        Assert.assertNull((Object)this.statistics.getLong(NO_SUCH_OP));
        this.verifyStatistics();
    }

    @Test
    public void testIsTracked() {
        Assert.assertFalse((boolean)this.statistics.isTracked(null));
        Assert.assertFalse((boolean)this.statistics.isTracked(NO_SUCH_OP));
        Iterator iter = this.statistics.getLongStatistics();
        while (iter.hasNext()) {
            StorageStatistics.LongStatistic longStatistic = (StorageStatistics.LongStatistic)iter.next();
            Assert.assertTrue((boolean)this.statistics.isTracked(longStatistic.getName()));
        }
    }

    @Test
    public void testReset() {
        this.statistics.reset();
        for (DFSOpsCountStatistics.OpType opType : DFSOpsCountStatistics.OpType.values()) {
            this.expectedOpsCountMap.get(opType).set(0L);
        }
        Iterator iter = this.statistics.getLongStatistics();
        while (iter.hasNext()) {
            StorageStatistics.LongStatistic longStat = (StorageStatistics.LongStatistic)iter.next();
            Assert.assertEquals((long)0L, (long)longStat.getValue());
        }
        this.incrementOpsCountByRandomNumbers();
        this.verifyStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCurrentAccess() throws InterruptedException {
        int numThreads = 10;
        ExecutorService threadPool = HadoopExecutors.newFixedThreadPool((int)10);
        try {
            final CountDownLatch allReady = new CountDownLatch(10);
            final CountDownLatch startBlocker = new CountDownLatch(1);
            final CountDownLatch allDone = new CountDownLatch(10);
            final AtomicReference childError = new AtomicReference();
            for (int i = 0; i < 10; ++i) {
                threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        allReady.countDown();
                        try {
                            startBlocker.await();
                            TestDFSOpsCountStatistics.this.incrementOpsCountByRandomNumbers();
                        }
                        catch (Throwable t) {
                            LOG.error("Child failed when calling mkdir", t);
                            childError.compareAndSet(null, t);
                        }
                        finally {
                            allDone.countDown();
                        }
                    }
                });
            }
            allReady.await();
            startBlocker.countDown();
            allDone.await();
            Assert.assertNull((String)"Child failed with exception.", childError.get());
            this.verifyStatistics();
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    private void incrementOpsCountByRandomNumbers() {
        for (DFSOpsCountStatistics.OpType opType : DFSOpsCountStatistics.OpType.values()) {
            Long randomCount = RandomUtils.nextLong((long)0L, (long)100L);
            this.expectedOpsCountMap.get(opType).addAndGet(randomCount);
            for (long i = 0L; i < randomCount; ++i) {
                this.statistics.incrementOpCounter(opType);
            }
        }
    }

    private void verifyStatistics() {
        for (DFSOpsCountStatistics.OpType opType : DFSOpsCountStatistics.OpType.values()) {
            Assert.assertNotNull((Object)this.expectedOpsCountMap.get(opType));
            Assert.assertNotNull((Object)this.statistics.getLong(opType.getSymbol()));
            Assert.assertEquals((String)("Not expected count for operation " + opType.getSymbol()), (long)this.expectedOpsCountMap.get(opType).longValue(), (long)this.statistics.getLong(opType.getSymbol()));
        }
    }
}

